/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import libpadeldescriptor.PaDELHINReader;
import libpadeldescriptor.PaDELIteratingSMILESReader;
import libpadeldescriptor.PaDELPDBReader;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.io.formats.HINFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.io.formats.PDBFormat;
import org.openscience.cdk.io.formats.PubChemCompoundsXMLFormat;
import org.openscience.cdk.io.formats.PubChemSubstancesASNFormat;
import org.openscience.cdk.io.formats.PubChemSubstancesXMLFormat;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.io.iterator.IteratingMDLReader;
import org.openscience.cdk.io.iterator.IteratingPCCompoundASNReader;
import org.openscience.cdk.io.iterator.IteratingPCCompoundXMLReader;
import org.openscience.cdk.io.iterator.IteratingPCSubstancesXMLReader;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

public class IteratingPaDELReader
extends DefaultIteratingChemObjectReader {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IteratingPaDELReader.class);
    private IResourceFormat currentFormat;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IChemObjectBuilder builder;
    private IAtomContainer nextMolecule;
    private File molecule;
    private PaDELIteratingSMILESReader iteratingSMILESReader;
    private IteratingMDLReader iteratingMDLReader;
    private IteratingPCCompoundASNReader iteratingPCCompoundASNReader;
    private IteratingPCCompoundXMLReader iteratingPCCompoundXMLReader;
    private IteratingPCSubstancesXMLReader iteratingPCSubstancesXMLReader;
    private ISimpleChemObjectReader iSimpleChemObjectReader;
    private int curLigIndex;
    private List<IAtomContainer> container = new ArrayList<IAtomContainer>();

    public IteratingPaDELReader(File file) throws FileNotFoundException {
        this.builder = DefaultChemObjectBuilder.getInstance();
        this.molecule = file;
        this.setReader(new FileInputStream(file));
    }

    public IteratingPaDELReader(Reader reader, IChemObjectBuilder iChemObjectBuilder) {
        this.builder = iChemObjectBuilder;
        this.setReader(reader);
    }

    public IteratingPaDELReader(InputStream inputStream) {
        this(new InputStreamReader(inputStream), DefaultChemObjectBuilder.getInstance());
    }

    public IteratingPaDELReader(InputStream inputStream, IChemObjectBuilder iChemObjectBuilder) {
        this(new InputStreamReader(inputStream), iChemObjectBuilder);
    }

    @Override
    public IResourceFormat getFormat() {
        return this.currentFormat;
    }

    @Override
    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            if (this.currentFormat instanceof SMILESFormat) {
                if (this.iteratingSMILESReader.hasNext()) {
                    this.nextMolecule = (IAtomContainer)this.iteratingSMILESReader.next();
                    ++this.curLigIndex;
                    this.hasNext = true;
                } else {
                    this.hasNext = false;
                }
            } else if (this.currentFormat instanceof MDLFormat || this.currentFormat instanceof MDLV2000Format || this.currentFormat instanceof MDLV3000Format) {
                if (this.iteratingMDLReader.hasNext()) {
                    this.nextMolecule = this.iteratingMDLReader.next();
                    ++this.curLigIndex;
                    this.hasNext = true;
                } else {
                    this.hasNext = false;
                }
            } else if (this.currentFormat instanceof PubChemSubstancesASNFormat) {
                if (this.iteratingPCCompoundASNReader.hasNext()) {
                    this.nextMolecule = this.iteratingPCCompoundASNReader.next();
                    ++this.curLigIndex;
                    this.hasNext = true;
                } else {
                    this.hasNext = false;
                }
            } else if (this.currentFormat instanceof PubChemSubstancesXMLFormat) {
                if (this.iteratingPCSubstancesXMLReader.hasNext()) {
                    this.nextMolecule = (IAtomContainer)((Object)this.iteratingPCSubstancesXMLReader.next());
                    ++this.curLigIndex;
                    this.hasNext = true;
                } else {
                    this.hasNext = false;
                }
            } else if (this.currentFormat instanceof PubChemCompoundsXMLFormat) {
                if (this.iteratingPCCompoundXMLReader.hasNext()) {
                    this.nextMolecule = this.iteratingPCCompoundXMLReader.next();
                    ++this.curLigIndex;
                    this.hasNext = true;
                } else {
                    this.hasNext = false;
                }
            } else if (this.curLigIndex < this.container.size()) {
                this.nextMolecule = this.container.get(this.curLigIndex++);
                this.hasNext = true;
            } else {
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextMolecule = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    @Override
    public IChemObject next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        if (this.iteratingSMILESReader != null) {
            this.iteratingSMILESReader.close();
        }
        if (this.iteratingMDLReader != null) {
            this.iteratingMDLReader.close();
        }
        if (this.iteratingPCCompoundASNReader != null) {
            this.iteratingPCCompoundASNReader.close();
        }
        if (this.iteratingPCCompoundXMLReader != null) {
            this.iteratingPCCompoundXMLReader.close();
        }
        if (this.iteratingPCSubstancesXMLReader != null) {
            this.iteratingPCSubstancesXMLReader.close();
        }
        if (this.iSimpleChemObjectReader != null) {
            this.iSimpleChemObjectReader.close();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReader(Reader reader) {
        block18: {
            this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.nextAvailableIsKnown = false;
            this.curLigIndex = 0;
            try {
                if (this.molecule.getName().endsWith(".smi")) {
                    this.currentFormat = SMILESFormat.getInstance();
                } else if (this.molecule.getName().endsWith(".hin")) {
                    this.iSimpleChemObjectReader = new PaDELHINReader(this.input);
                    this.currentFormat = HINFormat.getInstance();
                } else {
                    this.iSimpleChemObjectReader = new ReaderFactory().createReader(this.input);
                    this.currentFormat = this.iSimpleChemObjectReader.getFormat();
                }
                if (this.currentFormat instanceof SMILESFormat) {
                    this.iteratingSMILESReader = new PaDELIteratingSMILESReader(this.input, this.builder);
                    break block18;
                }
                if (this.currentFormat instanceof MDLFormat || this.currentFormat instanceof MDLV2000Format || this.currentFormat instanceof MDLV3000Format) {
                    this.iteratingMDLReader = new IteratingMDLReader(this.input, this.builder);
                    break block18;
                }
                if (this.currentFormat instanceof PubChemSubstancesASNFormat) {
                    this.iteratingPCCompoundASNReader = new IteratingPCCompoundASNReader(this.input, this.builder);
                    break block18;
                }
                if (this.currentFormat instanceof PubChemSubstancesXMLFormat) {
                    this.iteratingPCSubstancesXMLReader = new IteratingPCSubstancesXMLReader(this.input, this.builder);
                    break block18;
                }
                if (this.currentFormat instanceof PubChemCompoundsXMLFormat) {
                    this.iteratingPCCompoundXMLReader = new IteratingPCCompoundXMLReader(this.input, this.builder);
                    break block18;
                }
                if (this.currentFormat instanceof PDBFormat) {
                    try {
                        PaDELPDBReader paDELPDBReader = new PaDELPDBReader(this.input);
                        ChemFile chemFile = new ChemFile();
                        paDELPDBReader.read(chemFile);
                        this.container.clear();
                        int n = chemFile.getChemSequenceCount();
                        for (int i = 0; i < n; ++i) {
                            IChemSequence iChemSequence = chemFile.getChemSequence(i);
                            int n2 = iChemSequence.getChemModelCount();
                            for (int j = 0; j < n2; ++j) {
                                IMoleculeSet iMoleculeSet = iChemSequence.getChemModel(j).getMoleculeSet();
                                int n3 = iMoleculeSet.getMoleculeCount();
                                for (int k = 0; k < n3; ++k) {
                                    this.container.add(iMoleculeSet.getMolecule(k));
                                }
                            }
                        }
                        break block18;
                    }
                    catch (CDKException cDKException) {
                        logger.error("Error while reading molecule: " + cDKException.getMessage());
                        break block18;
                    }
                }
                IChemFile iChemFile = (IChemFile)this.iSimpleChemObjectReader.read((IChemObject)this.builder.newInstance(IChemFile.class, new Object[0]));
                if (iChemFile != null) {
                    this.container = ChemFileManipulator.getAllAtomContainers(iChemFile);
                }
            }
            catch (Exception exception) {
                logger.error("Error while reading molecule: " + exception.getMessage());
                logger.debug(exception);
                this.nextAvailableIsKnown = true;
            }
        }
        this.nextMolecule = null;
        this.hasNext = false;
    }

    @Override
    public void setReader(InputStream inputStream) {
        this.setReader(new InputStreamReader(inputStream));
    }
}

