/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.data.experiment;

import ambit2.base.exceptions.AmbitIOException;
import ambit2.core.data.experiment.TemplateField;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StudyTemplate
extends ArrayList<TemplateField> {
    private static final long serialVersionUID = -9152728910421949089L;
    protected String source = "";
    protected TemplateField query = null;
    protected String name;
    protected int id;

    public StudyTemplate(String string) {
        this.setName(string);
    }

    public void addFields(String string, String string2, boolean bl, boolean bl2) {
        this.add(new TemplateField(string, string2, bl, bl2));
    }

    public TemplateField getField(Object object) {
        if (object instanceof TemplateField) {
            int n = this.indexOf((Object)((TemplateField)((Object)object)));
            if (n == -1) {
                return null;
            }
            return this.getField(n);
        }
        if (this.query == null) {
            this.query = new TemplateField();
        }
        this.query.setName(object.toString());
        int n = this.indexOf((Object)this.query);
        if (n == -1) {
            return null;
        }
        return this.getField(n);
    }

    public boolean save(OutputStream outputStream) throws AmbitIOException {
        try {
            this.save(new OutputStreamWriter(outputStream, "UTF-8"));
            return true;
        }
        catch (Exception exception) {
            throw new AmbitIOException((Throwable)exception);
        }
    }

    public boolean save(Writer writer) throws AmbitIOException {
        try {
            DOMSource dOMSource = new DOMSource(this.buildDocument());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "Yes");
            transformer.setOutputProperty("standalone", "Yes");
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(dOMSource, streamResult);
            writer.flush();
            return true;
        }
        catch (Exception exception) {
            throw new AmbitIOException((Throwable)exception);
        }
    }

    protected Document buildDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("template");
            element.setAttribute("name", this.getName());
            for (int i = 0; i < this.size(); ++i) {
                Element element2 = document.createElement("field");
                TemplateField templateField = (TemplateField)((Object)this.get(i));
                element2.setAttribute("name", templateField.getName());
                element2.setAttribute("units", templateField.getUnits());
                if (templateField.isNumeric()) {
                    element2.setAttribute("numeric", "True");
                } else {
                    element2.setAttribute("numeric", "False");
                }
                if (templateField.isResult()) {
                    element2.setAttribute("result", "True");
                } else {
                    element2.setAttribute("result", "False");
                }
                element.appendChild(element2);
            }
            document.appendChild(element);
            return document;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean load(InputStream inputStream) throws AmbitIOException {
        try {
            return this.load(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (Exception exception) {
            throw new AmbitIOException((Throwable)exception);
        }
    }

    public boolean load(Reader reader) throws AmbitIOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(reader));
            Element element = document.getDocumentElement();
            if ("template".equals(element.getNodeName())) {
                this.setName(element.getAttribute("name"));
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2;
                    String string;
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element) || !"field".equals(string = (element2 = (Element)node).getNodeName())) continue;
                    TemplateField templateField = new TemplateField(element2.getAttribute("name").toString());
                    templateField.setUnits(element2.getAttribute("units").toString());
                    String string2 = element2.getAttribute("numeric").toString();
                    templateField.setNumeric(string2.toLowerCase().equals("true"));
                    String string3 = element2.getAttribute("result").toString();
                    templateField.setResult(string3.toLowerCase().equals("true"));
                    this.add(templateField);
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new AmbitIOException((Throwable)exception);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public void getStudyConditions(Hashtable hashtable) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getField((Object)Integer.valueOf((int)i)).isResult) continue;
            TemplateField templateField = this.getField(i);
            if (templateField.getName().equals("Endpoint")) {
                hashtable.put(templateField, this.getName());
                continue;
            }
            hashtable.put(templateField, "");
        }
    }

    public void getStudyResults(Hashtable hashtable) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getField((Object)Integer.valueOf((int)i)).isResult) continue;
            hashtable.put(this.getField(i), "");
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

