/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.GMatrix;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;

public class GVector
implements Serializable {
    private int elementCount;
    private double[] elementData;

    public GVector(int length) {
        this.elementCount = length;
        this.elementData = new double[length];
    }

    public GVector(double[] vector) {
        this(vector.length);
        System.arraycopy(vector, 0, this.elementData, 0, this.elementCount);
    }

    public GVector(GVector vector) {
        this(vector.elementCount);
        System.arraycopy(vector.elementData, 0, this.elementData, 0, this.elementCount);
    }

    public GVector(Tuple2f tuple) {
        this(2);
        this.set(tuple);
    }

    public GVector(Tuple3f tuple) {
        this(3);
        this.set(tuple);
    }

    public GVector(Tuple3d tuple) {
        this(3);
        this.set(tuple);
    }

    public GVector(Tuple4f tuple) {
        this(4);
        this.set(tuple);
    }

    public GVector(Tuple4d tuple) {
        this(4);
        this.set(tuple);
    }

    public GVector(double[] vector, int length) {
        this(length);
        System.arraycopy(vector, 0, this.elementData, 0, this.elementCount);
    }

    public final double norm() {
        return Math.sqrt(this.normSquared());
    }

    public final double normSquared() {
        double s = 0.0;
        int i = 0;
        while (i < this.elementCount) {
            s += this.elementData[i] * this.elementData[i];
            ++i;
        }
        return s;
    }

    public final void normalize(GVector v1) {
        this.set(v1);
        this.normalize();
    }

    public final void normalize() {
        double len = this.norm();
        int i = 0;
        while (i < this.elementCount) {
            int n = i++;
            this.elementData[n] = this.elementData[n] / len;
        }
    }

    public final void scale(double s, GVector v1) {
        this.set(v1);
        this.scale(s);
    }

    public final void scale(double s) {
        int i = 0;
        while (i < this.elementCount) {
            int n = i++;
            this.elementData[n] = this.elementData[n] * s;
        }
    }

    public final void scaleAdd(double s, GVector v1, GVector v2) {
        double[] v1data = v1.elementData;
        double[] v2data = v2.elementData;
        if (this.elementCount != v1.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != v1's size:" + v1.elementCount);
        }
        if (this.elementCount != v2.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != v2's size:" + v2.elementCount);
        }
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = s * v1data[i] + v2data[i];
            ++i;
        }
    }

    public final void add(GVector vector) {
        double[] v1data = vector.elementData;
        if (this.elementCount != vector.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != v2's size:" + vector.elementCount);
        }
        int i = 0;
        while (i < this.elementCount) {
            int n = i;
            this.elementData[n] = this.elementData[n] + v1data[i];
            ++i;
        }
    }

    public final void add(GVector vector1, GVector vector2) {
        this.set(vector1);
        this.add(vector2);
    }

    public final void sub(GVector vector) {
        double[] v1data = vector.elementData;
        if (this.elementCount != vector.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != vector's size:" + vector.elementCount);
        }
        int i = 0;
        while (i < this.elementCount) {
            int n = i;
            this.elementData[n] = this.elementData[n] - v1data[i];
            ++i;
        }
    }

    public final void sub(GVector vector1, GVector vector2) {
        this.set(vector1);
        this.sub(vector2);
    }

    public final void mul(GMatrix m1, GVector v1) {
        double[] v1data = v1.elementData;
        int v1size = v1.elementCount;
        int nCol = m1.getNumCol();
        int nRow = m1.getNumRow();
        if (v1size != nCol) {
            throw new IllegalArgumentException("v1.size:" + v1size + " != m1.nCol:" + nCol);
        }
        if (this.elementCount != nRow) {
            throw new IllegalArgumentException("this.size:" + this.elementCount + " != m1.nRow:" + nRow);
        }
        int i = 0;
        while (i < this.elementCount) {
            double sum = 0.0;
            int j = 0;
            while (j < nCol) {
                sum += m1.getElement(i, j) * v1data[j];
                ++j;
            }
            this.elementData[i] = sum;
            ++i;
        }
    }

    public final void mul(GVector v1, GMatrix m1) {
        double[] v1data = v1.elementData;
        int v1size = v1.elementCount;
        int nCol = m1.getNumCol();
        int nRow = m1.getNumRow();
        if (v1size != nRow) {
            throw new IllegalArgumentException("v1.size:" + v1size + " != m1.nRow:" + nRow);
        }
        if (this.elementCount != nCol) {
            throw new IllegalArgumentException("this.size:" + this.elementCount + " != m1.nCol:" + nCol);
        }
        int i = 0;
        while (i < this.elementCount) {
            double sum = 0.0;
            int j = 0;
            while (j < nRow) {
                sum += m1.getElement(j, i) * v1data[j];
                ++j;
            }
            this.elementData[i] = sum;
            ++i;
        }
    }

    public final void negate() {
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = -this.elementData[i];
            ++i;
        }
    }

    public final void zero() {
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = 0.0;
            ++i;
        }
    }

    public final void setSize(int newSize) {
        if (newSize < 0) {
            throw new NegativeArraySizeException("newSize:" + newSize + " < 0");
        }
        if (this.elementCount < newSize) {
            double[] oldData = this.elementData;
            this.elementData = new double[newSize];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
        this.elementCount = newSize;
    }

    public final void set(double[] vector) {
        System.arraycopy(vector, 0, this.elementData, 0, this.elementCount);
    }

    public final void set(GVector vector) {
        System.arraycopy(vector.elementData, 0, this.elementData, 0, this.elementCount);
    }

    public final void set(Tuple2f tuple) {
        this.elementData[0] = tuple.x;
        this.elementData[1] = tuple.y;
    }

    public final void set(Tuple3f tuple) {
        this.elementData[0] = tuple.x;
        this.elementData[1] = tuple.y;
        this.elementData[2] = tuple.z;
    }

    public final void set(Tuple3d tuple) {
        this.elementData[0] = tuple.x;
        this.elementData[1] = tuple.y;
        this.elementData[2] = tuple.z;
    }

    public final void set(Tuple4f tuple) {
        this.elementData[0] = tuple.x;
        this.elementData[1] = tuple.y;
        this.elementData[2] = tuple.z;
        this.elementData[3] = tuple.w;
    }

    public final void set(Tuple4d tuple) {
        this.elementData[0] = tuple.x;
        this.elementData[1] = tuple.y;
        this.elementData[2] = tuple.z;
        this.elementData[3] = tuple.w;
    }

    public final int getSize() {
        return this.elementCount;
    }

    public final double getElement(int index) {
        try {
            return this.elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("index:" + index + "must be in [0, " + (this.elementCount - 1) + "]");
        }
    }

    public final void setElement(int index, double value) {
        try {
            this.elementData[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("index:" + index + " must be in [0, " + (this.elementCount - 1) + "]");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int i = 0;
        while (i < this.elementCount - 1) {
            buf.append(this.elementData[i]);
            buf.append(",");
            ++i;
        }
        buf.append(this.elementData[this.elementCount - 1]);
        buf.append(")");
        return buf.toString();
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.elementCount) {
            long bits = Double.doubleToLongBits(this.elementData[i]);
            hash ^= (int)(bits ^ bits >> 32);
            ++i;
        }
        return hash;
    }

    public boolean equals(GVector vector1) {
        if (vector1 == null) {
            return false;
        }
        if (this.elementCount != vector1.elementCount) {
            return false;
        }
        double[] v1data = vector1.elementData;
        int i = 0;
        while (i < this.elementCount) {
            if (this.elementData[i] != v1data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o1) {
        return o1 != null && o1 instanceof GVector && this.equals((GVector)o1);
    }

    public boolean epsilonEquals(GVector v1, double epsilon) {
        if (this.elementCount != v1.elementCount) {
            return false;
        }
        double[] v1data = v1.elementData;
        int i = 0;
        while (i < this.elementCount) {
            if (Math.abs(this.elementData[i] - v1data[i]) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final double dot(GVector v1) {
        double[] v1data = v1.elementData;
        if (this.elementCount != v1.elementCount) {
            throw new IllegalArgumentException("this.size:" + this.elementCount + " != v1.size:" + v1.elementCount);
        }
        double sum = 0.0;
        int i = 0;
        while (i < this.elementCount) {
            sum += this.elementData[i] * v1data[i];
            ++i;
        }
        return sum;
    }

    public final void SVDBackSolve(GMatrix U, GMatrix W, GMatrix V, GVector b) {
        if (this.elementCount != U.getNumRow() || this.elementCount != U.getNumCol()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != U.nRow,nCol:" + U.getNumRow() + "," + U.getNumCol());
        }
        if (this.elementCount != W.getNumRow()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != W.nRow:" + W.getNumRow());
        }
        if (b.elementCount != W.getNumCol()) {
            throw new ArrayIndexOutOfBoundsException("b.size:" + b.elementCount + " != W.nCol:" + W.getNumCol());
        }
        if (b.elementCount != V.getNumRow() || b.elementCount != V.getNumCol()) {
            throw new ArrayIndexOutOfBoundsException("b.size:" + this.elementCount + " != V.nRow,nCol:" + V.getNumRow() + "," + V.getNumCol());
        }
        int m = U.getNumRow();
        int n = V.getNumRow();
        double[] tmp = new double[n];
        int j = 0;
        while (j < n) {
            double s = 0.0;
            double wj = W.getElement(j, j);
            if (wj != 0.0) {
                int i = 0;
                while (i < m) {
                    s += U.getElement(i, j) * b.elementData[i];
                    ++i;
                }
                s /= wj;
            }
            tmp[j] = s;
            ++j;
        }
        int j2 = 0;
        while (j2 < n) {
            double s = 0.0;
            int jj = 0;
            while (jj < n) {
                s += V.getElement(j2, jj) * tmp[jj];
                ++jj;
            }
            this.elementData[j2] = s;
            ++j2;
        }
    }

    public final void LUDBackSolve(GMatrix LU, GVector b, GVector permutation) {
        if (this.elementCount != b.elementCount) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != b.size:" + b.elementCount);
        }
        if (this.elementCount != LU.getNumRow()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != LU.nRow:" + LU.getNumRow());
        }
        if (this.elementCount != LU.getNumCol()) {
            throw new ArrayIndexOutOfBoundsException("this.size:" + this.elementCount + " != LU.nCol:" + LU.getNumCol());
        }
        int n = this.elementCount;
        double[] indx = permutation.elementData;
        double[] x = this.elementData;
        double[] bdata = b.elementData;
        int i = 0;
        while (i < n) {
            x[i] = bdata[(int)indx[i]];
            ++i;
        }
        int ii = -1;
        int i2 = 0;
        while (i2 < n) {
            double sum = x[i2];
            if (0 <= ii) {
                int j = ii;
                while (j <= i2 - 1) {
                    sum -= LU.getElement(i2, j) * x[j];
                    ++j;
                }
            } else if (sum != 0.0) {
                ii = i2;
            }
            x[i2] = sum;
            ++i2;
        }
        int i3 = n - 1;
        while (i3 >= 0) {
            double sum = x[i3];
            int j = i3 + 1;
            while (j < n) {
                sum -= LU.getElement(i3, j) * x[j];
                ++j;
            }
            x[i3] = sum / LU.getElement(i3, i3);
            --i3;
        }
    }

    public final double angle(GVector v1) {
        return Math.acos(this.dot(v1) / this.norm() / v1.norm());
    }

    public final void interpolate(GVector v1, GVector v2, float alpha) {
        this.interpolate(v1, v2, (double)alpha);
    }

    public final void interpolate(GVector v1, float alpha) {
        this.interpolate(v1, (double)alpha);
    }

    public final void interpolate(GVector v1, GVector v2, double alpha) {
        this.set(v1);
        this.interpolate(v2, alpha);
    }

    public final void interpolate(GVector v1, double alpha) {
        double[] v1data = v1.elementData;
        if (this.elementCount != v1.elementCount) {
            throw new IllegalArgumentException("this.size:" + this.elementCount + " != v1.size:" + v1.elementCount);
        }
        double beta = 1.0 - alpha;
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = beta * this.elementData[i] + alpha * v1data[i];
            ++i;
        }
    }
}

