/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.tools;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.smsd.tools.TimeManagerTest")
public class TimeManager {
    private double startTime;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");

    @TestMethod(value="testTimeManager")
    public TimeManager() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.startTime = System.currentTimeMillis();
    }

    @TestMethod(value="testGetElapsedTimeInHours")
    public double getElapsedTimeInHours() {
        double currentTime = System.currentTimeMillis();
        return (currentTime - this.startTime) / 3600000.0;
    }

    @TestMethod(value="testGetElapsedTimeInMinutes")
    public double getElapsedTimeInMinutes() {
        double currentTime = System.currentTimeMillis();
        return (currentTime - this.startTime) / 60000.0;
    }

    @TestMethod(value="testGetElapsedTimeInSeconds")
    public double getElapsedTimeInSeconds() {
        double currentTime = System.currentTimeMillis();
        return (currentTime - this.startTime) / 1000.0;
    }

    @TestMethod(value="testGetElapsedTimeInMilliSeconds")
    public double getElapsedTimeInMilliSeconds() {
        double currentTime = System.currentTimeMillis();
        return currentTime - this.startTime;
    }
}

