/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure.key;

import ambit2.base.data.Property;
import ambit2.base.exceptions.AmbitException;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.base.processors.CASProcessor;
import ambit2.core.processors.structure.key.PropertyKey;
import org.openscience.cdk.index.CASNumber;

public class CASKey
extends PropertyKey<String> {
    private static final long serialVersionUID = 3848970585289051369L;
    protected Property key = null;
    protected CASProcessor transformer = new CASProcessor();

    @Override
    public boolean isKeyValid(Property property) {
        return property.isCAS();
    }

    @Override
    public String process(IStructureRecord iStructureRecord) throws AmbitException {
        Object object2;
        if (iStructureRecord == null) {
            throw new AmbitException("Empty molecule!");
        }
        if (this.key == null || iStructureRecord.getProperty(this.key) == null) {
            for (Object object2 : iStructureRecord.getProperties()) {
                Object object3 = iStructureRecord.getProperty(object2);
                if (object3 == null || !this.isKeyValid((Property)object2) || !CASNumber.isValid((String)(object3 = this.transformer.process(object3.toString())).toString())) continue;
                this.key = object2;
                return object3.toString();
            }
        }
        if (this.key == null) {
            throw new AmbitException("CAS tag not defined");
        }
        Object object4 = iStructureRecord.getProperty(this.key);
        if (object4 == null) {
            return null;
        }
        object2 = this.transformer.process(object4.toString());
        if (CASProcessor.isValidFormat((String)object2)) {
            return object2;
        }
        return null;
    }

    @Override
    protected boolean isValid(Object object, Object object2) {
        return CASProcessor.isValidFormat((String)object2.toString());
    }

    @Override
    public Class getType() {
        return String.class;
    }
}

