/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jmol.script.Token;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class DataManager {
    private Hashtable dataValues = new Hashtable();
    Viewer viewer;
    private float[] userVdws;
    int[] userVdwMars;
    int defaultVdw = 0;
    BitSet bsUserVdws;

    DataManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void clear() {
        this.dataValues.clear();
    }

    void setData(String string, Object[] objectArray, int n, int n2, int n3, int n4, int n5) {
        if (string == null) {
            this.clear();
            return;
        }
        if ((string = string.toLowerCase()).equals("element_vdw")) {
            String string2 = ((String)objectArray[1]).trim();
            if (string2.length() == 0) {
                this.userVdwMars = null;
                this.userVdws = null;
                this.bsUserVdws = null;
                return;
            }
            if (this.bsUserVdws == null) {
                this.setUserVdw(this.defaultVdw);
            }
            Parser.parseFloatArrayFromMatchAndField(string2, this.bsUserVdws, 1, 0, (int[])objectArray[2], 2, 0, this.userVdws, 1);
            int n6 = this.userVdws.length;
            while (--n6 >= 0) {
                this.userVdwMars[n6] = (int)(this.userVdws[n6] * 1000.0f);
            }
            return;
        }
        if (objectArray[2] != null && n > 0) {
            int n7;
            int n8;
            BitSet bitSet;
            boolean bl = n2 != 0 || n4 != Integer.MIN_VALUE && n4 != Integer.MAX_VALUE;
            Object[] objectArray2 = (Object[])this.dataValues.get(string);
            float[] fArray = objectArray2 == null || bl ? new float[n] : ArrayUtil.ensureLength((float[])objectArray2[1], n);
            String string3 = objectArray[1] instanceof String ? (String)objectArray[1] : null;
            float[] fArray2 = objectArray[1] instanceof float[] ? (float[])objectArray[1] : null;
            String[] stringArray = null;
            if (n4 == Integer.MIN_VALUE && (stringArray = Parser.getTokens(string3)).length > 1) {
                n4 = 0;
            }
            if (n4 == Integer.MIN_VALUE) {
                bitSet = (BitSet)objectArray[2];
                Parser.setSelectedFloats(Parser.parseFloat(string3), bitSet, fArray);
            } else if (n4 == 0 || n4 == Integer.MAX_VALUE) {
                bitSet = (BitSet)objectArray[2];
                if (fArray2 != null) {
                    n8 = bitSet.nextSetBit(0);
                    while (n8 >= 0) {
                        fArray[n8] = fArray2[n8];
                        n8 = bitSet.nextSetBit(n8 + 1);
                    }
                } else {
                    Parser.parseFloatArray(stringArray == null ? Parser.getTokens(string3) : stringArray, bitSet, fArray);
                }
            } else if (n2 <= 0) {
                bitSet = (BitSet)objectArray[2];
                Parser.parseFloatArrayFromMatchAndField(string3, bitSet, 0, 0, null, n4, n5, fArray, 1);
            } else {
                int[] nArray = (int[])objectArray[2];
                Parser.parseFloatArrayFromMatchAndField(string3, null, n2, n3, nArray, n4, n5, fArray, 1);
                bitSet = new BitSet();
                n7 = nArray.length;
                while (--n7 >= 0) {
                    if (nArray[n7] < 0) continue;
                    bitSet.set(nArray[n7]);
                }
            }
            if (objectArray2 != null && objectArray2[2] instanceof BitSet && !bl) {
                bitSet.or((BitSet)objectArray2[2]);
            }
            objectArray[2] = bitSet;
            objectArray[1] = fArray;
            if (string.indexOf("property_atom.") == 0) {
                n8 = Token.getSettableTokFromString(string = string.substring(14));
                if (n8 == 0) {
                    Logger.error("Unknown atom property: " + string);
                    return;
                }
                n7 = bitSet.cardinality();
                float[] fArray3 = new float[n7];
                int n9 = 0;
                int n10 = bitSet.nextSetBit(0);
                while (n9 < n7) {
                    fArray3[n9++] = fArray[n10];
                    n10 = bitSet.nextSetBit(n10 + 1);
                }
                this.viewer.setAtomProperty(bitSet, n8, 0, 0.0f, null, fArray3, null);
                return;
            }
        }
        this.dataValues.put(string, objectArray);
    }

    Object[] getData(String string) {
        if (this.dataValues == null || string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("types")) {
            Object[] objectArray = new String[]{"types", ""};
            int n = 0;
            Enumeration enumeration = this.dataValues.keys();
            while (enumeration.hasMoreElements()) {
                objectArray[1] = (String)objectArray[1] + (n++ > 0 ? "\n" : "") + enumeration.nextElement();
            }
            return objectArray;
        }
        return (Object[])this.dataValues.get(string);
    }

    float[] getDataFloat(String string) {
        if (this.dataValues == null) {
            return null;
        }
        Object[] objectArray = this.getData(string);
        if (objectArray == null || !(objectArray[1] instanceof float[])) {
            return null;
        }
        return (float[])objectArray[1];
    }

    float getDataFloat(String string, int n) {
        float[] fArray;
        Object[] objectArray;
        if (this.dataValues != null && (objectArray = this.getData(string)) != null && objectArray[1] instanceof float[] && n < (fArray = (float[])objectArray[1]).length) {
            return fArray[n];
        }
        return Float.NaN;
    }

    float[][] getDataFloat2D(String string) {
        if (this.dataValues == null) {
            return null;
        }
        Object[] objectArray = this.getData(string);
        if (objectArray == null || !(objectArray[1] instanceof float[][])) {
            return null;
        }
        return (float[][])objectArray[1];
    }

    float[][][] getDataFloat3D(String string) {
        if (this.dataValues == null) {
            return null;
        }
        Object[] objectArray = this.getData(string);
        if (objectArray == null || !(objectArray[1] instanceof float[][][])) {
            return null;
        }
        return (float[][][])objectArray[1];
    }

    void deleteModelAtoms(int n, int n2, BitSet bitSet) {
        if (this.dataValues == null) {
            return;
        }
        Enumeration enumeration = this.dataValues.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf("property_") != 0) continue;
            Object[] objectArray = (Object[])this.dataValues.get(string);
            BitSetUtil.deleteBits((BitSet)objectArray[2], bitSet);
            if (objectArray[1] instanceof float[]) {
                objectArray[1] = ArrayUtil.deleteElements((float[])objectArray[1], n, n2);
                continue;
            }
            if (!(objectArray[1] instanceof float[][])) continue;
            objectArray[1] = ArrayUtil.deleteElements((float[][])objectArray[1], n, n2);
        }
    }

    void getDataState(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string) {
        String string2;
        if (this.dataValues == null) {
            return;
        }
        Enumeration enumeration = this.dataValues.keys();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n = 0;
        if (string.length() > 0) {
            n = 1;
            stringBuffer3.append(string);
        }
        while (enumeration.hasMoreElements()) {
            Object object;
            string2 = (String)enumeration.nextElement();
            if (string2.indexOf("property_") == 0) {
                ++n;
                object = (Object[])this.dataValues.get(string2);
                Object object2 = object[1];
                if (object2 instanceof float[]) {
                    this.viewer.getAtomicPropertyState(stringBuffer3, (byte)13, (BitSet)object[2], string2, (float[])object2);
                    stringBuffer3.append("\n");
                    continue;
                }
                stringBuffer3.append("\n").append(Escape.encapsulateData(string2, object2));
                continue;
            }
            if (string2.indexOf("data2d") != 0 || !((object = ((Object[])this.dataValues.get(string2))[1]) instanceof float[][])) continue;
            ++n;
            stringBuffer3.append("\n").append(Escape.encapsulateData(string2, object));
        }
        if (this.userVdws != null && (string2 = this.getDefaultVdwNameOrData(9, this.bsUserVdws)).length() > 0) {
            ++n;
            stringBuffer3.append(string2);
        }
        if (n == 0) {
            return;
        }
        if (stringBuffer2 != null) {
            stringBuffer.append("function _setDataState() {\n");
        }
        stringBuffer.append(stringBuffer3);
        if (stringBuffer2 != null) {
            stringBuffer2.append("  _setDataState;\n");
            stringBuffer.append("}\n\n");
        }
    }

    private void setUserVdw(int n) {
        this.userVdwMars = new int[Elements.elementNumberMax];
        this.userVdws = new float[Elements.elementNumberMax];
        this.bsUserVdws = new BitSet();
        if (n == 9) {
            n = 0;
        }
        for (int i = 1; i < Elements.elementNumberMax; ++i) {
            this.userVdwMars[i] = JmolConstants.getVanderwaalsMar(i, n);
            this.userVdws[i] = (float)this.userVdwMars[i] / 1000.0f;
        }
    }

    void setDefaultVdw(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            default: {
                n = 0;
            }
        }
        if (n != this.defaultVdw && n == 9 && this.bsUserVdws == null) {
            this.setUserVdw(this.defaultVdw);
        }
        this.defaultVdw = n;
    }

    String getDefaultVdwNameOrData(int n, BitSet bitSet) {
        switch (n) {
            case -2147483648: {
                return JmolConstants.vdwLabels[this.defaultVdw];
            }
            case 0x7FFFFFFF: {
                bitSet = this.bsUserVdws;
                if (bitSet == null) {
                    return "";
                }
                n = 9;
                break;
            }
            case -1: 
            case 8: {
                n = this.defaultVdw;
            }
        }
        if (n == 9 && this.bsUserVdws == null) {
            this.setUserVdw(this.defaultVdw);
        }
        StringBuffer stringBuffer = new StringBuffer(JmolConstants.vdwLabels[n] + "\n");
        boolean bl = bitSet == null;
        int n2 = bl ? 1 : bitSet.nextSetBit(0);
        int n3 = bl ? Elements.elementNumberMax : bitSet.length();
        int n4 = n2;
        while (n4 < n3 && n4 >= 0) {
            stringBuffer.append(n4).append('\t').append(n == 9 ? this.userVdws[n4] : (float)JmolConstants.getVanderwaalsMar(n4, n) / 1000.0f).append('\t').append(Elements.elementSymbolFromNumber(n4)).append('\n');
            n4 = bl ? n4 + 1 : bitSet.nextSetBit(n4 + 1);
        }
        return bitSet == null ? stringBuffer.toString() : "\n  DATA \"element_vdw\"\n" + stringBuffer.append("  end \"element_vdw\";\n\n").toString();
    }

    static void getInlineData(StringBuffer stringBuffer, String string, boolean bl, String string2) {
        String string3 = (bl ? "append" : "model") + " inline";
        stringBuffer.append("load data \"").append(string3).append("\"\n").append(string).append("end \"").append(string3).append(string2 == null || string2.length() == 0 ? "" : " filter" + Escape.escape(string2)).append("\";");
    }
}

