/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Halos;
import org.jmol.shape.ShapeRenderer;

public class HalosRenderer
extends ShapeRenderer {
    boolean isAntialiased;

    protected void render() {
        boolean bl;
        Halos halos = (Halos)this.shape;
        boolean bl2 = this.viewer.getSelectionHaloEnabled(true);
        boolean bl3 = bl = bl2 && this.viewer.getShowHiddenSelectionHalos();
        if (halos.mads == null && halos.bsHighlight == null && !bl2) {
            return;
        }
        this.isAntialiased = this.g3d.isAntialiased();
        Atom[] atomArray = this.modelSet.atoms;
        BitSet bitSet = bl2 ? this.viewer.getSelectionSet(false) : null;
        int n = this.modelSet.getAtomCount();
        while (--n >= 0) {
            Atom atom = atomArray[n];
            if ((atom.getShapeVisibilityFlags() & 1) == 0) continue;
            boolean bl4 = this.modelSet.isAtomHidden(n);
            this.mad = halos.mads == null ? (short)0 : halos.mads[n];
            short s = this.colix = halos.colixes == null || n >= halos.colixes.length ? (short)0 : halos.colixes[n];
            if (bl2 && bitSet.get(n)) {
                if (bl4 && !bl) continue;
                if (this.mad == 0) {
                    this.mad = (short)-1;
                }
                if (this.colix == 0) {
                    this.colix = halos.colixSelection;
                }
                if (this.colix == 2) {
                    this.colix = (short)23;
                } else if (this.colix == 0) {
                    this.colix = Graphics3D.getColixInherited(this.colix, atom.getColix());
                }
            } else {
                if (bl4) continue;
                this.colix = Graphics3D.getColixInherited(this.colix, atom.getColix());
            }
            if (this.mad != 0) {
                this.render1(atom);
            }
            if (bl4 || halos.bsHighlight == null || !halos.bsHighlight.get(n)) continue;
            this.mad = (short)-2;
            this.colix = halos.colixHighlight;
            this.render1(atom);
        }
    }

    void render1(Atom atom) {
        float f;
        short s = this.mad == -2 ? (short)0 : Graphics3D.getColixTranslucent(this.colix, true, 0.5f);
        int n = atom.screenZ;
        short s2 = this.mad;
        if (s2 < 0) {
            s2 = atom.screenDiameter;
            if (s2 == 0) {
                f = atom.getADPMinMax(true);
                if (f > 0.0f) {
                    s2 = this.viewer.scaleToScreen(n, (int)(f * 2000.0f));
                }
                if (s2 == 0) {
                    s2 = this.viewer.scaleToScreen(n, this.mad == -2 ? 250 : 500);
                }
            }
        } else {
            s2 = this.viewer.scaleToScreen(n, this.mad);
        }
        f = s2;
        if (this.isAntialiased) {
            f /= 2.0f;
        }
        float f2 = f / 2.0f;
        if (this.mad == -2) {
            f2 /= 2.0f;
        }
        if (f2 < 8.0f) {
            f2 = 8.0f;
        }
        if (f2 > 20.0f) {
            f2 = 20.0f;
        }
        f += f2;
        if (this.isAntialiased) {
            f *= 2.0f;
        }
        if (f < 1.0f) {
            return;
        }
        this.g3d.drawFilledCircle(this.colix, s, (int)f, atom.screenX, atom.screenY, atom.screenZ);
    }
}

