/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Hashtable;
import java.util.List;
import org.jmol.api.Interface;
import org.jmol.api.MOCalculationInterface;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

class IsoMOReader
extends AtomDataReader {
    IsoMOReader(SurfaceGenerator surfaceGenerator) {
        super(surfaceGenerator);
    }

    protected void setup() {
        super.setup();
        this.doAddHydrogens = false;
        this.getAtoms(this.params.qm_marginAngstroms, true, false);
        this.setHeader("MO", "calculation type: " + this.params.moData.get("calculationType"));
        this.setRangesAndAddAtoms(this.params.qm_ptsPerAngstrom, this.params.qm_gridMax, this.myAtomCount);
        int n = this.params.title.length;
        while (--n >= 0) {
            this.fixTitleLine(n, this.params.mo);
        }
    }

    private void fixTitleLine(int n, Hashtable hashtable) {
        if (!this.fixTitleLine(n)) {
            return;
        }
        String string = this.params.title[n];
        int n2 = string.indexOf("%");
        if (string.length() == 0 || n2 < 0) {
            return;
        }
        int n3 = 0;
        if (string.indexOf("%F") >= 0) {
            string = TextFormat.formatString(string, "F", this.params.fileName);
        }
        if (string.indexOf("%I") >= 0) {
            string = TextFormat.formatString(string, "I", "" + this.params.qm_moNumber);
        }
        if (string.indexOf("%N") >= 0) {
            string = TextFormat.formatString(string, "N", "" + this.params.qmOrbitalCount);
        }
        if (string.indexOf("%E") >= 0) {
            string = TextFormat.formatString(string, "E", hashtable.containsKey("energy") && ++n3 != 0 ? "" + hashtable.get("energy") : "");
        }
        if (string.indexOf("%U") >= 0) {
            string = TextFormat.formatString(string, "U", this.params.moData.containsKey("energyUnits") && ++n3 != 0 ? (String)this.params.moData.get("energyUnits") : "");
        }
        if (string.indexOf("%S") >= 0) {
            string = TextFormat.formatString(string, "S", hashtable.containsKey("symmetry") && ++n3 != 0 ? "" + hashtable.get("symmetry") : "");
        }
        if (string.indexOf("%O") >= 0) {
            string = TextFormat.formatString(string, "O", hashtable.containsKey("occupancy") && ++n3 != 0 ? "" + hashtable.get("occupancy") : "");
        }
        if (string.indexOf("%T") >= 0) {
            string = TextFormat.formatString(string, "T", hashtable.containsKey("type") && ++n3 != 0 ? "" + hashtable.get("type") : "");
        }
        boolean bl = string.indexOf("?") == 0;
        this.params.title[n] = !bl ? string : (n3 > 0 && !string.trim().endsWith("=") ? string.substring(1) : "");
    }

    protected void generateCube() {
        this.voxelData = new float[this.nPointsX][this.nPointsY][this.nPointsZ];
        this.volumeData.voxelData = this.voxelData;
        MOCalculationInterface mOCalculationInterface = (MOCalculationInterface)Interface.getOptionInterface("quantum.MOCalculation");
        Hashtable hashtable = this.params.moData;
        float[] fArray = this.params.moCoefficients;
        int[][] nArray = this.params.dfCoefMaps;
        if (fArray == null) {
            List list = (List)hashtable.get("mos");
            if (list == null) {
                return;
            }
            int n = this.params.qm_moNumber;
            while (--n >= 0) {
                Logger.info(" generating isosurface data for MO " + (n + 1));
                Hashtable hashtable2 = (Hashtable)list.get(n);
                fArray = (float[])hashtable2.get("coefficients");
                nArray = (int[][])hashtable2.get("dfCoefMaps");
                this.getData(mOCalculationInterface, hashtable, fArray, nArray, this.params.theProperty);
            }
        } else {
            Logger.info("generating isosurface data for MO using cutoff " + this.params.cutoff);
            this.getData(mOCalculationInterface, hashtable, fArray, nArray, null);
        }
    }

    private void getData(MOCalculationInterface mOCalculationInterface, Hashtable hashtable, float[] fArray, int[][] nArray, float[] fArray2) {
        switch (this.params.qmOrbitalType) {
            case 1: {
                mOCalculationInterface.calculate(this.volumeData, this.bsMySelected, (String)hashtable.get("calculationType"), this.atomData.atomXyz, this.atomData.firstAtomIndex, (List)hashtable.get("shells"), (float[][])hashtable.get("gaussians"), nArray, null, fArray, fArray2, hashtable.get("isNormalized") == null);
                break;
            }
            case 2: {
                mOCalculationInterface.calculate(this.volumeData, this.bsMySelected, (String)hashtable.get("calculationType"), this.atomData.atomXyz, this.atomData.firstAtomIndex, null, null, null, hashtable.get("slaters"), fArray, fArray2, true);
                break;
            }
        }
    }
}

