/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import javax.vecmath.Point3f;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Node;
import org.jmol.modelset.Atom;

class Leaf
extends Element {
    Point3f[] tuples;

    Leaf(Bspt bspt) {
        this.bspt = bspt;
        this.count = 0;
        this.tuples = new Point3f[2];
    }

    Leaf(Bspt bspt, Leaf leaf, int n) {
        this(bspt);
        for (int i = n; i < 2; ++i) {
            this.tuples[this.count++] = leaf.tuples[i];
            leaf.tuples[i] = null;
        }
        leaf.count = n;
    }

    void sort(int n) {
        int n2 = this.count;
        while (--n2 > 0) {
            Point3f point3f = this.tuples[n2];
            float f = Node.getDimensionValue(point3f, n);
            int n3 = n2;
            while (--n3 >= 0) {
                Point3f point3f2 = this.tuples[n3];
                float f2 = Node.getDimensionValue(point3f2, n);
                if (!(f2 > f)) continue;
                this.tuples[n2] = point3f2;
                this.tuples[n3] = point3f;
                point3f = point3f2;
                f = f2;
            }
        }
    }

    Element addTuple(int n, Point3f point3f) {
        if (this.count < 2) {
            this.tuples[this.count++] = point3f;
            return this;
        }
        Node node = new Node(this.bspt, n, this);
        return node.addTuple(n, point3f);
    }

    void dump(int n, StringBuffer stringBuffer) {
        for (int i = 0; i < this.count; ++i) {
            Point3f point3f = this.tuples[i];
            for (int j = 0; j < n; ++j) {
                stringBuffer.append(".");
            }
            stringBuffer.append(point3f).append("Leaf ").append(i).append(": ").append(((Atom)point3f).getInfo());
        }
    }

    public String toString() {
        return "leaf:" + this.count + "\n";
    }
}

