/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.chemistry;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.chemistry.Compounds;
import com.rapidminer.operator.io.AbstractWriter;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.NonEqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.Mol2Writer;
import org.openscience.cdk.io.PDBWriter;
import org.openscience.cdk.io.SDFWriter;
import org.openscience.cdk.io.SMILESWriter;
import org.openscience.cdk.modeling.builder3d.ModelBuilder3D;
import org.openscience.cdk.modeling.builder3d.TemplateHandler3D;

public class CompoundWriter
extends AbstractWriter<Compounds> {
    public static final String PARAMETER_MOL_TYPE = "molecular_format";
    public static final String PARAMETER_USE_NAME = "use_compound_name_as_filename";
    public static final String PARAMETER_MOL_DIR = "directory_to_write_files";
    public static final String PARAMETER_MOL_FILE = "file_to_write_compound";
    public static final String PARAMETER_SDF_FILE = "sdf_file_to_write_compounds";
    public static final String PARAMETER_CPD_INDEX = "index_of_compound_to_write";
    public static final String[] typeStrings = new String[]{"MDL (mol)", "PDB (pdb)", "SDF (SDF)", "SMILES (smi)", "Sybyl (mol2)"};
    public static final String[] typeExtStrings = new String[]{".mol", ".pdb", ".sdf", ".smi", ".mol2"};

    public CompoundWriter(OperatorDescription operatorDescription) {
        super(operatorDescription, Compounds.class);
    }

    public List<ParameterType> getParameterTypes() {
        List list = super.getParameterTypes();
        ParameterTypeCategory parameterTypeCategory = null;
        parameterTypeCategory = new ParameterTypeCategory(PARAMETER_MOL_TYPE, "Molecular format to write the compounds.", typeStrings, 0);
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        parameterTypeCategory = new ParameterTypeBoolean(PARAMETER_USE_NAME, "Use compound name as filename. Files will be overwritten if two compounds have the same name.", true);
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        parameterTypeCategory = new ParameterTypeDirectory(PARAMETER_MOL_DIR, "Directory to write the molecular files.", true);
        parameterTypeCategory.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_NAME, true, true));
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        parameterTypeCategory = new ParameterTypeFile(PARAMETER_MOL_FILE, "Filename of molecular file to write compound.", null, true);
        parameterTypeCategory.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_NAME, true, false));
        parameterTypeCategory.registerDependencyCondition((ParameterCondition)new NonEqualTypeCondition((ParameterHandler)this, PARAMETER_MOL_TYPE, typeStrings, true, new int[]{2}));
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        parameterTypeCategory = new ParameterTypeFile(PARAMETER_SDF_FILE, "Filename of molecular file to write compounds.", null, true);
        parameterTypeCategory.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_NAME, true, false));
        parameterTypeCategory.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_MOL_TYPE, typeStrings, true, new int[]{2}));
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        parameterTypeCategory = new ParameterTypeInt(PARAMETER_CPD_INDEX, "Index of compound to write to molecular file.", 1, Integer.MAX_VALUE, 1);
        parameterTypeCategory.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_NAME, true, false));
        parameterTypeCategory.registerDependencyCondition((ParameterCondition)new NonEqualTypeCondition((ParameterHandler)this, PARAMETER_MOL_TYPE, typeStrings, true, new int[]{2}));
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Compounds write(Compounds compounds) throws OperatorException {
        if (this.getParameterAsBoolean(PARAMETER_USE_NAME)) {
            String string = this.getParameterAsString(PARAMETER_MOL_DIR);
            File file = new File(string);
            boolean bl = file.exists();
            if (!bl) {
                bl = file.mkdirs();
            }
            if (!bl) throw new OperatorException("Cannot create directory: " + string);
            int n = compounds.size();
            for (int i = 0; i < n; ++i) {
                this.WriteMolecule(string + File.separator + compounds.getMoleculeName(i), compounds.getMolecule(i));
            }
            return compounds;
        }
        int n = this.getParameterAsInt(PARAMETER_MOL_TYPE);
        if (n != 2) {
            int n2 = this.getParameterAsInt(PARAMETER_CPD_INDEX) - 1;
            this.WriteMolecule(this.getParameterAsString(PARAMETER_MOL_FILE), compounds.getMolecule(n2));
            return compounds;
        }
        SDFWriter sDFWriter = null;
        String string = this.getParameterAsString(PARAMETER_SDF_FILE);
        try {
            int n3 = string.lastIndexOf(".");
            string = string + (n3 != -1 && string.substring(n3).equals(typeExtStrings[n]) ? "" : typeExtStrings[n]);
            FileWriter fileWriter = new FileWriter(string);
            sDFWriter = new SDFWriter((Writer)fileWriter);
            int n4 = compounds.size();
            for (int i = 0; i < n4; ++i) {
                sDFWriter.write((IChemObject)compounds.getMolecule(i));
            }
            return compounds;
        }
        catch (Exception exception) {
            throw new OperatorException("Cannot write molecular file: " + string);
        }
        finally {
            if (sDFWriter != null) {
                try {
                    sDFWriter.close();
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.FINE, null, exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void WriteMolecule(String string, IAtomContainer iAtomContainer) throws OperatorException {
        block22: {
            MDLV2000Writer mDLV2000Writer = null;
            int n = this.getParameterAsInt(PARAMETER_MOL_TYPE);
            try {
                int n2 = string.lastIndexOf(".");
                string = string + (n2 != -1 && string.substring(n2).equals(typeExtStrings[n]) ? "" : typeExtStrings[n]);
                FileWriter fileWriter = new FileWriter(string);
                switch (n) {
                    case 0: {
                        mDLV2000Writer = new MDLV2000Writer((Writer)fileWriter);
                        break;
                    }
                    case 1: {
                        mDLV2000Writer = new PDBWriter((Writer)fileWriter);
                        break;
                    }
                    case 2: {
                        mDLV2000Writer = new SDFWriter((Writer)fileWriter);
                        break;
                    }
                    case 3: {
                        mDLV2000Writer = new SMILESWriter((Writer)fileWriter);
                        break;
                    }
                    case 4: {
                        mDLV2000Writer = new Mol2Writer((Writer)fileWriter);
                    }
                }
                mDLV2000Writer.write((IChemObject)iAtomContainer);
            }
            catch (Exception exception) {
                if (n == 1) {
                    try {
                        TemplateHandler3D templateHandler3D = TemplateHandler3D.getInstance();
                        ModelBuilder3D modelBuilder3D = ModelBuilder3D.getInstance((TemplateHandler3D)templateHandler3D, (String)"mm2");
                        iAtomContainer = modelBuilder3D.generate3DCoordinates((IMolecule)iAtomContainer, true);
                        mDLV2000Writer.write((IChemObject)iAtomContainer);
                        break block22;
                    }
                    catch (Exception exception2) {
                        throw new OperatorException("Cannot write molecular file: " + string);
                    }
                }
                throw new OperatorException("Cannot write molecular file: " + string);
            }
            finally {
                if (mDLV2000Writer != null) {
                    try {
                        mDLV2000Writer.close();
                    }
                    catch (Exception exception) {
                        Logger.getLogger("global").log(Level.FINE, null, exception);
                    }
                }
            }
        }
    }
}

