/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.chemistry;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.chemistry.CompoundAbstractProcessing;
import com.rapidminer.operator.chemistry.Compounds;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesGenerator;

public class CompoundGetSMILES
extends CompoundAbstractProcessing {
    public static final String PARAMETER_DETECT_AROMATICITY = "detect_aromaticity";

    public CompoundGetSMILES(OperatorDescription operatorDescription) {
        super(operatorDescription);
    }

    public List<ParameterType> getParameterTypes() {
        List list = super.getParameterTypes();
        ParameterTypeBoolean parameterTypeBoolean = null;
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_DETECT_AROMATICITY, "Detect and show aromaticity in the SMILES structure.", true);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        return list;
    }

    public void doWork() throws OperatorException {
        Compounds compounds = (Compounds)this.molInput.getData();
        Compounds compounds2 = new Compounds();
        boolean bl = this.getParameterAsBoolean(PARAMETER_DETECT_AROMATICITY);
        ArrayList<String> arrayList = new ArrayList<String>(compounds.size());
        int n = compounds.size();
        for (int i = 0; i < n; ++i) {
            IAtomContainer iAtomContainer = compounds.getMolecule(i);
            try {
                compounds2.addMolecule(iAtomContainer.clone());
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.FINE, null, exception);
            }
            arrayList.add(new SmilesGenerator(bl).createSMILES(iAtomContainer));
        }
        compounds.addColumn("SMILES", arrayList.toArray(new String[0]));
        this.molOriginal.deliver((IOObject)compounds2);
        this.molOutput.deliver((IOObject)compounds);
    }
}

