/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.data;

import ambit2.base.data.Profile;
import ambit2.base.data.Property;
import ambit2.base.data.TypedDefaultListModel;
import ambit2.base.data.TypedListModel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ProfileListModel
extends AbstractListModel
implements TypedListModel<Property>,
ListDataListener {
    protected TypedListModel<Property> fields;
    protected List<Integer> visibleIndex = new ArrayList<Integer>();
    protected Boolean visibility = null;
    private static final long serialVersionUID = -7758488965678782461L;

    public ProfileListModel(Profile<Property> profile) {
        this(profile, null);
    }

    public ProfileListModel(Profile<Property> profile, Boolean bl) {
        this.visibility = bl;
        TypedDefaultListModel typedDefaultListModel = new TypedDefaultListModel();
        Iterator<Property> iterator = profile.iterator();
        while (iterator.hasNext()) {
            typedDefaultListModel.addElement(iterator.next());
        }
        this.fields = typedDefaultListModel;
        if (this.fields != null) {
            this.fields.addListDataListener(this);
        }
        this.setVisible(bl);
    }

    public ProfileListModel(Hashtable<String, Profile<Property>> hashtable, Boolean bl) {
        this.visibility = bl;
        TypedDefaultListModel typedDefaultListModel = new TypedDefaultListModel();
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Profile<Property> profile = hashtable.get(string);
            System.out.println(string);
            Iterator<Property> iterator = profile.iterator();
            while (iterator.hasNext()) {
                Property property = iterator.next();
                if (!property.isEnabled()) continue;
                typedDefaultListModel.addElement(property);
                System.out.println(property);
            }
        }
        typedDefaultListModel.sort();
        this.fields = typedDefaultListModel;
        if (this.fields != null) {
            this.fields.addListDataListener(this);
        }
        this.setVisible(bl);
    }

    public ProfileListModel(TypedListModel<Property> typedListModel) {
        this(typedListModel, null);
    }

    public ProfileListModel(TypedListModel<Property> typedListModel, Boolean bl) {
        this.visibility = bl;
        this.fields = typedListModel;
        if (typedListModel != null) {
            typedListModel.addListDataListener(this);
        }
        this.setVisible(bl);
    }

    protected void setVisible(Boolean bl) {
        this.visibleIndex.clear();
        if (this.fields == null) {
            return;
        }
        for (int i = 0; i < this.fields.getSize(); ++i) {
            if (bl != null && bl ^ this.fields.getElementAt(i).isEnabled()) continue;
            this.visibleIndex.add(i);
        }
    }

    protected Property addElement(Property property, Boolean bl) {
        if (bl == null || !(bl ^ property.isEnabled())) {
            this.visibleIndex.add(this.fields.getSize() - 1);
        }
        return property;
    }

    @Override
    public Property getElementAt(int n) {
        int n2 = this.getVisibleIndex(n);
        if (n2 >= 0) {
            return this.fields.getElementAt(n2);
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.visibleIndex.size();
    }

    protected int getVisibleIndex(int n) {
        if (n < this.visibleIndex.size()) {
            return this.visibleIndex.get(n);
        }
        return 0;
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setVisible(this.visibility);
        this.fireContentsChanged(this, this.getVisibleIndex(listDataEvent.getIndex0()), this.getVisibleIndex(listDataEvent.getIndex1()));
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setVisible(this.visibility);
        this.fireIntervalAdded(this, this.getVisibleIndex(listDataEvent.getIndex0()), this.getVisibleIndex(listDataEvent.getIndex1()));
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setVisible(this.visibility);
        this.fireIntervalRemoved(this, this.getVisibleIndex(listDataEvent.getIndex0()), this.getVisibleIndex(listDataEvent.getIndex1()));
    }
}

