/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.smarts.RingQueryBond;
import ambit2.smarts.SmartsConst;
import ambit2.smarts.SmartsLogicalExpression;
import java.util.Vector;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSBond;

public class SmartsBondExpression
extends SMARTSBond {
    private static final long serialVersionUID = -93456789328678678L;
    public Vector<Integer> tokens = new Vector();

    public boolean matches(IBond bond) {
        SmartsLogicalExpression sle = new SmartsLogicalExpression();
        for (int i = 0; i < this.tokens.size(); ++i) {
            int tok = this.tokens.get(i);
            if (tok < 1000) {
                sle.addArgument(this.getArgument(tok, bond));
                continue;
            }
            sle.addLogOperation(tok - 1000);
        }
        return sle.getValue();
    }

    boolean getArgument(int boType, IBond bond) {
        switch (boType) {
            case 1: {
                if (bond.getOrder() != IBond.Order.SINGLE || bond.getFlag(5)) break;
                return true;
            }
            case 2: {
                if (bond.getOrder() != IBond.Order.DOUBLE) break;
                return true;
            }
            case 3: {
                if (bond.getOrder() != IBond.Order.TRIPLE) break;
                return true;
            }
            case 4: {
                if (!bond.getFlag(5)) break;
                return true;
            }
            case 5: {
                if (!RingQueryBond.isRingBond(bond)) break;
                return true;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (bond.getOrder() != IBond.Order.SINGLE) break;
                return true;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.tokens.size(); ++i) {
            int tok = this.tokens.get(i);
            if (tok < 1000) {
                if (tok < 8) {
                    sb.append(SmartsConst.BondChars[tok]);
                    continue;
                }
                if (tok == 8) {
                    sb.append("/?");
                    continue;
                }
                sb.append("\\?");
                continue;
            }
            sb.append(SmartsConst.LogOperationChars[tok - 1000]);
        }
        return sb.toString();
    }
}

