/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar;

import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.IBondDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public abstract class AbstractBondDescriptor
implements IBondDescriptor {
    private static final String PREVIOUS_ATOMCONTAINER = "previousAtomContainer";
    private Map cachedDescriptorValues = null;

    public boolean isCachedAtomContainer(IAtomContainer container) {
        if (this.cachedDescriptorValues == null) {
            return false;
        }
        return this.cachedDescriptorValues.get(PREVIOUS_ATOMCONTAINER) == container;
    }

    public IDescriptorResult getCachedDescriptorValue(IBond bond) {
        if (this.cachedDescriptorValues == null) {
            return null;
        }
        return (IDescriptorResult)this.cachedDescriptorValues.get(bond);
    }

    public void cacheDescriptorValue(IBond bond, IAtomContainer container, IDescriptorResult doubleResult) {
        if (this.cachedDescriptorValues == null) {
            this.cachedDescriptorValues = new HashMap();
            this.cachedDescriptorValues.put(PREVIOUS_ATOMCONTAINER, container);
        } else if (this.cachedDescriptorValues.get(PREVIOUS_ATOMCONTAINER) != container) {
            this.cachedDescriptorValues.clear();
            this.cachedDescriptorValues.put(PREVIOUS_ATOMCONTAINER, container);
        }
        this.cachedDescriptorValues.put(bond, doubleResult);
    }
}

