/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.AtomParity;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomParity;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugAtomParity
extends AtomParity
implements IAtomParity {
    private static final long serialVersionUID = 6305428844566539948L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugAtomParity.class);

    public DebugAtomParity(IAtom centralAtom, IAtom first, IAtom second, IAtom third, IAtom fourth, int parity) {
        super(centralAtom, first, second, third, fourth, parity);
    }

    @Override
    public IAtom getAtom() {
        this.logger.debug("Getting atom: ", super.getAtom());
        return super.getAtom();
    }

    @Override
    public IAtom[] getSurroundingAtoms() {
        this.logger.debug("Getting surrounding atoms: ", super.getSurroundingAtoms().length);
        return super.getSurroundingAtoms();
    }

    @Override
    @TestMethod(value="testMap_Map_Map,testMap_Null_Map,testMap_Map_Map_NullElement,testMap_Map_Map_EmptyMapping")
    public IAtomParity map(Map<IAtom, IAtom> atoms, Map<IBond, IBond> bonds) {
        this.logger.debug("Mapping atom parity: " + atoms);
        if (atoms == null) {
            throw new IllegalArgumentException("null atom mapping provided");
        }
        IAtom[] neighbors = this.getSurroundingAtoms();
        return new DebugAtomParity(this.getAtom() != null ? atoms.get(this.getAtom()) : null, neighbors[0] != null ? atoms.get(neighbors[0]) : null, neighbors[1] != null ? atoms.get(neighbors[1]) : null, neighbors[2] != null ? atoms.get(neighbors[2]) : null, neighbors[3] != null ? atoms.get(neighbors[3]) : null, this.getParity());
    }

    @Override
    public int getParity() {
        this.logger.debug("Getting atom parity: ", super.getParity());
        return super.getParity();
    }
}

