/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.groups;

import ambit2.core.groups.AbstractGroup;
import ambit2.core.groups.ISGroup;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;

public class ContainerGroup
extends AbstractGroup {
    protected List<ISGroup> components;
    protected SGROUP_MIXTURE type = SGROUP_MIXTURE.MIXTURE;
    private static final long serialVersionUID = -557546576995848521L;

    public ContainerGroup(String string, int n) {
        this(string, n, SGROUP_MIXTURE.FORMULATION);
    }

    public ContainerGroup(String string, int n, SGROUP_MIXTURE sGROUP_MIXTURE) {
        super(string, n);
        this.setType(sGROUP_MIXTURE);
        this.components = new ArrayList<ISGroup>();
        this.bonds = new ArrayList();
        ContainerGroup.setGroupVisible((IChemObject)this, false);
        this.setPoint2d(new Point2d(0.0, 0.0));
    }

    @Override
    public void finalizeAtomList(IAtomContainer iAtomContainer) {
        this.addBondsConnected2Atoms(iAtomContainer, this.atoms, this.bonds);
    }

    public synchronized List<ISGroup> getComponents() {
        return this.components;
    }

    public synchronized void setComponents(List<ISGroup> list) {
        this.components = list;
    }

    public synchronized SGROUP_MIXTURE getType() {
        return this.type;
    }

    public synchronized void setType(SGROUP_MIXTURE sGROUP_MIXTURE) {
        this.type = sGROUP_MIXTURE;
        switch (sGROUP_MIXTURE) {
            case MIXTURE: {
                this.setSubscript("mix");
                return;
            }
            case FORMULATION: {
                this.setSubscript("f");
                return;
            }
        }
        this.setSubscript("unknown");
    }

    public static enum SGROUP_MIXTURE {
        MIXTURE,
        FORMULATION,
        COPOLYMER;

    }
}

