/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class XyzReader
extends AtomSetCollectionReader {
    protected boolean checkLine() throws Exception {
        int n = this.parseInt(this.line);
        if (n == Integer.MIN_VALUE) {
            this.continuing = false;
            return false;
        }
        this.vibrationNumber = ++this.modelNumber;
        if (this.desiredVibrationNumber <= 0 ? this.doGetModel(this.modelNumber) : this.doGetVibration(this.vibrationNumber)) {
            this.readLine();
            this.checkLineForScript();
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setAtomSetName(this.line);
            this.readAtoms(n);
            this.applySymmetryAndSetTrajectory();
            if (this.isLastModel(this.modelNumber)) {
                this.continuing = false;
                return false;
            }
        } else {
            this.discardLines(n + 1);
        }
        this.discardLinesUntilNonBlank();
        return false;
    }

    private void readAtoms(int n) throws Exception {
        block4: for (int i = 0; i < n; ++i) {
            this.readLine();
            String[] stringArray = this.getTokens();
            if (stringArray.length < 4) {
                Logger.warn("line cannot be read for XYZ atom data: " + this.line);
                continue;
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            String string = stringArray[0];
            int n2 = this.parseInt(string);
            if (n2 == Integer.MIN_VALUE) {
                atom.elementSymbol = string;
            } else {
                string = string.substring(("" + n2).length());
                atom.elementNumber = (short)((n2 << 7) + JmolAdapter.getElementNumber(string));
            }
            atom.x = this.parseFloat(stringArray[1]);
            atom.y = this.parseFloat(stringArray[2]);
            atom.z = this.parseFloat(stringArray[3]);
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("line cannot be read for XYZ atom data: " + this.line);
                atom.set(0.0f, 0.0f, 0.0f);
            }
            int n3 = 4;
            this.setAtomCoord(atom);
            switch (stringArray.length) {
                case 4: 
                case 6: {
                    continue block4;
                }
                case 5: 
                case 8: 
                case 9: {
                    string = stringArray[4];
                    if (string.indexOf(".") >= 0) {
                        atom.partialCharge = this.parseFloat(string);
                    } else {
                        int n4 = this.parseInt(string);
                        if (n4 != Integer.MIN_VALUE) {
                            atom.formalCharge = n4;
                        }
                    }
                    if (stringArray.length == 5) continue block4;
                    if (stringArray.length == 9) {
                        atom.atomSerial = this.parseInt(stringArray[8]);
                    }
                }
                default: {
                    int n5 = ++n3;
                    float f = this.parseFloat(stringArray[n5]);
                    int n6 = ++n3;
                    float f2 = this.parseFloat(stringArray[n6]);
                    int n7 = ++n3;
                    ++n3;
                    float f3 = this.parseFloat(stringArray[n7]);
                    if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) continue block4;
                    this.atomSetCollection.addVibrationVector(atom.atomIndex, f, f2, f3);
                }
            }
        }
    }
}

