/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.uuid;

import com.hp.hpl.jena.shared.uuid.Bits;
import com.hp.hpl.jena.shared.uuid.JenaUUID;
import com.hp.hpl.jena.shared.uuid.UUID_V1_Gen;

public class UUID_V1
extends JenaUUID {
    public static final int version = 1;
    public static final int variant = 2;
    long bitsMostSignificant;
    long bitsLeastSignificant;

    UUID_V1(long mostSigBits, long leastSigBits) {
        if (!this.check(mostSigBits, leastSigBits)) {
            this.check(mostSigBits, leastSigBits);
            throw new IllegalArgumentException("Funny bits");
        }
        this.bitsMostSignificant = mostSigBits;
        this.bitsLeastSignificant = leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.bitsMostSignificant;
    }

    public long getLeastSignificantBits() {
        return this.bitsLeastSignificant;
    }

    private boolean check(long mostSigBits, long leastSigBits) {
        int _variant = this._getVariant(mostSigBits, leastSigBits);
        int _version = this._getVersion(mostSigBits, leastSigBits);
        if (_variant != 2) {
            return false;
        }
        return _version == 1;
    }

    public String toString() {
        return UUID_V1_Gen.unparse(this);
    }

    public int hashCode() {
        return (int)Bits.unpack(this.bitsMostSignificant, 32, 64);
    }

    public boolean equals(Object other) {
        if (!(other instanceof UUID_V1)) {
            return false;
        }
        UUID_V1 x = (UUID_V1)other;
        return this.bitsMostSignificant == x.bitsMostSignificant && this.bitsLeastSignificant == x.bitsLeastSignificant;
    }

    long getTimeHigh() {
        return Bits.unpack(this.bitsMostSignificant, 0, 12);
    }

    long getTimeMid() {
        return Bits.unpack(this.bitsMostSignificant, 16, 32);
    }

    long getTimeLow() {
        return Bits.unpack(this.bitsMostSignificant, 32, 64);
    }

    public long getTimestamp() {
        return this.getTimeLow() | this.getTimeMid() << 32 | this.getTimeHigh() << 48;
    }

    public long getClockSequence() {
        return Bits.unpack(this.bitsLeastSignificant, 48, 62);
    }

    public long getNode() {
        return Bits.unpack(this.bitsLeastSignificant, 0, 48);
    }

    public int getVersion() {
        return super._getVersion(this.bitsMostSignificant, this.bitsLeastSignificant);
    }

    public int getVariant() {
        return super._getVariant(this.bitsMostSignificant, this.bitsLeastSignificant);
    }
}

