/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;

public class CDK_Fingerprint
extends Thread {
    protected IFingerprinter cdkFingerprinter_;
    protected IAtomContainer molecule_;
    protected String[] descriptorNames_ = null;
    protected String[] descriptorValues_;
    protected String prefix_;
    protected String errorCode_ = "";
    protected int maxFingerprints_ = 0;

    @Override
    public void run() {
        try {
            this.initDescriptorsValues();
            BitSet bitSet = this.cdkFingerprinter_.getFingerprint(this.molecule_);
            String string = Integer.toString(1);
            String string2 = Integer.toString(0);
            int n = this.getFingerprintCount();
            for (int i = 0; i < n; ++i) {
                if (bitSet.get(i)) {
                    this.descriptorValues_[i] = string;
                    continue;
                }
                if (bitSet.get(i)) continue;
                this.descriptorValues_[i] = string2;
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.SEVERE, "Fingerprinter error", exception);
        }
    }

    @Override
    public void interrupt() {
        this.molecule_ = null;
        this.stop();
        super.interrupt();
    }

    public void initDescriptorsValues() {
        int n = this.getFingerprintCount();
        this.descriptorValues_ = new String[n];
        for (int i = 0; i < n; ++i) {
            this.descriptorValues_[i] = this.errorCode_;
        }
    }

    public int getFingerprintCount() {
        if (this.maxFingerprints_ == 0) {
            this.maxFingerprints_ = this.cdkFingerprinter_.getSize();
        }
        return this.maxFingerprints_;
    }

    public String[] getDescriptorNames() {
        if (this.descriptorNames_ == null) {
            int n = this.getFingerprintCount();
            this.descriptorNames_ = new String[n];
            for (int i = 0; i < n; ++i) {
                this.descriptorNames_[i] = this.prefix_ + Integer.toString(i + 1);
            }
        }
        return this.descriptorNames_;
    }

    public void setMolecule(IAtomContainer iAtomContainer) {
        this.molecule_ = iAtomContainer;
        this.initDescriptorsValues();
    }

    public void setPrefix(String string) {
        this.prefix_ = string;
    }

    public void setErrorCode(String string) {
        this.errorCode_ = string;
    }
}

