/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.IDeduceBondOrderTool;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.IValencyChecker;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.SaturationChecker;
import org.openscience.cdk.tools.manipulator.BondManipulator;

@TestClass(value="org.openscience.cdk.tools.ATASaturationCheckerTest")
public class AtomTypeAwareSaturationChecker
implements IValencyChecker,
IDeduceBondOrderTool {
    SaturationChecker staturationChecker = new SaturationChecker();
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(SaturationChecker.class);
    private IBond.Order oldBondOrder;
    private int startBond;

    public void decideBondOrder(IAtomContainer iAtomContainer, boolean bl) throws CDKException {
        if (iAtomContainer.getBondCount() == 0) {
            return;
        }
        this.startBond = 0;
        int n = 0;
        int[] nArray = new int[]{this.startBond, n};
        if (bl) {
            do {
                if (this.startBond == iAtomContainer.getBondCount()) {
                    if (nArray[1] == 0) {
                        throw new CDKException("Can't find any solution");
                    }
                    this.decideBondOrder(iAtomContainer, nArray[0]);
                    double d = (double)nArray[1] * 1.0 / (double)iAtomContainer.getAtomCount() * 10000.0;
                    d = Math.round(d) / 100L;
                    logger.warn("Can't find any solution where all atoms are saturated. A best guess gives " + d + "% Saturated atoms.");
                    return;
                }
                this.decideBondOrder(iAtomContainer, this.startBond);
                n = 0;
                for (IAtom iAtom : iAtomContainer.atoms()) {
                    if (!this.isSaturated(iAtom, iAtomContainer)) continue;
                    ++n;
                }
                if (nArray[1] < n) {
                    nArray[0] = this.startBond;
                    nArray[1] = n;
                }
                ++this.startBond;
            } while (!this.isSaturated(iAtomContainer));
        } else {
            this.decideBondOrder(iAtomContainer, this.startBond);
        }
    }

    public void decideBondOrder(IAtomContainer iAtomContainer) throws CDKException {
        this.decideBondOrder(iAtomContainer, true);
    }

    private void decideBondOrder(IAtomContainer iAtomContainer, int n) throws CDKException {
        int n2;
        for (n2 = 0; n2 < iAtomContainer.getBondCount(); ++n2) {
            if (!iAtomContainer.getBond(n2).getFlag(12)) continue;
            iAtomContainer.getBond(n2).setOrder(IBond.Order.SINGLE);
        }
        for (n2 = n; n2 < iAtomContainer.getBondCount(); ++n2) {
            this.checkBond(iAtomContainer, n2);
        }
        if (n > 0) {
            for (n2 = n - 1; n2 >= 0; --n2) {
                this.checkBond(iAtomContainer, n2);
            }
        }
    }

    private void checkBond(IAtomContainer iAtomContainer, int n) throws CDKException {
        IBond iBond = iAtomContainer.getBond(n);
        if (iBond.getFlag(12) && iBond != null) {
            try {
                this.oldBondOrder = iBond.getOrder();
                iBond.setOrder(IBond.Order.SINGLE);
                this.setMaxBondOrder(iBond, iAtomContainer);
            }
            catch (CDKException cDKException) {
                iBond.setOrder(this.oldBondOrder);
                logger.debug(cDKException);
            }
        }
    }

    private void setMaxBondOrder(IBond iBond, IAtomContainer iAtomContainer) throws CDKException {
        if (this.bondOrderCanBeIncreased(iBond, iAtomContainer)) {
            if (iBond.getOrder() != IBond.Order.QUADRUPLE) {
                iBond.setOrder(BondManipulator.increaseBondOrder(iBond.getOrder()));
            } else {
                throw new CDKException("Can't increase a quadruple bond!");
            }
        }
    }

    public boolean bondOrderCanBeIncreased(IBond iBond, IAtomContainer iAtomContainer) throws CDKException {
        boolean bl = false;
        boolean bl2 = false;
        double d = iBond.getAtom(0).getBondOrderSum() == null ? this.getAtomBondordersum(iBond.getAtom(0), iAtomContainer) : iBond.getAtom(0).getBondOrderSum().doubleValue();
        if (this.bondsUsed(iBond.getAtom(0), iAtomContainer) < d) {
            bl = true;
        }
        d = iBond.getAtom(1).getBondOrderSum() == null ? this.getAtomBondordersum(iBond.getAtom(1), iAtomContainer) : iBond.getAtom(1).getBondOrderSum().doubleValue();
        if (this.bondsUsed(iBond.getAtom(1), iAtomContainer) < d) {
            bl2 = true;
        }
        if (bl == bl2) {
            return bl;
        }
        int n = iAtomContainer.getBondNumber(iBond);
        if (n == 0) {
            return false;
        }
        if (iAtomContainer.getBond(n - 1).getOrder() == IBond.Order.DOUBLE) {
            return false;
        }
        if (this.isConnected(iAtomContainer.getBond(n), iAtomContainer.getBond(0))) {
            throw new CantDecideBondOrderException("Can't decide bond order of this bond");
        }
        return false;
    }

    private double getAtomBondordersum(IAtom iAtom, IAtomContainer iAtomContainer) throws CDKException {
        return iAtom.getValency().intValue();
    }

    private boolean isConnected(IBond iBond, IBond iBond2) {
        for (IAtom iAtom : iBond.atoms()) {
            if (!iBond2.contains(iAtom)) continue;
            return true;
        }
        return false;
    }

    public double getMaxNoOfBonds(IAtom iAtom) throws CDKException {
        double d;
        double d2 = d = iAtom.getValency() == CDKConstants.UNSET ? -1.0 : (double)iAtom.getValency().intValue();
        if (d == -1.0) {
            throw new CDKException("Atom property not set: Valency");
        }
        return 8.0 - d;
    }

    private double bondsUsed(IAtom iAtom, IAtomContainer iAtomContainer) throws CDKException {
        double d;
        int n;
        int n2 = 0;
        for (IBond object : iAtomContainer.bonds()) {
            if (!object.contains(iAtom)) continue;
            n2 = (int)((double)n2 + BondManipulator.destroyBondOrder(object.getOrder()));
        }
        if (iAtom.getImplicitHydrogenCount() == CDKConstants.UNSET || iAtom.getImplicitHydrogenCount() == null) {
            if (iAtom.getValency() == CDKConstants.UNSET || iAtom.getValency() == null) {
                throw new CDKException("Atom " + iAtom.getAtomTypeName() + " has not got the valency set.");
            }
            if (iAtom.getFormalNeighbourCount() == CDKConstants.UNSET || iAtom.getFormalNeighbourCount() == null) {
                throw new CDKException("Atom " + iAtom.getAtomTypeName() + " has not got the formal neighbour count set.");
            }
            n = 8 - iAtom.getValency() - iAtom.getFormalNeighbourCount();
            String d2 = "Number of implicite hydrogens not set for atom " + iAtom.getAtomTypeName() + ". Estimated it to: " + n;
            logger.warn(d2);
        } else {
            n = iAtom.getImplicitHydrogenCount();
        }
        if (iAtom.getCharge() == CDKConstants.UNSET) {
            if (iAtom.getFormalCharge() == CDKConstants.UNSET) {
                d = 0.0;
                String string = "Neither charge nor formal charge is set for atom " + iAtom.getAtomTypeName() + ". Estimate it to: 0";
                logger.warn(string);
            } else {
                d = iAtom.getFormalCharge().intValue();
            }
        } else {
            d = iAtom.getCharge();
        }
        return (double)n2 - d + (double)n;
    }

    @Override
    public void saturate(IAtomContainer iAtomContainer) throws CDKException {
        this.staturationChecker.saturate(iAtomContainer);
    }

    @Override
    public boolean isSaturated(IAtomContainer iAtomContainer) throws CDKException {
        return this.staturationChecker.isSaturated(iAtomContainer);
    }

    @Override
    public boolean isSaturated(IAtom iAtom, IAtomContainer iAtomContainer) throws CDKException {
        return this.staturationChecker.isSaturated(iAtom, iAtomContainer);
    }

    private class CantDecideBondOrderException
    extends CDKException {
        public CantDecideBondOrderException(String string) {
            super(string);
        }
    }
}

