/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.smarts.Node;
import ambit2.smarts.QuerySequenceElement;
import ambit2.smarts.TopLayer;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;

public class IsomorphismTester {
    QueryAtomContainer query;
    IAtomContainer target;
    boolean isomorphismFound;
    boolean FlagStoreIsomorphismNode = false;
    Vector<Node> isomorphismNodes = new Vector();
    Stack<Node> stack = new Stack();
    Vector<IAtom> targetAt = new Vector();
    Vector<QuerySequenceElement> sequence = new Vector();
    Vector<IQueryAtom> sequencedAtoms = new Vector();
    Vector<IQueryAtom> sequencedBondAt1 = new Vector();
    Vector<IQueryAtom> sequencedBondAt2 = new Vector();

    public void setQuery(QueryAtomContainer container) {
        this.query = container;
        TopLayer.setAtomTopLayers((IAtomContainer)this.query, "TL");
        this.setQueryAtomSequence(null);
    }

    public Vector<QuerySequenceElement> getSequence() {
        return this.sequence;
    }

    public void setSequence(QueryAtomContainer queryContainer, Vector<QuerySequenceElement> externalSequence) {
        this.query = queryContainer;
        this.sequence = externalSequence;
    }

    public Vector<QuerySequenceElement> transferSequenceToOwner() {
        Vector<QuerySequenceElement> ownerSeq = this.sequence;
        this.sequence = new Vector();
        return ownerSeq;
    }

    void setQueryAtomSequence(IQueryAtom firstAt) {
        IQueryAtom firstAtom = firstAt == null ? (IQueryAtom)this.query.getFirstAtom() : firstAt;
        this.sequence.clear();
        this.sequencedAtoms.clear();
        this.sequencedBondAt1.clear();
        this.sequencedBondAt2.clear();
        this.sequencedAtoms.add(firstAtom);
        QuerySequenceElement seqEl = new QuerySequenceElement();
        seqEl.center = firstAtom;
        TopLayer topLayer = (TopLayer)firstAtom.getProperty((Object)"TL");
        int n = topLayer.atoms.size();
        seqEl.atoms = new IQueryAtom[n];
        seqEl.bonds = new IQueryBond[n];
        for (int i = 0; i < n; ++i) {
            this.sequencedAtoms.add((IQueryAtom)topLayer.atoms.get(i));
            seqEl.atoms[i] = (IQueryAtom)topLayer.atoms.get(i);
            seqEl.bonds[i] = (IQueryBond)topLayer.bonds.get(i);
            this.addSeqBond(seqEl.center, seqEl.atoms[i]);
        }
        this.sequence.add(seqEl);
        Stack<QuerySequenceElement> stack = new Stack<QuerySequenceElement>();
        stack.push(seqEl);
        while (!stack.empty()) {
            QuerySequenceElement curSeqAt = (QuerySequenceElement)stack.pop();
            for (int i = 0; i < curSeqAt.atoms.length; ++i) {
                topLayer = (TopLayer)curSeqAt.atoms[i].getProperty((Object)"TL");
                if (topLayer.atoms.size() == 1) continue;
                int[] a = this.getSeqAtomsInLayer(topLayer);
                n = 0;
                for (int k = 0; k < a.length; ++k) {
                    if (a[k] != 0) continue;
                    ++n;
                }
                if (n > 0) {
                    seqEl = new QuerySequenceElement();
                    seqEl.center = curSeqAt.atoms[i];
                    seqEl.atoms = new IQueryAtom[n];
                    seqEl.bonds = new IQueryBond[n];
                    this.sequence.add(seqEl);
                    stack.add(seqEl);
                }
                int j = 0;
                for (int k = 0; k < a.length; ++k) {
                    if (a[k] == 0) {
                        seqEl.atoms[j] = (IQueryAtom)topLayer.atoms.get(k);
                        seqEl.bonds[j] = (IQueryBond)topLayer.bonds.get(k);
                        this.addSeqBond(seqEl.center, seqEl.atoms[j]);
                        this.sequencedAtoms.add(seqEl.atoms[j]);
                        ++j;
                        continue;
                    }
                    if (curSeqAt.center == topLayer.atoms.get(k) || this.getSeqBond((IAtom)curSeqAt.atoms[i], topLayer.atoms.get(k)) != -1) continue;
                    QuerySequenceElement newSeqEl = new QuerySequenceElement();
                    newSeqEl.center = null;
                    newSeqEl.atoms = new IQueryAtom[2];
                    newSeqEl.bonds = new IQueryBond[1];
                    newSeqEl.atoms[0] = curSeqAt.atoms[i];
                    newSeqEl.atoms[1] = (IQueryAtom)topLayer.atoms.get(k);
                    this.addSeqBond(newSeqEl.atoms[0], newSeqEl.atoms[1]);
                    newSeqEl.bonds[0] = (IQueryBond)topLayer.bonds.get(k);
                    this.sequence.add(newSeqEl);
                }
            }
        }
        for (int i = 0; i < this.sequence.size(); ++i) {
            this.sequence.get(i).setAtomNums(this.query);
        }
    }

    boolean containsAtom(Vector<IQueryAtom> v, IQueryAtom atom) {
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i) != atom) continue;
            return true;
        }
        return false;
    }

    boolean containsAtom(IAtom[] a, IAtom atom) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != atom) continue;
            return true;
        }
        return false;
    }

    int[] getSeqAtomsInLayer(TopLayer topLayer) {
        int[] a = new int[topLayer.atoms.size()];
        for (int i = 0; i < topLayer.atoms.size(); ++i) {
            a[i] = this.containsAtom(this.sequencedAtoms, (IQueryAtom)topLayer.atoms.get(i)) ? 1 : 0;
        }
        return a;
    }

    void addSeqBond(IQueryAtom at1, IQueryAtom at2) {
        this.sequencedBondAt1.add(at1);
        this.sequencedBondAt2.add(at2);
    }

    int getSeqBond(IAtom at1, IAtom at2) {
        for (int i = 0; i < this.sequencedBondAt1.size(); ++i) {
            if (!(this.sequencedBondAt1.get(i) == at1 ? this.sequencedBondAt2.get(i) == at2 : this.sequencedBondAt1.get(i) == at2 && this.sequencedBondAt2.get(i) == at1)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasIsomorphism(IAtomContainer container) {
        this.target = container;
        this.FlagStoreIsomorphismNode = false;
        this.isomorphismNodes.clear();
        if (this.query.getAtomCount() == 1) {
            return this.singleAtomIsomorphism();
        }
        TopLayer.setAtomTopLayers(this.target, "TL");
        this.executeSequence(true);
        return this.isomorphismFound;
    }

    public Vector<Integer> getIsomorphismPositions(IAtomContainer container) {
        this.target = container;
        this.FlagStoreIsomorphismNode = false;
        this.isomorphismNodes.clear();
        Vector<Integer> v = new Vector<Integer>();
        if (this.query.getAtomCount() == 1) {
            SMARTSAtom qa = (SMARTSAtom)this.query.getAtom(0);
            for (int i = 0; i < this.target.getAtomCount(); ++i) {
                if (!qa.matches(this.target.getAtom(i))) continue;
                v.add(new Integer(i));
            }
            return v;
        }
        TopLayer.setAtomTopLayers(this.target, "TL");
        for (int i = 0; i < this.target.getAtomCount(); ++i) {
            this.executeSequenceAtPos(i);
            if (!this.isomorphismFound) continue;
            v.add(new Integer(i));
        }
        return v;
    }

    public Vector<IAtom> getIsomorphismMapping(IAtomContainer container) {
        if (this.query == null) {
            return null;
        }
        this.target = container;
        this.FlagStoreIsomorphismNode = true;
        this.isomorphismNodes.clear();
        if (this.query.getAtomCount() == 1) {
            SMARTSAtom qa = (SMARTSAtom)this.query.getAtom(0);
            for (int i = 0; i < this.target.getAtomCount(); ++i) {
                if (!qa.matches(this.target.getAtom(i))) continue;
                Vector<IAtom> v = new Vector<IAtom>();
                v.add(this.target.getAtom(i));
                return v;
            }
            return null;
        }
        TopLayer.setAtomTopLayers(this.target, "TL");
        this.executeSequence(true);
        if (this.isomorphismFound) {
            Node node = this.isomorphismNodes.get(0);
            Vector<IAtom> v = new Vector<IAtom>();
            for (int i = 0; i < node.atoms.length; ++i) {
                v.add(node.atoms[i]);
            }
            return v;
        }
        return null;
    }

    public Vector<IBond> generateBondMapping(IAtomContainer container, Vector<IAtom> atomMapping) {
        if (this.query == null) {
            return null;
        }
        Vector<IBond> v = new Vector<IBond>();
        for (int i = 0; i < this.query.getBondCount(); ++i) {
            IAtom qa0 = this.query.getBond(i).getAtom(0);
            IAtom qa1 = this.query.getBond(i).getAtom(1);
            IAtom a0 = atomMapping.get(this.query.getAtomNumber(qa0));
            IAtom a1 = atomMapping.get(this.query.getAtomNumber(qa1));
            v.add(container.getBond(a0, a1));
        }
        return v;
    }

    public Vector<Vector<IAtom>> getAllIsomorphismMappings(IAtomContainer container) {
        if (this.query == null) {
            return null;
        }
        this.target = container;
        this.FlagStoreIsomorphismNode = true;
        this.isomorphismNodes.clear();
        Vector<Vector<IAtom>> result = new Vector<Vector<IAtom>>();
        if (this.query.getAtomCount() == 1) {
            SMARTSAtom qa = (SMARTSAtom)this.query.getAtom(0);
            for (int i = 0; i < this.target.getAtomCount(); ++i) {
                if (!qa.matches(this.target.getAtom(i))) continue;
                Vector<IAtom> v = new Vector<IAtom>();
                v.add(this.target.getAtom(i));
                result.add(v);
            }
            return result;
        }
        TopLayer.setAtomTopLayers(this.target, "TL");
        this.executeSequence(false);
        if (this.isomorphismFound) {
            for (int k = 0; k < this.isomorphismNodes.size(); ++k) {
                Node node = this.isomorphismNodes.get(k);
                Vector<IAtom> v = new Vector<IAtom>();
                for (int i = 0; i < node.atoms.length; ++i) {
                    v.add(node.atoms[i]);
                }
                result.add(v);
            }
        }
        return result;
    }

    public Vector<Vector<IAtom>> getNonIdenticalMappings(IAtomContainer container) {
        Vector<Vector<IAtom>> result = new Vector<Vector<IAtom>>();
        Vector<Vector<IAtom>> allMaps = this.getAllIsomorphismMappings(container);
        if (allMaps.isEmpty()) {
            return result;
        }
        int nMaps = allMaps.size();
        int nAtoms = allMaps.get(0).size();
        for (int i = 0; i < nMaps; ++i) {
            Vector<IAtom> map = allMaps.get(i);
            boolean FlagOK = true;
            for (int j = 0; j < result.size(); ++j) {
                Vector<IAtom> map1 = result.get(j);
                boolean FlagOneFifferent = false;
                for (int k = 0; k < nAtoms; ++k) {
                    if (map1.contains(map.get(k))) continue;
                    FlagOneFifferent = true;
                    break;
                }
                if (FlagOneFifferent) continue;
                FlagOK = false;
                break;
            }
            if (!FlagOK) continue;
            result.add(map);
        }
        return result;
    }

    public Vector<Vector<IAtom>> getNonOverlappingMappings(IAtomContainer container) {
        Vector<Vector<IAtom>> result = new Vector<Vector<IAtom>>();
        Vector<Vector<IAtom>> allMaps = this.getAllIsomorphismMappings(container);
        if (allMaps.isEmpty()) {
            return result;
        }
        int nMaps = allMaps.size();
        int nAtoms = allMaps.get(0).size();
        for (int i = 0; i < nMaps; ++i) {
            Vector<IAtom> map = allMaps.get(i);
            boolean FlagOK = true;
            for (int j = 0; j < result.size(); ++j) {
                Vector<IAtom> map1 = result.get(j);
                for (int k = 0; k < nAtoms; ++k) {
                    if (!map1.contains(map.get(k))) continue;
                    FlagOK = false;
                    break;
                }
                if (!FlagOK) break;
            }
            if (!FlagOK) continue;
            result.add(map);
        }
        return result;
    }

    public Vector<Vector<Integer>> getOverlappedMappingClusters(Vector<Vector<IAtom>> maps) {
        Vector<Vector<Integer>> v = new Vector<Vector<Integer>>();
        if (maps.size() == 0) {
            return v;
        }
        Vector<Integer> vInt = new Vector<Integer>();
        vInt.add(new Integer(0));
        v.add(vInt);
        if (maps.size() == 1) {
            return v;
        }
        for (int i = 1; i < maps.size(); ++i) {
            Vector<IAtom> map = maps.get(i);
            boolean FlagOverlap = false;
            for (int k = 0; k < v.size(); ++k) {
                if (!this.overlapsWithCluster(map, v.get(k), maps)) continue;
                v.get(k).add(new Integer(i));
                FlagOverlap = true;
                break;
            }
            if (FlagOverlap) continue;
            vInt = new Vector();
            vInt.add(new Integer(i));
            v.add(vInt);
        }
        return v;
    }

    boolean overlapsWithCluster(Vector<IAtom> map, Vector<Integer> cluster, Vector<Vector<IAtom>> maps) {
        for (int i = 0; i < cluster.size(); ++i) {
            int mapNum = cluster.get(i);
            Vector<IAtom> clMap = maps.get(mapNum);
            for (int k = 0; k < map.size(); ++k) {
                if (!clMap.contains(map.get(k))) continue;
                return true;
            }
        }
        return false;
    }

    boolean singleAtomIsomorphism() {
        SMARTSAtom qa = (SMARTSAtom)this.query.getAtom(0);
        this.isomorphismFound = false;
        for (int i = 0; i < this.target.getAtomCount(); ++i) {
            if (!qa.matches(this.target.getAtom(i))) continue;
            this.isomorphismFound = true;
            break;
        }
        return this.isomorphismFound;
    }

    void executeSequence(boolean stopAtFirstMapping) {
        this.isomorphismFound = false;
        this.stack.clear();
        QuerySequenceElement el = this.sequence.get(0);
        for (int k = 0; k < this.target.getAtomCount(); ++k) {
            IAtom at = this.target.getAtom(k);
            if (!el.center.matches(at)) continue;
            Node node = new Node();
            node.sequenceElNum = 0;
            node.nullifyAtoms(this.query.getAtomCount());
            node.atoms[el.centerNum] = at;
            this.stack.push(node);
        }
        if (stopAtFirstMapping) {
            while (!this.stack.isEmpty()) {
                this.expandNode(this.stack.pop());
                if (!this.isomorphismFound) continue;
                break;
            }
        } else {
            while (!this.stack.isEmpty()) {
                this.expandNode(this.stack.pop());
            }
        }
    }

    void executeSequenceAtPos(int pos) {
        this.isomorphismFound = false;
        this.stack.clear();
        QuerySequenceElement el = this.sequence.get(0);
        IAtom at = this.target.getAtom(pos);
        if (el.center.matches(at)) {
            Node node = new Node();
            node.sequenceElNum = 0;
            node.nullifyAtoms(this.query.getAtomCount());
            node.atoms[el.centerNum] = at;
            this.stack.push(node);
        }
        while (!this.stack.isEmpty()) {
            this.expandNode(this.stack.pop());
            if (!this.isomorphismFound) continue;
            break;
        }
    }

    void expandNode(Node node) {
        QuerySequenceElement el = this.sequence.get(node.sequenceElNum);
        if (el.center == null) {
            IAtom tAt1;
            IAtom tAt0 = node.atoms[this.query.getAtomNumber((IAtom)el.atoms[0])];
            IBond tBo = this.target.getBond(tAt0, tAt1 = node.atoms[this.query.getAtomNumber((IAtom)el.atoms[1])]);
            if (tBo != null && el.bonds[0].matches(tBo)) {
                ++node.sequenceElNum;
                if (node.sequenceElNum == this.sequence.size()) {
                    this.isomorphismFound = true;
                    if (this.FlagStoreIsomorphismNode) {
                        this.isomorphismNodes.add(node);
                    }
                } else {
                    this.stack.push(node);
                }
            }
        } else {
            this.targetAt.clear();
            IAtom tAt = node.atoms[el.centerNum];
            List conAt = this.target.getConnectedAtomsList(tAt);
            for (int i = 0; i < conAt.size(); ++i) {
                if (this.containsAtom(node.atoms, (IAtom)conAt.get(i))) continue;
                this.targetAt.add((IAtom)conAt.get(i));
            }
            if (el.atoms.length <= this.targetAt.size()) {
                this.generateNodes(node);
            }
        }
    }

    void generateNodes(Node node) {
        QuerySequenceElement el = this.sequence.get(node.sequenceElNum);
        if (el.atoms.length == 1) {
            for (int i = 0; i < this.targetAt.size(); ++i) {
                if (!el.atoms[0].matches(this.targetAt.get(i)) || !this.matchBond(node, el, 0, this.targetAt.get(i))) continue;
                Node newNode = node.cloneNode();
                newNode.atoms[el.atomNums[0]] = this.targetAt.get(i);
                newNode.sequenceElNum = node.sequenceElNum + 1;
                if (newNode.sequenceElNum == this.sequence.size()) {
                    this.isomorphismFound = true;
                    if (!this.FlagStoreIsomorphismNode) continue;
                    this.isomorphismNodes.add(newNode);
                    continue;
                }
                this.stack.push(newNode);
            }
            return;
        }
        if (el.atoms.length == 2) {
            for (int i = 0; i < this.targetAt.size(); ++i) {
                if (!el.atoms[0].matches(this.targetAt.get(i)) || !this.matchBond(node, el, 0, this.targetAt.get(i))) continue;
                for (int j = 0; j < this.targetAt.size(); ++j) {
                    if (i == j || !el.atoms[1].matches(this.targetAt.get(j)) || !this.matchBond(node, el, 1, this.targetAt.get(j))) continue;
                    Node newNode = node.cloneNode();
                    newNode.atoms[el.atomNums[0]] = this.targetAt.get(i);
                    newNode.atoms[el.atomNums[1]] = this.targetAt.get(j);
                    newNode.sequenceElNum = node.sequenceElNum + 1;
                    if (newNode.sequenceElNum == this.sequence.size()) {
                        this.isomorphismFound = true;
                        if (!this.FlagStoreIsomorphismNode) continue;
                        this.isomorphismNodes.add(newNode);
                        continue;
                    }
                    this.stack.push(newNode);
                }
            }
            return;
        }
        if (el.atoms.length == 3) {
            for (int i = 0; i < this.targetAt.size(); ++i) {
                if (!el.atoms[0].matches(this.targetAt.get(i)) || !this.matchBond(node, el, 0, this.targetAt.get(i))) continue;
                for (int j = 0; j < this.targetAt.size(); ++j) {
                    if (i == j || !el.atoms[1].matches(this.targetAt.get(j)) || !this.matchBond(node, el, 1, this.targetAt.get(j))) continue;
                    for (int k = 0; k < this.targetAt.size(); ++k) {
                        if (k == i || k == j || !el.atoms[2].matches(this.targetAt.get(k)) || !this.matchBond(node, el, 2, this.targetAt.get(k))) continue;
                        Node newNode = node.cloneNode();
                        newNode.atoms[el.atomNums[0]] = this.targetAt.get(i);
                        newNode.atoms[el.atomNums[1]] = this.targetAt.get(j);
                        newNode.atoms[el.atomNums[2]] = this.targetAt.get(k);
                        newNode.sequenceElNum = node.sequenceElNum + 1;
                        if (newNode.sequenceElNum == this.sequence.size()) {
                            this.isomorphismFound = true;
                            if (!this.FlagStoreIsomorphismNode) continue;
                            this.isomorphismNodes.add(newNode);
                            continue;
                        }
                        this.stack.push(newNode);
                    }
                }
            }
            return;
        }
        Stack<int[]> st = new Stack<int[]>();
        for (int i = 0; i < this.targetAt.size(); ++i) {
            if (!el.atoms[0].matches(this.targetAt.get(i)) || !this.matchBond(node, el, 0, this.targetAt.get(i))) continue;
            int[] t = new int[el.atoms.length + 1];
            t[t.length - 1] = 1;
            t[0] = i;
            st.push(t);
        }
        while (!st.isEmpty()) {
            int[] t = (int[])st.pop();
            int n = t[t.length - 1];
            if (n == t.length - 1) {
                Node newNode = node.cloneNode();
                for (int k = 0; k < t.length - 1; ++k) {
                    newNode.atoms[el.atomNums[k]] = this.targetAt.get(t[k]);
                }
                newNode.sequenceElNum = node.sequenceElNum + 1;
                if (newNode.sequenceElNum == this.sequence.size()) {
                    this.isomorphismFound = true;
                    if (!this.FlagStoreIsomorphismNode) continue;
                    this.isomorphismNodes.add(newNode);
                    continue;
                }
                this.stack.push(newNode);
                continue;
            }
            for (int i = 0; i < this.targetAt.size(); ++i) {
                boolean Flag = true;
                for (int k = 0; k < n; ++k) {
                    if (i != t[k]) continue;
                    Flag = false;
                    break;
                }
                if (!Flag || !el.atoms[n].matches(this.targetAt.get(i)) || !this.matchBond(node, el, n, this.targetAt.get(i))) continue;
                int[] tnew = new int[el.atoms.length + 1];
                for (int k = 0; k < n; ++k) {
                    tnew[k] = t[k];
                }
                tnew[n] = i;
                tnew[t.length - 1] = n + 1;
                st.push(tnew);
            }
        }
    }

    boolean matchBond(Node node, QuerySequenceElement el, int qAtNum, IAtom taAt) {
        IBond taBo = this.target.getBond(taAt, node.atoms[el.centerNum]);
        return el.bonds[qAtNum].matches(taBo);
    }

    public void printDebugInfo() {
        int i;
        System.out.println("Query Atoms Topological Layers");
        for (i = 0; i < this.query.getAtomCount(); ++i) {
            System.out.println("" + i + "  " + this.query.getAtom(i).getProperty((Object)"TL").toString());
        }
        System.out.println();
        System.out.println("Query Sequence");
        for (i = 0; i < this.sequence.size(); ++i) {
            System.out.println(this.sequence.get(i).toString(this.query));
        }
    }
}

