/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class PaDELBondCountDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"nBonds", "nBonds2", "nBondsS", "nBondsS2", "nBondsS3", "nBondsD", "nBondsD2", "nBondsT", "nBondsQ", "nBondsM"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("PaDELBondCountDescriptor", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (IBond object2 : iAtomContainer.bonds()) {
            boolean bl = false;
            for (int i = 0; i < object2.getAtomCount(); ++i) {
                if (!object2.getAtom(i).getSymbol().equals("H")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                ++n;
            }
            if (object2.getFlag(5)) {
                ++n3;
            }
            if (object2.getOrder() == IBond.Order.SINGLE) {
                ++n4;
                if (object2.getFlag(5)) continue;
                ++n5;
                if (bl) continue;
                ++n6;
                continue;
            }
            if (object2.getOrder() == IBond.Order.DOUBLE) {
                ++n7;
                if (object2.getFlag(5)) continue;
                ++n8;
                continue;
            }
            if (object2.getOrder() == IBond.Order.TRIPLE) {
                ++n9;
                continue;
            }
            if (object2.getOrder() != IBond.Order.QUADRUPLE) continue;
            ++n10;
        }
        n2 = n3 + n5 + n8 + n9 + n10;
        n11 = n3 + n8 + n9 + n10;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        doubleArrayResult.add(n);
        doubleArrayResult.add(n2);
        doubleArrayResult.add(n4);
        doubleArrayResult.add(n5);
        doubleArrayResult.add(n6);
        doubleArrayResult.add(n7);
        doubleArrayResult.add(n8);
        doubleArrayResult.add(n9);
        doubleArrayResult.add(n10);
        doubleArrayResult.add(n11);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }
}

