/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.smarts.AliphaticSymbolQueryAtom;
import ambit2.smarts.AromaticSymbolQueryAtom;
import ambit2.smarts.AtomSmartsNode;
import ambit2.smarts.DoubleBondAromaticityNotSpecified;
import ambit2.smarts.IsomorphismTester;
import ambit2.smarts.SingleBondAromaticityNotSpecified;
import ambit2.smarts.SingleNonAromaticBond;
import ambit2.smarts.SingleOrAromaticBond;
import ambit2.smarts.SmartsAtomExpression;
import ambit2.smarts.SmartsBondExpression;
import ambit2.smarts.SmartsParser;
import ambit2.smarts.SymbolQueryAtomAromaticityNotSpecified;
import ambit2.smarts.TopLayer;
import ambit2.smarts.TripleBondAromaticityNotSpecified;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Vector;
import org.openscience.cdk.Atom;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.SMILESWriter;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class SmartsHelper {
    static SmilesParser smilesparser;
    int curIndex;
    HashMap<IAtom, TopLayer> firstSphere = new HashMap();
    HashMap<IAtom, AtomSmartsNode> nodes = new HashMap();
    HashMap<IAtom, String> atomIndexes = new HashMap();
    Vector<IBond> ringClosures = new Vector();
    int nAtom;
    int nBond;

    public SmartsHelper(IChemObjectBuilder builder) {
        smilesparser = new SmilesParser(builder);
    }

    public static String getAtomsString(QueryAtomContainer query) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < query.getAtomCount(); ++i) {
            sb.append(SmartsHelper.atomToString((IAtom)((SMARTSAtom)query.getAtom(i))) + " ");
        }
        return sb.toString();
    }

    public static String getAtomExpressionTokens(SmartsAtomExpression expression) {
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < expression.tokens.size(); ++k) {
            sb.append("tok(" + expression.tokens.get((int)k).type + "," + expression.tokens.get((int)k).param + ") ");
        }
        return sb.toString();
    }

    public static String getAtomsString(IAtomContainer container) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < container.getAtomCount(); ++i) {
            sb.append(container.getAtom(i).getSymbol() + " ");
        }
        return sb.toString();
    }

    public static String getAtomsAttributes(IAtomContainer container) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom at = container.getAtom(i);
            sb.append("  #" + i + "  ");
            sb.append(at.getSymbol());
            Integer explHInt = (Integer)at.getProperty((Object)"ExplicitH");
            int explHAt = 0;
            if (explHInt != null) {
                explHAt = explHInt;
            }
            sb.append(" NumH=" + (at.getImplicitHydrogenCount() + explHAt));
            if (at.getFlag(5)) {
                sb.append(" aromatic");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String getBondAttributes(IAtomContainer container) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < container.getBondCount(); ++i) {
            IBond bo = container.getBond(i);
            IAtom at0 = bo.getAtom(0);
            IAtom at1 = bo.getAtom(1);
            int at0_num = container.getAtomNumber(at0);
            int at1_num = container.getAtomNumber(at1);
            sb.append("  #" + i + "  (" + at0_num + "," + at1_num + ")");
            if (bo.getFlag(5)) {
                sb.append(" aromatic");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String getBondsString(IAtomContainer query) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < query.getBondCount(); ++i) {
            sb.append(query.getBond(i).getOrder() + " ");
        }
        return sb.toString();
    }

    public static String bondToStringExhaustive(QueryAtomContainer query, IBond bond) {
        StringBuffer sb = new StringBuffer();
        sb.append(SmartsHelper.bondToString(bond) + " " + SmartsHelper.bondAtomNumbersToString((IAtomContainer)query, bond) + "  " + SmartsHelper.atomToString(bond.getAtom(0)) + " " + SmartsHelper.atomToString(bond.getAtom(1)) + "\n");
        return sb.toString();
    }

    public static String getBondsString(QueryAtomContainer query) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < query.getBondCount(); ++i) {
            sb.append(SmartsHelper.bondToString(query.getBond(i)) + " " + SmartsHelper.bondAtomNumbersToString((IAtomContainer)query, query.getBond(i)) + "  " + SmartsHelper.atomToString(query.getBond(i).getAtom(0)) + " " + SmartsHelper.atomToString(query.getBond(i).getAtom(1)) + "\n");
        }
        return sb.toString();
    }

    public static QueryAtomContainer getQueryAtomContainer(IAtomContainer ac, boolean HandleAromaticity) {
        int i;
        QueryAtomContainer query = new QueryAtomContainer();
        for (i = 0; i < ac.getAtomCount(); ++i) {
            SMARTSAtom newAt;
            IAtom a = ac.getAtom(i);
            if (HandleAromaticity) {
                if (a.getFlag(5)) {
                    newAt = new AromaticSymbolQueryAtom();
                    newAt.setSymbol(a.getSymbol());
                    query.addAtom((IAtom)newAt);
                    continue;
                }
                newAt = new AliphaticSymbolQueryAtom();
                newAt.setSymbol(a.getSymbol());
                query.addAtom((IAtom)newAt);
                continue;
            }
            newAt = new SymbolQueryAtomAromaticityNotSpecified();
            newAt.setSymbol(a.getSymbol());
            query.addAtom((IAtom)newAt);
        }
        for (i = 0; i < ac.getBondCount(); ++i) {
            boolean isArom;
            IBond b = ac.getBond(i);
            IAtom at0 = b.getAtom(0);
            IAtom at1 = b.getAtom(1);
            int index0 = ac.getAtomNumber(at0);
            int index1 = ac.getAtomNumber(at1);
            Object newBo = b.getOrder() == IBond.Order.TRIPLE ? new TripleBondAromaticityNotSpecified() : (b.getOrder() == IBond.Order.DOUBLE ? new DoubleBondAromaticityNotSpecified() : (HandleAromaticity ? ((isArom = b.getFlag(5)) ? new SingleOrAromaticBond() : new SingleNonAromaticBond()) : new SingleBondAromaticityNotSpecified()));
            Atom[] atoms = new Atom[]{query.getAtom(index0), query.getAtom(index1)};
            newBo.setAtoms((IAtom[])atoms);
            query.addBond((IBond)newBo);
        }
        return query;
    }

    public static int bondOrderToIntValue(IBond b) {
        if (b.getOrder() == IBond.Order.SINGLE) {
            return 1;
        }
        if (b.getOrder() == IBond.Order.DOUBLE) {
            return 2;
        }
        if (b.getOrder() == IBond.Order.TRIPLE) {
            return 3;
        }
        if (b.getOrder() == IBond.Order.QUADRUPLE) {
            return 4;
        }
        return 0;
    }

    public static String atomToString(IAtom a) {
        if (a instanceof SmartsAtomExpression) {
            return a.toString();
        }
        if (a instanceof AliphaticSymbolQueryAtom) {
            return a.getSymbol();
        }
        if (a instanceof AromaticSymbolQueryAtom) {
            return "Ar-" + a.getSymbol();
        }
        return a.getSymbol();
    }

    public static String bondToString(IBond b) {
        if (b instanceof SmartsBondExpression) {
            return b.toString();
        }
        if (b instanceof SingleOrAromaticBond) {
            return "";
        }
        if (b.getOrder() == IBond.Order.SINGLE) {
            return "-";
        }
        if (b.getOrder() == IBond.Order.DOUBLE) {
            return "=";
        }
        if (b.getOrder() == IBond.Order.TRIPLE) {
            return "#";
        }
        return "-";
    }

    public static String smilesBondToString(IBond b, boolean aromaticity) {
        if (aromaticity && b.getFlag(5)) {
            return "";
        }
        if (b.getOrder() == IBond.Order.SINGLE) {
            return "";
        }
        if (b.getOrder() == IBond.Order.DOUBLE) {
            return "=";
        }
        if (b.getOrder() == IBond.Order.TRIPLE) {
            return "#";
        }
        return "";
    }

    public static String bondAtomNumbersToString(IAtomContainer container, IBond b) {
        return " " + container.getAtomNumber(b.getAtom(0)) + " " + container.getAtomNumber(b.getAtom(1));
    }

    void determineFirstSheres(QueryAtomContainer query) {
        int i;
        this.firstSphere.clear();
        this.nAtom = query.getAtomCount();
        this.nBond = query.getBondCount();
        for (i = 0; i < this.nAtom; ++i) {
            this.firstSphere.put(query.getAtom(i), new TopLayer());
        }
        for (i = 0; i < this.nBond; ++i) {
            IBond bond = query.getBond(i);
            IAtom at0 = bond.getAtom(0);
            IAtom at1 = bond.getAtom(1);
            this.firstSphere.get((Object)at0).atoms.add(at1);
            this.firstSphere.get((Object)at0).bonds.add(bond);
            this.firstSphere.get((Object)at1).atoms.add(at0);
            this.firstSphere.get((Object)at1).bonds.add(bond);
        }
    }

    public String toSmarts(QueryAtomContainer query) {
        this.determineFirstSheres(query);
        this.nodes.clear();
        this.atomIndexes.clear();
        this.ringClosures.clear();
        this.curIndex = 1;
        AtomSmartsNode node = new AtomSmartsNode();
        node.parent = null;
        node.atom = query.getAtom(0);
        this.nodes.put(node.atom, node);
        return this.nodeToString(node.atom);
    }

    void addIndexToAtom(String ind, IAtom atom) {
        if (this.atomIndexes.containsKey(atom)) {
            String old_ind = this.atomIndexes.get(atom);
            this.atomIndexes.remove(atom);
            this.atomIndexes.put(atom, old_ind + ind);
        } else {
            this.atomIndexes.put(atom, ind);
        }
    }

    String nodeToString(IAtom atom) {
        int i;
        StringBuffer sb = new StringBuffer();
        TopLayer afs = this.firstSphere.get(atom);
        AtomSmartsNode curNode = this.nodes.get(atom);
        Vector<String> branches = new Vector<String>();
        for (i = 0; i < afs.atoms.size(); ++i) {
            IAtom neighborAt = afs.atoms.get(i);
            if (neighborAt == curNode.parent) continue;
            AtomSmartsNode neighborNode = this.nodes.get(neighborAt);
            if (neighborNode == null) {
                AtomSmartsNode newNode = new AtomSmartsNode();
                newNode.atom = neighborAt;
                newNode.parent = atom;
                this.nodes.put(newNode.atom, newNode);
                String bond_str = SmartsHelper.bondToString(afs.bonds.get(i));
                String newBranch = bond_str + this.nodeToString(neighborAt);
                branches.add(newBranch);
                continue;
            }
            IBond neighborBo = afs.bonds.get(i);
            if (this.ringClosures.contains(neighborBo)) continue;
            this.ringClosures.add(neighborBo);
            String ind = this.curIndex > 9 ? "%" : "" + this.curIndex;
            this.addIndexToAtom(SmartsHelper.bondToString(neighborBo) + ind, atom);
            this.addIndexToAtom(ind, neighborAt);
            ++this.curIndex;
        }
        sb.append(SmartsHelper.atomToString((IAtom)((SMARTSAtom)atom)));
        if (this.atomIndexes.containsKey(atom)) {
            sb.append(this.atomIndexes.get(atom));
        }
        if (branches.size() == 0) {
            return sb.toString();
        }
        for (i = 0; i < branches.size() - 1; ++i) {
            sb.append("(" + ((String)branches.get(i)).toString() + ")");
        }
        sb.append(((String)branches.lastElement()).toString());
        return sb.toString();
    }

    public static String moleculeToSMILES(IAtomContainer mol) throws Exception {
        StringWriter result = new StringWriter();
        SMILESWriter writer = new SMILESWriter((Writer)result);
        writer.write((IChemObject)mol);
        writer.close();
        return result.toString();
    }

    public static void convertToCarbonSkelleton(IAtomContainer mol) {
        int i;
        for (i = 0; i < mol.getAtomCount(); ++i) {
            IAtom at = mol.getAtom(i);
            at.setSymbol("C");
            at.setFormalCharge(Integer.valueOf(0));
            at.setMassNumber(Integer.valueOf(0));
        }
        for (i = 0; i < mol.getBondCount(); ++i) {
            IBond bo = mol.getBond(i);
            bo.setOrder(IBond.Order.SINGLE);
        }
    }

    public static IMolecule getMoleculeFromSmiles(String smi) throws Exception {
        IMolecule mol = null;
        SmilesParser sp = new SmilesParser(SilentChemObjectBuilder.getInstance());
        mol = sp.parseSmiles(smi);
        return mol;
    }

    public static IMolecule getMoleculeFromSmiles(String smi, boolean FlagExplicitHatoms) throws Exception {
        IMolecule mol = null;
        SmilesParser sp = new SmilesParser(SilentChemObjectBuilder.getInstance());
        mol = sp.parseSmiles(smi);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)mol);
        CDKHydrogenAdder adder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)SilentChemObjectBuilder.getInstance());
        adder.addImplicitHydrogens((IAtomContainer)mol);
        if (FlagExplicitHatoms) {
            AtomContainerManipulator.convertImplicitToExplicitHydrogens((IAtomContainer)mol);
        }
        return mol;
    }

    public static String[] getCarbonSkelletonsFromString(String smiles) throws Exception {
        IMolecule mol = SmartsHelper.getMoleculeFromSmiles(smiles);
        IMoleculeSet ms = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)mol);
        int n = ms.getAtomContainerCount();
        String[] res = new String[n];
        for (int i = 0; i < n; ++i) {
            IAtomContainer frag = ms.getAtomContainer(i);
            SmartsHelper.convertToCarbonSkelleton(frag);
            res[i] = SmartsHelper.moleculeToSMILES(frag);
        }
        return res;
    }

    public static void printIntArray(int[] c) {
        if (c == null) {
            System.out.println("null");
            return;
        }
        for (int i = 0; i < c.length; ++i) {
            System.out.print(c[i] + " ");
        }
        System.out.println();
    }

    public static String toString(int[] c) {
        StringBuffer sb = new StringBuffer();
        if (c == null) {
            sb.append("null");
        } else {
            for (int i = 0; i < c.length; ++i) {
                sb.append(" " + c[i]);
            }
        }
        return sb.toString();
    }

    public static String atomPropertiesToString(IAtom atom) {
        StringBuffer sb = new StringBuffer();
        if (atom.getProperties() == null) {
            return "";
        }
        Object[] keys = atom.getProperties().keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].toString().toString().equals("RingData") || keys[i].toString().toString().equals("RingData2")) {
                sb.append(keys[i].toString() + " = " + SmartsHelper.toString((int[])atom.getProperties().get(keys[i])) + "\n");
                continue;
            }
            sb.append(keys[i].toString() + " = " + atom.getProperties().get(keys[i]) + "\n");
        }
        return sb.toString();
    }

    public static Vector<Integer> getSmartsPositions(String smartsQuery, IAtomContainer target, boolean FlagSupportDoubleBondAromaticityNotSpecified) throws Exception {
        SmartsParser sp = new SmartsParser();
        sp.mSupportDoubleBondAromaticityNotSpecified = FlagSupportDoubleBondAromaticityNotSpecified;
        IsomorphismTester isoTester = new IsomorphismTester();
        QueryAtomContainer query = sp.parse(smartsQuery);
        sp.setNeededDataFlags();
        String errorMsg = sp.getErrorMessages();
        if (!errorMsg.equals("")) {
            System.out.println("Smarts Parser errors:\n" + errorMsg);
            return null;
        }
        isoTester.setQuery(query);
        sp.setSMARTSData(target);
        return isoTester.getIsomorphismPositions(target);
    }
}

