/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.Map;
import org.openscience.cdk.AminoAcid;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.BioPolymer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.Strand;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAminoAcid;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.templates.AminoAcids;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class ProteinBuilderTool {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ProteinBuilderTool.class);

    public static BioPolymer addAminoAcidAtNTerminus(BioPolymer protein, AminoAcid aaToAdd, Strand strand, AminoAcid aaToAddTo) {
        ProteinBuilderTool.addAminoAcid(protein, aaToAdd, strand);
        if (protein.getMonomerCount() == 0) {
            protein.addBond(new Bond(aaToAddTo.getNTerminus(), aaToAdd.getCTerminus(), IBond.Order.SINGLE));
        }
        return protein;
    }

    public static BioPolymer addAminoAcidAtCTerminus(BioPolymer protein, AminoAcid aaToAdd, Strand strand, AminoAcid aaToAddTo) {
        ProteinBuilderTool.addAminoAcid(protein, aaToAdd, strand);
        if (protein.getMonomerCount() != 0 && aaToAddTo != null) {
            protein.addBond(new Bond(aaToAddTo.getCTerminus(), aaToAdd.getNTerminus(), IBond.Order.SINGLE));
        }
        return protein;
    }

    public static BioPolymer createProtein(String sequence) throws CDKException {
        Map<String, IAminoAcid> templates = AminoAcids.getHashMapBySingleCharCode();
        BioPolymer protein = new BioPolymer();
        Strand strand = new Strand();
        AtomContainer previousAA = null;
        for (int i = 0; i < sequence.length(); ++i) {
            String aminoAcidCode = "" + sequence.charAt(i);
            logger.debug("Adding AA: " + aminoAcidCode);
            if (aminoAcidCode.equals(" ")) continue;
            AminoAcid aminoAcid = (AminoAcid)templates.get(aminoAcidCode);
            if (aminoAcid == null) {
                throw new CDKException("Cannot build sequence! Unknown amino acid: " + aminoAcidCode);
            }
            try {
                aminoAcid = (AminoAcid)aminoAcid.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new CDKException("Cannot build sequence! Clone exception: " + e.getMessage(), e);
            }
            aminoAcid.setMonomerName(aminoAcidCode + i);
            logger.debug("protein: ", protein);
            logger.debug("strand: ", strand);
            ProteinBuilderTool.addAminoAcidAtCTerminus(protein, aminoAcid, strand, (AminoAcid)previousAA);
            previousAA = aminoAcid;
        }
        Atom oxygen = new Atom("O");
        previousAA.addAtom(oxygen);
        Bond bond = new Bond(oxygen, ((AminoAcid)previousAA).getCTerminus(), IBond.Order.SINGLE);
        previousAA.addBond(bond);
        protein.addAtom(oxygen, (IMonomer)((Object)previousAA), strand);
        protein.addBond(bond);
        return protein;
    }

    private static BioPolymer addAminoAcid(BioPolymer protein, AminoAcid aaToAdd, Strand strand) {
        for (IAtom atom : aaToAdd.atoms()) {
            protein.addAtom(atom, aaToAdd, strand);
        }
        for (IBond bond : aaToAdd.bonds()) {
            protein.addBond(bond);
        }
        return protein;
    }
}

