/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math;

import javax.vecmath.Tuple3d;

public class Vector {
    public static final Vector NULLVECTOR = new Vector(new double[]{0.0, 0.0, 0.0});
    public static final Vector EX = new Vector(new double[]{1.0, 0.0, 0.0});
    public static final Vector EY = new Vector(new double[]{0.0, 1.0, 0.0});
    public static final Vector EZ = new Vector(new double[]{0.0, 0.0, 1.0});
    public double[] vector;
    public int size;

    public Vector(int size) {
        this.vector = new double[size];
        this.size = size;
    }

    public Vector(double[] array) {
        this.vector = array;
        this.size = array.length;
    }

    public Vector(Tuple3d t) {
        this.vector = new double[3];
        this.size = 3;
        this.vector[0] = t.x;
        this.vector[1] = t.y;
        this.vector[2] = t.z;
    }

    public int getSize() {
        return this.size;
    }

    public Vector add(Vector b) {
        if (b == null || this.size != b.size) {
            return null;
        }
        Vector result = new Vector(this.size);
        for (int i = 0; i < this.size; ++i) {
            result.vector[i] = this.vector[i] + b.vector[i];
        }
        return result;
    }

    public Vector sub(Vector b) {
        if (b == null || this.size != b.size) {
            return null;
        }
        Vector result = new Vector(this.size);
        for (int i = 0; i < this.size; ++i) {
            result.vector[i] = this.vector[i] - b.vector[i];
        }
        return result;
    }

    public Vector mul(double b) {
        Vector result = new Vector(this.size);
        for (int i = 0; i < this.size; ++i) {
            result.vector[i] = this.vector[i] * b;
        }
        return result;
    }

    public double dot(Vector b) {
        if (b == null || this.size != b.size) {
            return Double.NaN;
        }
        double result = 0.0;
        for (int i = 0; i < this.size; ++i) {
            result += this.vector[i] * b.vector[i];
        }
        return result;
    }

    public Vector cross(Vector b) {
        if (b == null || this.size != 3 || b.size != 3) {
            return null;
        }
        Vector result = new Vector(3);
        result.vector[0] = this.vector[1] * b.vector[2] - this.vector[2] * b.vector[1];
        result.vector[1] = this.vector[2] * b.vector[0] - this.vector[0] * b.vector[2];
        result.vector[2] = this.vector[0] * b.vector[1] - this.vector[1] * b.vector[0];
        return result;
    }

    public double length() {
        double value = 0.0;
        for (int i = 0; i < this.size; ++i) {
            value += this.vector[i] * this.vector[i];
        }
        return Math.sqrt(value);
    }

    public Vector normalize() {
        Vector result = new Vector(this.size);
        double length = this.length();
        for (int i = 0; i < this.size; ++i) {
            result.vector[i] = this.vector[i] / length;
        }
        return result;
    }

    public Vector negate() {
        Vector result = new Vector(this.size);
        for (int i = 0; i < this.size; ++i) {
            result.vector[i] = -this.vector[i];
        }
        return result;
    }

    public Vector duplicate() {
        Vector result = new Vector(this.size);
        for (int i = 0; i < this.size; ++i) {
            result.vector[i] = this.vector[i];
        }
        return result;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[ ");
        for (int i = 0; i < this.size - 1; ++i) {
            str.append(this.vector[i] + " ");
        }
        str.append(this.vector[this.size - 1] + " ]");
        return str.toString();
    }
}

