/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.quality;

import ambit2.base.data.AmbitUser;
import ambit2.base.data.QLabel;
import ambit2.base.exceptions.AmbitException;
import ambit2.base.processors.DefaultAmbitProcessor;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.isomorphism.IsomorphismTester;

public class ChemicalStructureQualityCheck
extends DefaultAmbitProcessor<IMolecule, QLabel> {
    protected AmbitUser qualityVerifier = new AmbitUser("quality");
    protected IMolecule groundTruth = null;
    protected IsomorphismTester isoTester = new IsomorphismTester();
    private static final long serialVersionUID = -518931054923701570L;

    public IMolecule getGroundTruth() {
        return this.groundTruth;
    }

    public void setGroundTruth(IMolecule iMolecule) {
        this.groundTruth = iMolecule;
    }

    public QLabel process(IMolecule iMolecule) throws AmbitException {
        if (this.groundTruth == null || iMolecule == null) {
            return new QLabel(QLabel.QUALITY.Unknown);
        }
        QLabel qLabel = new QLabel(this.isoTester.isIsomorphic(this.groundTruth, iMolecule) ? QLabel.QUALITY.OK : QLabel.QUALITY.ERROR);
        qLabel.setUser(this.qualityVerifier);
        return qLabel;
    }
}

