/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.INChIPlainTextFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.inchi.INChIContentProcessorTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.INChIPlainTextReaderTest")
public class INChIPlainTextReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private INChIContentProcessorTool inchiTool;

    public INChIPlainTextReader(Reader input) {
        this.init();
        this.setReader(input);
        this.inchiTool = new INChIContentProcessorTool();
    }

    public INChIPlainTextReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public INChIPlainTextReader() {
        this(new StringReader(""));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return INChIPlainTextFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    private void init() {
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        if (IChemFile.class.equals((Object)classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private IChemFile readChemFile(IChemFile cf) throws CDKException {
        try {
            String line = null;
            while ((line = this.input.readLine()) != null) {
                if (!line.startsWith("INChI=") && !line.startsWith("InChI=")) continue;
                cf = cf.getBuilder().newInstance(IChemFile.class, new Object[0]);
                String INChI = line.substring(6);
                StringTokenizer tokenizer = new StringTokenizer(INChI, "/");
                tokenizer.nextToken();
                String formula = tokenizer.nextToken();
                String connections = tokenizer.nextToken().substring(1);
                IAtomContainer parsedContent = this.inchiTool.processFormula(cf.getBuilder().newInstance(IAtomContainer.class, new Object[0]), formula);
                this.inchiTool.processConnections(connections, parsedContent, -1);
                IMoleculeSet moleculeSet = cf.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
                moleculeSet.addMolecule(cf.getBuilder().newInstance(IMolecule.class, parsedContent));
                IChemModel model = cf.getBuilder().newInstance(IChemModel.class, new Object[0]);
                model.setMoleculeSet(moleculeSet);
                IChemSequence sequence = cf.getBuilder().newInstance(IChemSequence.class, new Object[0]);
                sequence.addChemModel(model);
                cf.addChemSequence(sequence);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CDKException("Error while reading INChI file: " + exception.getMessage(), exception);
        }
        return cf;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

