/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.data.Dictionary;
import ambit2.base.data.ILiteratureEntry;
import ambit2.base.data.LiteratureEntry;
import ambit2.base.data.Property;
import ambit2.base.data.StructureRecord;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.core.io.IRawReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;

public class ToXMLReaderSimple
extends DefaultIteratingChemObjectReader
implements IRawReader<IStructureRecord> {
    protected int compounds = 0;
    protected final String URI = "http://opentox.org/toxml.owl#";
    protected int study = 0;
    protected int test = 0;
    protected Property inchiProperty = Property.getInChIInstance();
    protected Hashtable<Dictionary, Integer> dictionary = new Hashtable();
    protected Hashtable<String, Integer> tagCount = new Hashtable();
    protected IStructureRecord record;
    protected XMLStreamReader reader;
    protected String tmpValue = "";
    protected int recordCount = 0;
    protected Stack<String> tags = new Stack();
    protected Stack<Property> properties = new Stack();
    protected Stack<String[]> attributes = new Stack();
    protected Stack<Hashtable<String, Integer>> branches = new Stack();

    public Hashtable<Dictionary, Integer> getDictionary() {
        return this.dictionary;
    }

    public ToXMLReaderSimple(InputStream inputStream) throws CDKException {
        this.record = new StructureRecord();
        this.record.setFormat(IStructureRecord.MOL_TYPE.SDF.toString());
        this.record.setContent("");
        this.setReader(inputStream);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put(toxml_tags_level1.Compounds.toString(), 1);
        this.branches.push(hashtable);
    }

    public void setReader(Reader reader) throws CDKException {
        try {
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            xMLInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            this.reader = xMLInputFactory.createXMLStreamReader(reader);
        }
        catch (Exception exception) {
            this.reader = null;
            throw new CDKException(exception.getMessage(), (Throwable)exception);
        }
    }

    public void setReader(InputStream inputStream) throws CDKException {
        this.setReader(new InputStreamReader(inputStream));
    }

    public void close() throws IOException {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException(xMLStreamException.getMessage());
        }
    }

    protected void processItem(String string, String string2, boolean bl) {
    }

    protected boolean newRecord(String string, Integer n, String string2, String string3) {
        boolean bl = true;
        String[] stringArray = this.readAttributes();
        this.attributes.push(stringArray);
        String string4 = this.properties.size() == 0 ? "" : String.format("%s.", this.properties.peek());
        String string5 = n == 1 ? String.format("%s%s", string4, string) : String.format("%s%s_%d", string4, string, n - 1);
        String string6 = stringArray[toxml_attributes.sources.ordinal()] == null ? String.format("%s%s", "http://opentox.org/toxml.owl#", string3) : stringArray[toxml_attributes.sources.ordinal()];
        String string7 = String.format("%s%s", "http://opentox.org/toxml.owl#", string3);
        try {
            toxml_tags_level1 toxml_tags_level12 = toxml_tags_level1.valueOf(string);
            switch (toxml_tags_level12) {
                case Compounds: {
                    break;
                }
                case Compound: {
                    this.study = 0;
                    this.test = 0;
                    ++this.compounds;
                    this.record.clear();
                    break;
                }
                case InChI: {
                    if (toxml_tags.InChI.toString().equals(string2)) {
                        throw new Exception("Level 2");
                    }
                    break;
                }
                case ToxicityStudies: {
                    this.study = 0;
                    break;
                }
                case Ids: {
                    break;
                }
                case Names: {
                    break;
                }
                case OtherIds: {
                    break;
                }
                default: {
                    this.record.clearProperties();
                    break;
                }
            }
        }
        catch (Exception exception) {
            toxml_tags toxml_tags2 = toxml_tags.Default;
            try {
                toxml_tags2 = toxml_tags.valueOf(string);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            toxml_tags toxml_tags3 = toxml_tags.Default;
            try {
                toxml_tags3 = toxml_tags.valueOf(string2);
            }
            catch (Exception exception3) {
                // empty catch block
            }
            if (toxml_tags.TextDatum.equals((Object)toxml_tags3) || toxml_tags.Datum.equals((Object)toxml_tags3)) {
                bl = false;
                return false;
            }
            toxml_quantity_types toxml_quantity_types2 = null;
            try {
                toxml_quantity_types2 = toxml_quantity_types.valueOf(string2);
                bl = false;
                return false;
            }
            catch (Exception exception4) {
                Class clazz = String.class;
                switch (toxml_tags2) {
                    case Study: {
                        ++this.study;
                        this.test = 0;
                        this.record.clearProperties();
                        break;
                    }
                    case InChI: {
                        break;
                    }
                    case Code: {
                        if (toxml_tags.InChI.equals((Object)toxml_tags3)) {
                            string7 = "http://www.opentox.org/api/1.1#InChI";
                        }
                    }
                    case Tests: {
                        this.test = 0;
                        break;
                    }
                    case Test: {
                        ++this.test;
                        ArrayList<Property> arrayList = new ArrayList<Property>();
                        for (Property property : this.record.getProperties()) {
                            if (property.getName().indexOf(toxml_tags2.toString()) <= 0) continue;
                            arrayList.add(property);
                        }
                        for (Property property : arrayList) {
                            this.record.removeProperty(property);
                        }
                        break;
                    }
                    case Id: {
                        if (stringArray[toxml_attributes.type.ordinal()] == null) break;
                        string5 = n == 1 ? String.format("%s%s", string4, stringArray[toxml_attributes.type.ordinal()]) : String.format("%s%s", string4, stringArray[toxml_attributes.type.ordinal()]);
                        break;
                    }
                    case Name: {
                        if (stringArray[toxml_attributes.type.ordinal()] != null) {
                            string5 = n == 1 ? String.format("%s%s", string4, stringArray[toxml_attributes.type.ordinal()]) : String.format("%s%s", string4, stringArray[toxml_attributes.type.ordinal()]);
                        }
                        try {
                            string7 = toxml_names.valueOf(stringArray[toxml_attributes.type.ordinal()]).sameas();
                        }
                        catch (Exception exception5) {}
                        break;
                    }
                    case Datum: {
                        clazz = Number.class;
                        break;
                    }
                    case TextDatum: {
                        break;
                    }
                }
                Property property = new Property(string5, new LiteratureEntry(string6, "ToXML"));
                property.setClazz(clazz);
                property.setLabel(string7);
                this.properties.push(property);
            }
        }
        return false;
    }

    protected boolean endRecord(String string, Integer n, String string2, String string3, String string4) {
        boolean bl;
        block42: {
            bl = false;
            try {
                toxml_tags_level1 toxml_tags_level12 = toxml_tags_level1.valueOf(string);
                switch (toxml_tags_level12) {
                    case Compounds: {
                        return false;
                    }
                    case Compound: {
                        return false;
                    }
                    case Ids: {
                        return false;
                    }
                    case Names: {
                        return false;
                    }
                    case OtherIds: {
                        return false;
                    }
                    case InChI: {
                        if (toxml_tags.InChI.toString().equals(string2)) {
                            throw new Exception("Level 2");
                        }
                        return true;
                    }
                    case ToxicityStudies: {
                        return this.study == 0;
                    }
                }
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
                toxml_tags toxml_tags2 = toxml_tags.Default;
                try {
                    toxml_tags2 = toxml_tags.valueOf(string);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                toxml_tags toxml_tags3 = toxml_tags.Default;
                try {
                    toxml_tags3 = toxml_tags.valueOf(string2);
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                Property property = this.properties.pop();
                if (toxml_tags.TextDatum.equals((Object)toxml_tags3) || toxml_tags.Datum.equals((Object)toxml_tags3)) {
                    switch (toxml_tags2) {
                        case Name: {
                            property.setName(string4.trim());
                            this.properties.push(property);
                            return false;
                        }
                        case Value: {
                            if (String.class.equals((Object)property.getClazz())) {
                                this.setProperty(property, string4.trim());
                            } else {
                                try {
                                    this.setProperty(property, Double.parseDouble(string4.trim()));
                                }
                                catch (Exception exception4) {
                                    this.setProperty(property, string4.trim());
                                }
                            }
                            this.properties.push(property);
                            return false;
                        }
                        case Source: {
                            Object object = this.record.getProperty(property);
                            this.record.removeProperty(property);
                            property.setReference((ILiteratureEntry)new LiteratureEntry(string4.trim(), toxml_tags.Datum.toString()));
                            this.properties.push(property);
                            this.setProperty(property, object);
                            return false;
                        }
                    }
                }
                try {
                    toxml_quantity_types toxml_quantity_types2 = toxml_quantity_types.valueOf(string2);
                    switch (toxml_tags2) {
                        case Value: {
                            this.setProperty(property, string4.trim());
                        }
                        case Units: {
                            property.setUnits(string4 == null ? "" : string4.trim());
                        }
                    }
                    this.properties.push(property);
                    return false;
                }
                catch (Exception exception5) {
                    switch (toxml_tags2) {
                        case Study: {
                            bl = this.test == 0;
                            break;
                        }
                        case Tests: {
                            this.record.clearProperties();
                            break;
                        }
                        case Test: {
                            bl = true;
                            break;
                        }
                    }
                    if (string4 != null && !"".equals(string4.trim())) {
                        if (toxml_tags.InChI.toString().equals(string2)) {
                            this.record.setInchi(String.format("InChI=%s", string4.trim()));
                            this.record.setFormat(IStructureRecord.MOL_TYPE.INC.toString());
                            this.record.setContent(this.record.getInchi());
                            this.setProperty(property, this.record.getInchi());
                        } else {
                            this.setProperty(property, string4.trim());
                        }
                        break block42;
                    }
                    if (this.properties.size() <= 0) break block42;
                    Dictionary dictionary = new Dictionary(property.getName(), this.properties.peek().getName());
                    Integer n2 = this.dictionary.get(dictionary);
                    if (n2 == null) {
                        this.dictionary.put(dictionary, 1);
                        break block42;
                    }
                    this.dictionary.put(dictionary, n2 + 1);
                }
            }
        }
        if (bl) {
            this.record.setProperty(this.inchiProperty, (Object)this.record.getInchi());
        }
        return bl;
    }

    protected void setProperty(Property property, Object object) {
        Object object2 = this.record.getProperty(property);
        String string = property.getName();
        int n = 1;
        while (object2 != null) {
            property.setName(String.format("%s-%d", string, n));
            object2 = this.record.getProperty(property);
            ++n;
        }
        this.record.setProperty(property, object);
    }

    protected String getDotPath() {
        String string = this.tags.toString().replace(",", ".");
        string = string.replace(" ", "");
        string = string.replace("[", "");
        string = string.replace("]", "");
        string = string.replace("Compounds.", "");
        string = string.replace("Compound.", "");
        string = string.replace("ToxicityStudies.", "");
        return string;
    }

    public boolean hasNext() {
        try {
            while (this.reader.hasNext()) {
                int n = this.reader.next();
                switch (n) {
                    case 1: {
                        Integer n2;
                        String string = this.reader.getName().getLocalPart();
                        Hashtable<String, Integer> hashtable = this.branches.peek();
                        Integer n3 = hashtable.get(string);
                        if (n3 == null) {
                            n3 = 1;
                        } else {
                            n2 = n3;
                            Integer n4 = n3 = Integer.valueOf(n3 + 1);
                        }
                        hashtable.put(string, n3);
                        n2 = this.tags.size() == 0 ? null : this.tags.peek();
                        this.tags.push(string);
                        this.branches.push(new Hashtable());
                        if (!this.newRecord(string, n3, (String)((Object)n2), this.getDotPath())) break;
                        return true;
                    }
                    case 8: {
                        break;
                    }
                    case 2: {
                        this.processItem(this.tags.peek(), this.tmpValue, true);
                        String string = this.reader.getName().getLocalPart();
                        Hashtable<String, Integer> hashtable = this.branches.pop();
                        hashtable = this.branches.peek();
                        Integer n3 = hashtable.get(string);
                        this.tags.pop();
                        if (this.endRecord(string, n3, this.tags.size() == 0 ? null : this.tags.peek(), this.getDotPath(), this.tmpValue)) {
                            this.tmpValue = null;
                            return true;
                        }
                        this.tmpValue = null;
                        break;
                    }
                    case 4: {
                        String string = this.reader.getText();
                        if (string == null || "".equals(string)) break;
                        this.tmpValue = this.tmpValue == null ? string : String.format("%s%s", this.tmpValue, string.trim());
                        break;
                    }
                }
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected String[] readAttributes() {
        int n;
        String[] stringArray = new String[toxml_attributes.values().length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = null;
        }
        for (n = 0; n < this.reader.getAttributeCount(); ++n) {
            try {
                toxml_attributes toxml_attributes2 = toxml_attributes.valueOf(this.reader.getAttributeLocalName(n));
                stringArray[toxml_attributes2.ordinal()] = this.reader.getAttributeValue(n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringArray;
    }

    @Override
    public IStructureRecord nextRecord() {
        return this.record;
    }

    public IResourceFormat getFormat() {
        return null;
    }

    public Object next() {
        return this.record;
    }

    protected static enum toxml_quantity_types {
        ApplicationVolume,
        BackgroundCount,
        Concentration,
        Count3HTdRMean,
        Count3HTdRNetTotal,
        DistributionDuration,
        Dose,
        DoseDuration,
        Duration,
        EC3,
        EC3At100PercentPurity,
        FlowRate,
        FrequencyPeriod,
        HarvestTime,
        InterimChangeTime,
        LNCLabelActivity,
        LNCLabelConcentration,
        LNCLabelInjectionVolume,
        LymphNodesWeight,
        PreparationVolume,
        Quantity,
        RadioActivity,
        RecoveryDuration,
        ReferenceCompoundDose,
        SacrificeTime,
        SampleTime,
        TestSubstance,
        TestSubstanceInFormulation,
        TestSubstanceInPreparation,
        TestSubstanceInSolventVehicle,
        Time,
        TimeOfFindings,
        TreatmentTime,
        Value,
        Weight;

    }

    protected static enum toxml_tags {
        Default,
        Id,
        Name,
        InChI,
        Code,
        Study,
        Tests,
        Test,
        TextDatum,
        Datum,
        Source,
        Value,
        Units,
        LeadscopeStudyId,
        Dose;

    }

    protected static enum toxml_tags_level1 {
        Compounds,
        Compound,
        Ids,
        OtherIds,
        Names,
        InChI,
        Descriptors,
        Manufacturers,
        Formulae,
        PhysicalProperties,
        OtherProperties,
        ToxicityStudies,
        KnownDrugInformation,
        ModelApplications,
        Datasets,
        TextDatasets,
        OtherRtecsInformation,
        Structure,
        AdditionalMolFiles,
        InvalidMolFiles,
        AdditionalMolecularFormulas,
        InvalidMolecularFormulas,
        Comments;

    }

    protected static enum toxml_attributes {
        sources,
        type;

    }

    protected static enum toxml_names {
        chemName,
        IUPACName{

            @Override
            public String sameas() {
                return "http://www.opentox.org/api/1.1#IUPACName";
            }
        }
        ,
        synonym,
        tradeName{

            @Override
            public String sameas() {
                return "http://www.opentox.org/api/1.1#TradeName";
            }
        }
        ,
        trade{

            @Override
            public String sameas() {
                return "http://www.opentox.org/api/1.1#TradeName";
            }
        };


        public String sameas() {
            return "http://www.opentox.org/api/1.1#ChemicalName";
        }
    }
}

