/*
 * Decompiled with CFR 0.152.
 */
package signature.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SimpleGraph {
    public List<Edge> edges = new ArrayList<Edge>();
    public int maxVertexIndex;
    public String name;

    public SimpleGraph() {
    }

    public SimpleGraph(String graphString) {
        this();
        String[] stringArray = graphString.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String edgeString = stringArray[n2];
            String[] vertexStrings = edgeString.split(":");
            int a = Integer.parseInt(vertexStrings[0]);
            int b = Integer.parseInt(vertexStrings[1]);
            this.makeEdge(a, b);
            ++n2;
        }
    }

    public SimpleGraph(SimpleGraph graph, int[] permutation) {
        this();
        for (Edge e : graph.edges) {
            this.makeEdge(permutation[e.a], permutation[e.b]);
        }
    }

    public void makeEdge(int a, int b) {
        if (a > this.maxVertexIndex) {
            this.maxVertexIndex = a;
        }
        if (b > this.maxVertexIndex) {
            this.maxVertexIndex = b;
        }
        this.edges.add(new Edge(a, b));
    }

    public int getVertexCount() {
        return this.maxVertexIndex + 1;
    }

    public boolean isConnected(int i, int j) {
        for (Edge e : this.edges) {
            if ((e.a != i || e.b != j) && (e.b != i || e.a != j)) continue;
            return true;
        }
        return false;
    }

    public int[] getConnected(int vertexIndex) {
        ArrayList<Integer> connected = new ArrayList<Integer>();
        for (Edge edge : this.edges) {
            if (edge.a == vertexIndex) {
                connected.add(edge.b);
                continue;
            }
            if (edge.b != vertexIndex) continue;
            connected.add(edge.a);
        }
        int[] connectedArray = new int[connected.size()];
        int i = 0;
        Iterator iterator = connected.iterator();
        while (iterator.hasNext()) {
            int connectedVertexIndex;
            connectedArray[i] = connectedVertexIndex = ((Integer)iterator.next()).intValue();
            ++i;
        }
        return connectedArray;
    }

    public int degree(int vertexIndex) {
        int degreeCount = 0;
        for (Edge e : this.edges) {
            if (e.a != vertexIndex && e.b != vertexIndex) continue;
            ++degreeCount;
        }
        return degreeCount;
    }

    public String toString() {
        Collections.sort(this.edges);
        return this.edges.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Edge
    implements Comparable<Edge> {
        public int a;
        public int b;

        public Edge(int a, int b) {
            if (a < b) {
                this.a = a;
                this.b = b;
            } else {
                this.a = b;
                this.b = a;
            }
        }

        @Override
        public int compareTo(Edge other) {
            if (this.a < other.a || this.a == other.a && this.b < other.b) {
                return -1;
            }
            if (this.a == other.a && this.b == other.b) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            return String.valueOf(this.a) + "-" + this.b;
        }
    }
}

