/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractAtomicBasisFunction;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBasisSet;
import org.xmlcml.molutil.ChemicalElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLAtomicBasisFunction
extends AbstractAtomicBasisFunction {
    public static final String NS = "cml:atomicBasisFunction";

    public CMLAtomicBasisFunction() {
    }

    public CMLAtomicBasisFunction(CMLAtomicBasisFunction old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLAtomicBasisFunction(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLAtomicBasisFunction();
    }

    public CMLAtomicBasisFunction(int l, int m, int n, String lm, String symbol, String atomRef) {
        this();
        this.setL(l);
        this.setM(m);
        this.setN(n);
        this.setLm(lm);
        this.setSymbol(symbol);
        this.setAtomRef(atomRef);
    }

    public static List<CMLAtomicBasisFunction> getABFList(CMLAtom atom, CMLBasisSet.Basis basis) {
        ChemicalElement element;
        ArrayList<CMLAtomicBasisFunction> abfList = new ArrayList<CMLAtomicBasisFunction>();
        if (atom != null && atom.getId() != null && (element = ChemicalElement.getChemicalElement(atom.getElementType())) != null && basis.equals((Object)CMLBasisSet.Basis.MINIMAL)) {
            int n = element.getPeriod();
            int m = 0;
            int l = 0;
            String id = atom.getId();
            abfList.add(new CMLAtomicBasisFunction(l, m, n, "s", "s", id));
            if (n > 1) {
                abfList.add(new CMLAtomicBasisFunction(l, m, n, "px", "px", id));
                m = -1;
                abfList.add(new CMLAtomicBasisFunction(l, m, n, "py", "py", id));
                m = 1;
                abfList.add(new CMLAtomicBasisFunction(l, m, n, "pz", "pz", id));
            }
        }
        return abfList;
    }

    public String getString() {
        String s = "" + this.getN() + this.getLm() + "(" + this.getSymbol() + ")(" + this.getId() + ")";
        return s;
    }
}

