/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.core.data.MoleculeTools;
import ambit2.core.groups.ISGroup;
import ambit2.core.groups.SuppleAtomContainer;
import ambit2.core.io.SGroupMDL2000Helper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.io.MDLV2000ReaderTest")
public class MDLV2000ReaderExtended
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV2000ReaderExtended.class);
    private BooleanIOSetting forceReadAs3DCoords;
    private BooleanIOSetting interpretHydrogenIsotopes;
    private List<IAtom> atomsByLinePosition;

    public MDLV2000ReaderExtended() {
        this(new StringReader(""));
    }

    public MDLV2000ReaderExtended(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public MDLV2000ReaderExtended(InputStream inputStream, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(inputStream), mode);
    }

    public MDLV2000ReaderExtended(Reader reader) {
        this(reader, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV2000ReaderExtended(Reader reader, IChemObjectReader.Mode mode) {
        this.input = new BufferedReader(reader);
        this.initIOSettings();
        this.mode = mode;
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MDLV2000Format.getInstance();
    }

    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream inputStream) throws CDKException {
        this.setReader(new InputStreamReader(inputStream));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class<? extends IChemObject> clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (IChemFile.class.equals(classArray[i])) {
                return true;
            }
            if (IChemModel.class.equals(classArray[i])) {
                return true;
            }
            if (!IMolecule.class.equals(classArray[i])) continue;
            return true;
        }
        Class<? extends IChemObject> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            return this.accepts(clazz2);
        }
        return false;
    }

    public <T extends IChemObject> T read(T t) throws CDKException {
        if (t instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)t);
        }
        if (t instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)t);
        }
        if (t instanceof IMolecule) {
            return (T)this.readMolecule((IMolecule)t);
        }
        throw new CDKException("Only supported are ChemFile and Molecule.");
    }

    private IChemModel readChemModel(IChemModel iChemModel) throws CDKException {
        IMolecule iMolecule;
        IMoleculeSet iMoleculeSet = iChemModel.getMoleculeSet();
        if (iMoleculeSet == null) {
            iMoleculeSet = MoleculeTools.newMoleculeSet(iChemModel.getBuilder());
        }
        if ((iMolecule = this.readMolecule(MoleculeTools.newMolecule(iChemModel.getBuilder()))) != null) {
            iMoleculeSet.addMolecule(iMolecule);
        }
        iChemModel.setMoleculeSet(iMoleculeSet);
        return iChemModel;
    }

    private IChemFile readChemFile(IChemFile iChemFile) throws CDKException {
        String string;
        IChemSequence iChemSequence = MoleculeTools.newChemSequence(iChemFile.getBuilder());
        IChemModel iChemModel = MoleculeTools.newChemModel(iChemFile.getBuilder());
        IMoleculeSet iMoleculeSet = MoleculeTools.newMoleculeSet(iChemFile.getBuilder());
        IMolecule iMolecule = this.readMolecule(MoleculeTools.newMolecule(iChemFile.getBuilder()));
        if (iMolecule != null) {
            iMoleculeSet.addMolecule(iMolecule);
        }
        iChemModel.setMoleculeSet(iMoleculeSet);
        iChemSequence.addChemModel(iChemModel);
        iMoleculeSet = MoleculeTools.newMoleculeSet(iChemFile.getBuilder());
        iChemModel = MoleculeTools.newChemModel(iChemFile.getBuilder());
        try {
            String string2;
            while ((string2 = this.input.readLine()) != null) {
                int n;
                logger.debug((Object)"line: ", new Object[]{string2});
                String string3 = new String(string2);
                if (string3.equals("$$$$")) {
                    iMolecule = this.readMolecule(MoleculeTools.newMolecule(iChemFile.getBuilder()));
                    if (iMolecule == null) continue;
                    iMoleculeSet.addMolecule(iMolecule);
                    iChemModel.setMoleculeSet(iMoleculeSet);
                    iChemSequence.addChemModel(iChemModel);
                    iMoleculeSet = MoleculeTools.newMoleculeSet(iChemFile.getBuilder());
                    iChemModel = MoleculeTools.newChemModel(iChemFile.getBuilder());
                    continue;
                }
                if (iMolecule == null) continue;
                string = null;
                if (string3.startsWith("> ")) {
                    string3.substring(2);
                    int n2 = string3.indexOf("<");
                    if (n2 != -1 && (n = string3.substring(n2).indexOf(">")) != -1) {
                        string = string3.substring(n2 + 1, n2 + n);
                    }
                }
                if (string2 == null) {
                    throw new CDKException("Expecting data line here, but found null!");
                }
                StringBuilder stringBuilder = new StringBuilder();
                n = 0;
                boolean bl = false;
                while ((string2 = this.input.readLine()) != null && string2.trim().length() > 0) {
                    if (string2.equals("$$$$")) {
                        logger.error((Object)"Expecting data line here, but found end of molecule: ", new Object[]{string2});
                        break;
                    }
                    logger.debug((Object)"data line: ", new Object[]{string2});
                    bl = false;
                    if (!bl && ++n > 1) {
                        stringBuilder.append(System.getProperty("line.separator"));
                    }
                    stringBuilder.append(string2);
                    if (string2.length() != 80) continue;
                    bl = true;
                }
                if (string == null) continue;
                logger.info((Object)"fieldName, data: ", new Object[]{string, ", ", stringBuilder});
                iMolecule.setProperty((Object)string, (Object)stringBuilder.toString());
            }
        }
        catch (CDKException cDKException) {
            throw cDKException;
        }
        catch (Exception exception) {
            String string4 = "Error while parsing SDF";
            logger.error((Object)string4);
            logger.debug((Object)exception);
            throw new CDKException(string4, (Throwable)exception);
        }
        try {
            this.input.close();
        }
        catch (Exception exception) {
            string = "Error while closing file: " + exception.getMessage();
            logger.error((Object)string);
            throw new CDKException(string, (Throwable)exception);
        }
        iChemFile.addChemSequence(iChemSequence);
        return iChemFile;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private IMolecule readMolecule(IMolecule var1_1) throws CDKException {
        MDLV2000ReaderExtended.logger.debug((Object)"Reading new molecule");
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = (IBond.Stereo)CDKConstants.UNSET;
        var9_9 = 1;
        var10_10 = 0;
        var11_11 = null;
        var12_12 = 0.0;
        var14_13 = 0.0;
        var16_14 = 0.0;
        var18_15 = 0.0;
        var20_16 = 0.0;
        var22_17 = 0.0;
        var25_18 = "";
        var26_19 = new HashMap<Integer, IPseudoAtom>();
        var27_20 = null;
        try {
            var28_21 = IsotopeFactory.getInstance((IChemObjectBuilder)var1_1.getBuilder());
            MDLV2000ReaderExtended.logger.info((Object)"Reading header");
            var25_18 = this.input.readLine();
            ++var2_2;
            if (var25_18 == null) {
                return null;
            }
            MDLV2000ReaderExtended.logger.debug((Object)("Line " + var2_2 + ": " + var25_18));
            if (var25_18.startsWith("$$$$")) {
                MDLV2000ReaderExtended.logger.debug((Object)"File is empty, returning empty molecule");
                return var1_1;
            }
            if (var25_18.length() > 0) {
                var1_1.setProperty((Object)"cdk:Title", (Object)var25_18);
            }
            var25_18 = this.input.readLine();
            MDLV2000ReaderExtended.logger.debug((Object)("Line " + ++var2_2 + ": " + var25_18));
            var25_18 = this.input.readLine();
            MDLV2000ReaderExtended.logger.debug((Object)("Line " + ++var2_2 + ": " + var25_18));
            if (var25_18 == null) {
                throw new CDKException("Empty line");
            }
            if (var25_18.length() > 0) {
                var1_1.setProperty((Object)"cdk:Remark", (Object)var25_18);
            }
            MDLV2000ReaderExtended.logger.info((Object)"Reading rest of file");
            var25_18 = this.input.readLine();
            MDLV2000ReaderExtended.logger.debug((Object)("Line " + ++var2_2 + ": " + var25_18));
            if (var25_18.length() == 0) {
                do {
                    var25_18 = this.input.readLine();
                    ++var2_2;
                    if (var25_18 != null) continue;
                    return null;
                } while (!var25_18.startsWith("$$$$"));
                return var1_1;
            }
            if (var25_18.contains("V3000") || var25_18.contains("v3000")) {
                this.handleError("This file must be read with the MDLV3000Reader.");
            } else if (!var25_18.contains("V2000") && !var25_18.contains("v2000")) {
                this.handleError("This file must be read with the MDLReader.");
            }
            var3_3 = Integer.parseInt(var25_18.substring(0, 3).trim());
            MDLV2000ReaderExtended.logger.debug((Object)("Atomcount: " + var3_3));
            var4_4 = Integer.parseInt(var25_18.substring(3, 6).trim());
            MDLV2000ReaderExtended.logger.debug((Object)("Bondcount: " + var4_4));
            MDLV2000ReaderExtended.logger.info((Object)"Reading atom block");
            this.atomsByLinePosition = new ArrayList<IAtom>();
            this.atomsByLinePosition.add(null);
            var29_24 = 0;
            for (var30_27 = 0; var30_27 < var3_3; ++var30_27) {
                var25_18 = this.input.readLine();
                ++var2_2;
                ++var29_24;
                var12_12 = Double.parseDouble(var25_18.substring(0, 10).trim());
                var14_13 = Double.parseDouble(var25_18.substring(10, 20).trim());
                var16_14 = Double.parseDouble(var25_18.substring(20, 30).trim());
                var18_15 += Math.abs(var12_12);
                var20_16 += Math.abs(var14_13);
                var22_17 += Math.abs(var16_14);
                MDLV2000ReaderExtended.logger.debug((Object)("Coordinates: " + var12_12 + "; " + var14_13 + "; " + var16_14));
                var31_32 = var25_18.substring(31, 34).trim();
                MDLV2000ReaderExtended.logger.debug((Object)"Atom type: ", new Object[]{var31_32});
                if (var28_21.isElement((String)var31_32)) {
                    var24_31 = var28_21.configure(MoleculeTools.newAtom(var1_1.getBuilder(), (String)var31_32));
                } else if ("A".equals(var31_32)) {
                    var24_31 = MoleculeTools.newPseudoAtom(var1_1.getBuilder(), (String)var31_32);
                } else if ("Q".equals(var31_32)) {
                    var24_31 = MoleculeTools.newPseudoAtom(var1_1.getBuilder(), (String)var31_32);
                } else if ("*".equals(var31_32)) {
                    var24_31 = MoleculeTools.newPseudoAtom(var1_1.getBuilder(), (String)var31_32);
                } else if ("LP".equals(var31_32)) {
                    var24_31 = MoleculeTools.newPseudoAtom(var1_1.getBuilder(), (String)var31_32);
                } else if ("L".equals(var31_32)) {
                    var24_31 = MoleculeTools.newPseudoAtom(var1_1.getBuilder(), (String)var31_32);
                } else if (var31_32.equals("R") || var31_32.length() > 0 && var31_32.charAt(0) == 'R') {
                    MDLV2000ReaderExtended.logger.debug((Object)"Atom ", new Object[]{var31_32, " is not an regular element. Creating a PseudoAtom."});
                    var11_11 = var31_32.split("^R");
                    var24_31 = null;
                    if (var11_11.length > 1) {
                        try {
                            var9_9 = var10_10 = Integer.valueOf(var11_11[var11_11.length - 1]).intValue();
                            var31_32 = "R" + var10_10;
                            var24_31 = MoleculeTools.newPseudoAtom(var1_1.getBuilder(), (String)var31_32);
                        }
                        catch (Exception var32_46) {
                            var24_31 = MoleculeTools.newPseudoAtom(var1_1.getBuilder(), "R");
                            var26_19.put(var29_24, (IPseudoAtom)var24_31);
                        }
                    } else {
                        var24_31 = MoleculeTools.newPseudoAtom(var1_1.getBuilder(), "R");
                    }
                } else {
                    this.handleError("Invalid element type. Must be an existing element, or one in: A, Q, L, LP, *.", var2_2, 32, 35);
                    var24_31 = MoleculeTools.newPseudoAtom(var1_1.getBuilder(), (String)var31_32);
                }
                var24_31.setPoint3d(new Point3d(var12_12, var14_13, var16_14));
                var32_45 /* !! */  = var25_18.substring(34, 36).trim();
                MDLV2000ReaderExtended.logger.debug((Object)"Mass difference: ", new Object[]{var32_45 /* !! */ });
                if (!(var24_31 instanceof IPseudoAtom)) {
                    try {
                        var33_57 = Integer.parseInt((String)var32_45 /* !! */ );
                        if (var33_57 != 0) {
                            var34_65 = IsotopeFactory.getInstance((IChemObjectBuilder)var1_1.getBuilder()).getMajorIsotope((String)var31_32);
                            var24_31.setMassNumber(Integer.valueOf(var34_65.getMassNumber() + var33_57));
                        }
                    }
                    catch (Exception var33_58) {
                        this.handleError("Could not parse mass difference field.", var2_2, 35, 37, var33_58);
                    }
                } else {
                    MDLV2000ReaderExtended.logger.error((Object)"Cannot set mass difference for a non-element!");
                }
                var33_56 /* !! */  = var25_18.substring(36, 39).trim();
                MDLV2000ReaderExtended.logger.debug((Object)"Atom charge code: ", new Object[]{var33_56 /* !! */ });
                var34_64 = Integer.parseInt((String)var33_56 /* !! */ );
                if (var34_64 != 0) {
                    if (var34_64 == 1) {
                        var24_31.setFormalCharge(Integer.valueOf(3));
                    } else if (var34_64 == 2) {
                        var24_31.setFormalCharge(Integer.valueOf(2));
                    } else if (var34_64 == 3) {
                        var24_31.setFormalCharge(Integer.valueOf(1));
                    } else if (var34_64 != 4) {
                        if (var34_64 == 5) {
                            var24_31.setFormalCharge(Integer.valueOf(-1));
                        } else if (var34_64 == 6) {
                            var24_31.setFormalCharge(Integer.valueOf(-2));
                        } else if (var34_64 == 7) {
                            var24_31.setFormalCharge(Integer.valueOf(-3));
                        }
                    }
                }
                try {
                    var35_72 = var25_18.substring(60, 63).trim();
                    MDLV2000ReaderExtended.logger.debug((Object)"Parsing mapping id: ", new Object[]{var35_72});
                    try {
                        var36_80 = Integer.parseInt(var35_72);
                        if (var36_80 != 0) {
                            var24_31.setID(var35_72);
                        }
                    }
                    catch (Exception var36_81) {
                        MDLV2000ReaderExtended.logger.error((Object)"Mapping number ", new Object[]{var35_72, " is not an integer."});
                        MDLV2000ReaderExtended.logger.debug((Object)var36_81);
                    }
                }
                catch (Exception var35_73) {
                    MDLV2000ReaderExtended.logger.warn((Object)"A few fields are missing. Older MDL MOL file?");
                }
                if (var25_18.length() >= 78) {
                    var35_74 = Double.parseDouble(var25_18.substring(69, 80).trim());
                    var24_31.setProperty((Object)"first shift", (Object)var35_74);
                }
                if (var25_18.length() >= 87) {
                    var35_75 = Double.parseDouble(var25_18.substring(79, 87).trim());
                    var24_31.setProperty((Object)"second shift", (Object)var35_75);
                }
                var1_1.addAtom(var24_31);
                this.atomsByLinePosition.add(var24_31);
            }
            if (var18_15 == 0.0 && var20_16 == 0.0 && var22_17 == 0.0) {
                MDLV2000ReaderExtended.logger.info((Object)"All coordinates are 0.0");
                for (Object var31_32 : var1_1.atoms()) {
                    var31_32.setPoint3d(null);
                }
            } else if (var22_17 == 0.0 && !this.forceReadAs3DCoords.isSet()) {
                MDLV2000ReaderExtended.logger.info((Object)"Total 3D Z is 0.0, interpreting it as a 2D structure");
                for (Object var31_32 : var1_1.atoms()) {
                    var32_45 /* !! */  = var31_32.getPoint3d();
                    if (var32_45 /* !! */  == null) continue;
                    var31_32.setPoint2d(new Point2d(var32_45 /* !! */ .x, var32_45 /* !! */ .y));
                    var31_32.setPoint3d(null);
                }
            }
            MDLV2000ReaderExtended.logger.info((Object)"Reading bond block");
            for (var30_30 = 0; var30_30 < var4_4; ++var30_30) {
                var25_18 = this.input.readLine();
                ++var2_2;
                var5_5 = Integer.parseInt(var25_18.substring(0, 3).trim());
                var6_6 = Integer.parseInt(var25_18.substring(3, 6).trim());
                var7_7 = Integer.parseInt(var25_18.substring(6, 9).trim());
                if (var25_18.length() >= 12) {
                    v0 = var31_33 = var25_18.length() > 12 ? Integer.parseInt(var25_18.substring(9, 12).trim()) : Integer.parseInt(var25_18.substring(9).trim());
                    if (var31_33 == 1) {
                        var8_8 = IBond.Stereo.UP;
                    } else if (var31_33 == 6) {
                        var8_8 = IBond.Stereo.DOWN;
                    } else if (var31_33 == 0) {
                        var8_8 = var7_7 == 2 ? IBond.Stereo.E_Z_BY_COORDINATES : IBond.Stereo.NONE;
                    } else if (var31_33 == 3 && var7_7 == 2) {
                        var8_8 = IBond.Stereo.E_OR_Z;
                    } else if (var31_33 == 4) {
                        var8_8 = (IBond.Stereo)CDKConstants.UNSET;
                    }
                } else {
                    this.handleError("Missing expected stereo field at line: ", var2_2, 10, 12);
                }
                if (MDLV2000ReaderExtended.logger.isDebugEnabled()) {
                    MDLV2000ReaderExtended.logger.debug((Object)("Bond: " + var5_5 + " - " + var6_6 + "; order " + var7_7));
                }
                var31_32 = var1_1.getAtom(var5_5 - 1);
                var32_45 /* !! */  = var1_1.getAtom(var6_6 - 1);
                var33_56 /* !! */  = null;
                if (var7_7 == 1) {
                    var33_56 /* !! */  = MoleculeTools.newBond(var1_1.getBuilder(), (IAtom)var31_32, (IAtom)var32_45 /* !! */ , IBond.Order.SINGLE, var8_8);
                } else if (var7_7 == 2) {
                    var33_56 /* !! */  = MoleculeTools.newBond(var1_1.getBuilder(), (IAtom)var31_32, (IAtom)var32_45 /* !! */ , IBond.Order.DOUBLE, var8_8);
                } else if (var7_7 == 3) {
                    var33_56 /* !! */  = MoleculeTools.newBond(var1_1.getBuilder(), (IAtom)var31_32, (IAtom)var32_45 /* !! */ , IBond.Order.TRIPLE, var8_8);
                } else if (var7_7 == 4) {
                    var33_56 /* !! */  = MoleculeTools.newBond(var1_1.getBuilder(), (IAtom)var31_32, (IAtom)var32_45 /* !! */ , IBond.Order.SINGLE, var8_8);
                    var33_56 /* !! */ .setFlag(5, true);
                    var31_32.setFlag(5, true);
                    var32_45 /* !! */ .setFlag(5, true);
                } else {
                    throw new CDKException("Detected 'query bond type ' (value=" + var7_7 + ")." + " Could not create regular molecule.");
                }
                var1_1.addBond(var33_56 /* !! */ );
            }
            MDLV2000ReaderExtended.logger.info((Object)"Reading property block");
            while (true) {
                var25_18 = this.input.readLine();
                ++var2_2;
                if (var25_18 == null) {
                    this.handleError("The expected property block is missing!", var2_2, 0, 0);
                }
                if (var25_18.startsWith("M  END")) break;
                var30_30 = 0;
                if (var25_18.startsWith("M  CHG")) {
                    var31_35 = Integer.parseInt(var25_18.substring(6, 9).trim());
                    var32_47 = new StringTokenizer(var25_18.substring(9));
                    for (var33_59 = 1; var33_59 <= var31_35; ++var33_59) {
                        var34_66 = var32_47.nextToken();
                        var35_76 = Integer.parseInt(var34_66.trim());
                        var34_66 = var32_47.nextToken();
                        var36_82 = Integer.parseInt(var34_66.trim());
                        var1_1.getAtom(var35_76 - 1).setFormalCharge(Integer.valueOf(var36_82));
                    }
                } else if (var25_18.matches("^A    \\d+")) {
                    var31_36 = Integer.parseInt(var25_18.replaceFirst("^A    ", "")) - var9_9;
                    var25_18 = this.input.readLine();
                    ++var2_2;
                    var32_48 = var25_18.split("\\\\");
                    var33_60 = "";
                    for (var34_67 = 0; var34_67 < var32_48.length; ++var34_67) {
                        var33_60 = var33_60 + var32_48[var34_67];
                    }
                    var34_68 = var1_1.getAtom(var31_36);
                    var35_77 = MoleculeTools.newPseudoAtom(var1_1.getBuilder(), var33_60);
                    if (var34_68.getPoint2d() != null) {
                        var35_77.setPoint2d(var34_68.getPoint2d());
                    }
                    if (var34_68.getPoint3d() != null) {
                        var35_77.setPoint3d(var34_68.getPoint3d());
                    }
                    var1_1.addAtom((IAtom)var35_77);
                    var36_83 = var1_1.getConnectedBondsList(var34_68);
                    for (var37_86 = 0; var37_86 < var36_83.size(); ++var37_86) {
                        var38_89 = (IBond)var36_83.get(var37_86);
                        var39_91 = var38_89.getConnectedAtom(var34_68);
                        var40_92 = MoleculeTools.newBond(var38_89.getBuilder());
                        var40_92.setAtoms(new IAtom[]{var39_91, var35_77});
                        var40_92.setOrder(var38_89.getOrder());
                        var1_1.addBond(var40_92);
                        var1_1.removeBond(var34_68, var39_91);
                    }
                    var1_1.removeAtom(var34_68);
                    ++var9_9;
                } else if (var25_18.startsWith("M  ISO")) {
                    try {
                        var31_37 = var25_18.substring(6, 10).trim();
                        var32_49 = Integer.parseInt(var31_37);
                        var33_61 = new StringTokenizer(var25_18.substring(10));
                        for (var34_69 = 1; var34_69 <= var32_49; ++var34_69) {
                            var35_78 = Integer.parseInt(var33_61.nextToken().trim());
                            var36_84 = Integer.parseInt(var33_61.nextToken().trim());
                            if (var36_84 == 0) continue;
                            var37_87 = var1_1.getAtom(var35_78 - 1);
                            var37_87.setMassNumber(Integer.valueOf(var36_84));
                        }
                    }
                    catch (NumberFormatException var31_38) {
                        var32_50 = "Error (" + var31_38.getMessage() + ") while parsing line " + var2_2 + ": " + var25_18 + " in property block.";
                        MDLV2000ReaderExtended.logger.error((Object)var32_50);
                        this.handleError("NumberFormatException in isotope information.", var2_2, 7, 11, var31_38);
                    }
                } else if (var25_18.startsWith("M  RAD")) {
                    try {
                        var31_39 = var25_18.substring(6, 9).trim();
                        var32_51 = Integer.parseInt(var31_39);
                        var33_62 = new StringTokenizer(var25_18.substring(9));
                        for (var34_70 = 1; var34_70 <= var32_51; ++var34_70) {
                            var35_79 = Integer.parseInt(var33_62.nextToken().trim());
                            var36_85 = Integer.parseInt(var33_62.nextToken().trim());
                            if (var36_85 <= 1) continue;
                            var37_88 = var1_1.getAtom(var35_79 - 1);
                            for (var38_90 = 2; var38_90 <= var36_85; ++var38_90) {
                                var1_1.addSingleElectron(MoleculeTools.newSingleElectron(var1_1.getBuilder(), var37_88));
                            }
                        }
                    }
                    catch (NumberFormatException var31_40) {
                        var32_52 = "Error (" + var31_40.getMessage() + ") while parsing line " + var2_2 + ": " + var25_18 + " in property block.";
                        MDLV2000ReaderExtended.logger.error((Object)var32_52);
                        this.handleError("NumberFormatException in radical information", var2_2, 7, 10, var31_40);
                    }
                } else if (var25_18.startsWith("G  ")) {
                    try {
                        var31_41 = var25_18.substring(3, 6).trim();
                        var32_53 = Integer.parseInt(var31_41);
                        var33_63 = this.input.readLine();
                        var34_71 = var1_1.getAtom(var32_53 - 1);
                        var35_77 = MoleculeTools.newPseudoAtom(var1_1.getBuilder(), var33_63);
                        if (var34_71.getPoint2d() != null) {
                            var35_77.setPoint2d(var34_71.getPoint2d());
                        }
                        if (var34_71.getPoint3d() != null) {
                            var35_77.setPoint3d(var34_71.getPoint3d());
                        }
                        AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)var1_1, (IAtom)var34_71, (IAtom)var35_77);
                    }
                    catch (NumberFormatException var31_42) {
                        var32_54 = "Error (" + var31_42.toString() + ") while parsing line " + var2_2 + ": " + var25_18 + " in property block.";
                        MDLV2000ReaderExtended.logger.error((Object)var32_54);
                        this.handleError("NumberFormatException in group information", var2_2, 4, 7, var31_42);
                    }
                } else {
                    try {
                        var31_43 = SGroupMDL2000Helper.getValue(var25_18);
                        if (!(var1_1 instanceof SuppleAtomContainer)) {
                            var32_55 = new SuppleAtomContainer();
                            var32_55.setFiltered(false);
                            var32_55.add((IAtomContainer)var1_1);
                            var1_1 = var32_55;
                        }
                        if (!(var1_1 instanceof SuppleAtomContainer)) ** GOTO lbl365
                        if (var27_20 == null) {
                            var27_20 = new Hashtable<Integer, ISGroup>();
                        }
                        var31_43.updateSGroups(var25_18, (SuppleAtomContainer)var1_1, var27_20);
                    }
                    catch (Exception var31_44) {
                        if (this.mode == IChemObjectReader.Mode.STRICT) {
                            throw new CDKException(var31_44.getMessage());
                        }
                        MDLV2000ReaderExtended.logger.warn((Object)var31_44.getMessage());
                    }
                }
lbl365:
                // 11 sources

                if (var30_30 != 0) continue;
                MDLV2000ReaderExtended.logger.warn((Object)"Skipping line in property block: ", new Object[]{var25_18});
            }
        }
        catch (CDKException var28_22) {
            var29_25 = "Error while parsing line " + var2_2 + ": " + var25_18 + " -> " + var28_22.getMessage();
            MDLV2000ReaderExtended.logger.error((Object)var29_25);
            MDLV2000ReaderExtended.logger.debug((Object)var28_22);
            throw var28_22;
        }
        catch (Exception var28_23) {
            var28_23.printStackTrace();
            var29_26 = "Error while parsing line " + var2_2 + ": " + var25_18 + " -> " + var28_23.getMessage();
            MDLV2000ReaderExtended.logger.error((Object)var29_26);
            MDLV2000ReaderExtended.logger.debug((Object)var28_23);
            this.handleError("Error while parsing line: " + var25_18, var2_2, 0, 0, var28_23);
        }
        if (this.interpretHydrogenIsotopes.isSet()) {
            this.fixHydrogenIsotopes(var1_1);
        }
        if (var27_20 != null) {
            var28_21 = var27_20.values().iterator();
            while (var28_21.hasNext()) {
                var1_1.addAtom((IAtom)var28_21.next());
            }
        }
        return var1_1;
    }

    private void fixHydrogenIsotopes(IMolecule iMolecule) {
        for (IAtom iAtom : iMolecule.atoms()) {
            IAtom iAtom2;
            if (!(iAtom instanceof IPseudoAtom)) continue;
            IPseudoAtom iPseudoAtom = (IPseudoAtom)iAtom;
            Integer n = iAtom.getMassNumber();
            if ("D".equals(iPseudoAtom.getLabel()) && n != null && n == 2) {
                iAtom2 = MoleculeTools.newAtom(iMolecule.getBuilder(), iAtom);
                iAtom2.setSymbol("H");
                AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)iMolecule, (IAtom)iAtom, (IAtom)iAtom2);
                continue;
            }
            if (!"T".equals(iPseudoAtom.getLabel()) || n == null || n != 3) continue;
            iAtom2 = MoleculeTools.newAtom(iMolecule.getBuilder(), iAtom);
            iAtom2.setSymbol("H");
            AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)iMolecule, (IAtom)iAtom, (IAtom)iAtom2);
        }
    }

    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
        this.forceReadAs3DCoords = new BooleanIOSetting("ForceReadAs3DCoordinates", 2, "Should coordinates always be read as 3D?", "false");
        this.interpretHydrogenIsotopes = new BooleanIOSetting("InterpretHydrogenIsotopes", 2, "Should D and T be interpreted as hydrogen isotopes?", "true");
    }

    public void customizeJob() {
        this.fireIOSettingQuestion((IOSetting)this.forceReadAs3DCoords);
        this.fireIOSettingQuestion((IOSetting)this.interpretHydrogenIsotopes);
    }

    public IOSetting[] getIOSettings() {
        IOSetting[] iOSettingArray = new IOSetting[]{this.forceReadAs3DCoords, this.interpretHydrogenIsotopes};
        return iOSettingArray;
    }

    public List<IAtom> getAtomsByLinePosition() {
        return this.atomsByLinePosition;
    }

    public void handleError(String string) throws CDKException {
    }

    public void handleError(String string, Exception exception) throws CDKException {
    }

    public void handleError(String string, int n, int n2, int n3) throws CDKException {
    }

    public void handleError(String string, int n, int n2, int n3, Exception exception) throws CDKException {
    }
}

