/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.chemistry;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.chemistry.CompoundAbstractProcessing;
import com.rapidminer.operator.chemistry.Compounds;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.modeling.builder3d.ModelBuilder3D;
import org.openscience.cdk.modeling.builder3d.TemplateHandler3D;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class CompoundConvert3D
extends CompoundAbstractProcessing {
    public static final String PARAMETER_FORCEFIELD = "forcefield";
    public static final String[] convert3DStrings = new String[]{"mm2", "mmff94"};
    public static final String PARAMETER_CONVERT_ALL = "convert_all_compounds";
    public static final String PARAMETER_CPD_INDEX = "index_of_compound_to_convert";

    public CompoundConvert3D(OperatorDescription operatorDescription) {
        super(operatorDescription);
    }

    public List<ParameterType> getParameterTypes() {
        List list = super.getParameterTypes();
        ParameterTypeCategory parameterTypeCategory = null;
        parameterTypeCategory = new ParameterTypeCategory(PARAMETER_FORCEFIELD, "Forcefield for converting compounds to 3D.", convert3DStrings, 0);
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        parameterTypeCategory = new ParameterTypeBoolean(PARAMETER_CONVERT_ALL, "Convert all compounds to 3D.", false);
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        parameterTypeCategory = new ParameterTypeInt(PARAMETER_CPD_INDEX, "Index of compound to rename.", 1, Integer.MAX_VALUE, 1);
        parameterTypeCategory.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_CONVERT_ALL, true, false));
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        return list;
    }

    public void doWork() throws OperatorException {
        int n;
        Compounds compounds = (Compounds)this.molInput.getData();
        Compounds compounds2 = new Compounds();
        try {
            n = compounds.size();
            for (int i = 0; i < n; ++i) {
                compounds2.addMolecule(compounds.getMolecule(i).clone());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = this.getParameterAsString(PARAMETER_FORCEFIELD);
        if (this.getParameterAsBoolean(PARAMETER_CONVERT_ALL)) {
            int n2 = compounds.size();
            for (n = 0; n < n2; ++n) {
                compounds.setMolecule(n, this.Convert3D(compounds.getMolecule(n), string));
            }
        } else {
            n = this.getParameterAsInt(PARAMETER_CPD_INDEX);
            compounds.setMolecule(n - 1, this.Convert3D(compounds.getMolecule(n - 1), string));
        }
        compounds.recalculateStatistics();
        this.molOriginal.deliver((IOObject)compounds2);
        this.molOutput.deliver((IOObject)compounds);
    }

    private IAtomContainer Convert3D(IAtomContainer iAtomContainer, String string) {
        try {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)iAtomContainer);
            TemplateHandler3D templateHandler3D = TemplateHandler3D.getInstance();
            ModelBuilder3D modelBuilder3D = ModelBuilder3D.getInstance((TemplateHandler3D)templateHandler3D, (String)string);
            return modelBuilder3D.generate3DCoordinates((IMolecule)iAtomContainer, true);
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.FINE, null, exception);
            return null;
        }
    }
}

