/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.core.data.MoleculeTools;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

@TestClass(value="org.openscience.cdk.io.MDLWriterTest")
public class MDLWriter
extends DefaultChemObjectWriter {
    public Map sdFields = null;
    private int moleculeNumber;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLWriter.class);
    private BooleanIOSetting forceWriteAs2DCoords;
    private BufferedWriter writer;

    public MDLWriter(Writer writer) {
        this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        this.initIOSettings();
        this.moleculeNumber = 1;
    }

    public MDLWriter(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream));
    }

    public MDLWriter() {
        this(new StringWriter());
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MDLFormat.getInstance();
    }

    public void setWriter(Writer writer) throws CDKException {
        this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public void setWriter(OutputStream outputStream) throws CDKException {
        this.setWriter(new OutputStreamWriter(outputStream));
    }

    public void dontWriteAromatic() {
    }

    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.writer.close();
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (IAtomContainer.class.equals(classArray[i])) {
                return true;
            }
            if (IChemFile.class.equals(classArray[i])) {
                return true;
            }
            if (!IChemModel.class.equals(classArray[i])) continue;
            return true;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            return this.accepts(clazz2);
        }
        return false;
    }

    public void write(IChemObject iChemObject) throws CDKException {
        this.customizeJob();
        try {
            if (iChemObject instanceof IChemFile) {
                this.writeChemFile((IChemFile)iChemObject);
                return;
            }
            if (iChemObject instanceof IChemModel) {
                IChemFile iChemFile = MoleculeTools.newChemFile(iChemObject.getBuilder());
                IChemSequence iChemSequence = MoleculeTools.newChemSequence(iChemObject.getBuilder());
                iChemSequence.addChemModel((IChemModel)iChemObject);
                iChemFile.addChemSequence(iChemSequence);
                this.writeChemFile(iChemFile);
                return;
            }
            if (iChemObject instanceof IAtomContainer) {
                this.writeMolecule((IAtomContainer)iChemObject);
                return;
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
            logger.debug((Object)exception);
            throw new CDKException("Exception while writing MDL file: " + exception.getMessage(), (Throwable)exception);
        }
        throw new CDKException("Only supported is writing of IChemFile, IChemModel, and IAtomContainer objects.");
    }

    private void writeChemFile(IChemFile iChemFile) throws Exception {
        IAtomContainer iAtomContainer = MoleculeTools.newAtomContainer(iChemFile.getBuilder());
        for (IAtomContainer iAtomContainer2 : ChemFileManipulator.getAllAtomContainers((IChemFile)iChemFile)) {
            iAtomContainer.add(iAtomContainer2);
            if (iAtomContainer2.getProperty((Object)"cdk:Title") != null) {
                if (iAtomContainer.getProperty((Object)"cdk:Title") != null) {
                    iAtomContainer.setProperty((Object)"cdk:Title", (Object)(iAtomContainer.getProperty((Object)"cdk:Title") + "; " + iAtomContainer2.getProperty((Object)"cdk:Title")));
                } else {
                    iAtomContainer.setProperty((Object)"cdk:Title", iAtomContainer2.getProperty((Object)"cdk:Title"));
                }
            }
            if (iAtomContainer2.getProperty((Object)"cdk:Remark") == null) continue;
            if (iAtomContainer.getProperty((Object)"cdk:Remark") != null) {
                iAtomContainer.setProperty((Object)"cdk:Remark", (Object)(iAtomContainer.getProperty((Object)"cdk:Remark") + "; " + iAtomContainer2.getProperty((Object)"cdk:Remark")));
                continue;
            }
            iAtomContainer.setProperty((Object)"cdk:Remark", iAtomContainer2.getProperty((Object)"cdk:Remark"));
        }
        this.writeMolecule(iAtomContainer);
    }

    public void writeMolecule(IAtomContainer iAtomContainer) throws Exception {
        int n;
        Integer n2;
        if (this.moleculeNumber == 2) {
            this.writer.write("$$$$");
            this.writer.newLine();
        }
        String string = "";
        ArrayList<Integer> arrayList = null;
        String string2 = (String)iAtomContainer.getProperty((Object)"cdk:Title");
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() > 80) {
            string2 = string2.substring(0, 80);
        }
        this.writer.write(string2);
        this.writer.newLine();
        this.writer.write("  CDK     ");
        this.writer.write(new SimpleDateFormat("MMddyyHHmm").format(System.currentTimeMillis()));
        this.writer.newLine();
        String string3 = (String)iAtomContainer.getProperty((Object)"cdk:Remark");
        if (string3 == null) {
            string3 = "";
        }
        if (string3.length() > 80) {
            string3 = string3.substring(0, 80);
        }
        this.writer.write(string3);
        this.writer.newLine();
        string = string + MDLWriter.formatMDLInt(iAtomContainer.getAtomCount(), 3);
        string = string + MDLWriter.formatMDLInt(iAtomContainer.getBondCount(), 3);
        string = string + "  0  0  0  0  0  0  0  0999 V2000";
        this.writer.write(string);
        this.writer.newLine();
        for (int i = 0; i < iAtomContainer.getAtomCount(); ++i) {
            IAtom iAtom = iAtomContainer.getAtom(i);
            string = "";
            if (iAtom.getPoint3d() != null && !this.forceWriteAs2DCoords.isSet()) {
                string = string + MDLWriter.formatMDLFloat((float)iAtom.getPoint3d().x);
                string = string + MDLWriter.formatMDLFloat((float)iAtom.getPoint3d().y);
                string = string + MDLWriter.formatMDLFloat((float)iAtom.getPoint3d().z) + " ";
            } else if (iAtom.getPoint2d() != null) {
                string = string + MDLWriter.formatMDLFloat((float)iAtom.getPoint2d().x);
                string = string + MDLWriter.formatMDLFloat((float)iAtom.getPoint2d().y);
                string = string + "    0.0000 ";
            } else {
                string = string + MDLWriter.formatMDLFloat(0.0f);
                string = string + MDLWriter.formatMDLFloat(0.0f);
                string = string + MDLWriter.formatMDLFloat(0.0f) + " ";
            }
            if (iAtomContainer.getAtom(i) instanceof IPseudoAtom) {
                IPseudoAtom iPseudoAtom = (IPseudoAtom)iAtomContainer.getAtom(i);
                if (iPseudoAtom.getSymbol().equals("R") && iPseudoAtom.getLabel().length() > 1) {
                    string = string + "R# ";
                    if (arrayList == null) {
                        arrayList = new ArrayList<Integer>();
                    }
                    n2 = new Integer(iPseudoAtom.getLabel().substring(1));
                    arrayList.add(i + 1);
                    arrayList.add(n2);
                } else {
                    string = string + MDLWriter.formatMDLString(((IPseudoAtom)iAtomContainer.getAtom(i)).getLabel(), 3);
                }
            } else {
                string = string + MDLWriter.formatMDLString(iAtomContainer.getAtom(i).getSymbol(), 3);
            }
            string = string + " 0  0  0  0  0  0  0  0  0  0  0  0";
            this.writer.write(string);
            this.writer.newLine();
        }
        for (IAtom iAtom : iAtomContainer.bonds()) {
            if (iAtom.getAtomCount() != 2) {
                logger.warn((Object)("Skipping bond with more/less than two atoms: " + iAtom));
                continue;
            }
            if (iAtom.getStereo() == IBond.Stereo.UP_INVERTED || iAtom.getStereo() == IBond.Stereo.DOWN_INVERTED) {
                string = MDLWriter.formatMDLInt(iAtomContainer.getAtomNumber(iAtom.getAtom(1)) + 1, 3);
                string = string + MDLWriter.formatMDLInt(iAtomContainer.getAtomNumber(iAtom.getAtom(0)) + 1, 3);
            } else {
                string = MDLWriter.formatMDLInt(iAtomContainer.getAtomNumber(iAtom.getAtom(0)) + 1, 3);
                string = string + MDLWriter.formatMDLInt(iAtomContainer.getAtomNumber(iAtom.getAtom(1)) + 1, 3);
            }
            int n3 = iAtom.getOrder().ordinal() + 1;
            if (iAtom.getFlag(5)) {
                n3 = 4;
            }
            string = string + MDLWriter.formatMDLInt(n3, 3);
            string = string + "  ";
            switch (iAtom.getStereo()) {
                case UP: {
                    string = string + "1";
                    break;
                }
                case UP_INVERTED: {
                    string = string + "1";
                    break;
                }
                case DOWN: {
                    string = string + "6";
                    break;
                }
                case DOWN_INVERTED: {
                    string = string + "6";
                    break;
                }
                case UP_OR_DOWN: {
                    string = string + "4";
                    break;
                }
                case E_OR_Z: {
                    string = string + "3";
                    break;
                }
                default: {
                    string = string + "0";
                }
            }
            string = string + "  0  0  0 ";
            this.writer.write(string);
            this.writer.newLine();
        }
        for (n = 0; n < iAtomContainer.getAtomCount(); ++n) {
            IAtom iAtom = iAtomContainer.getAtom(n);
            n2 = iAtom.getFormalCharge();
            if (n2 == null || n2 == 0) continue;
            this.writer.write("M  CHG  1 ");
            this.writer.write(MDLWriter.formatMDLInt(n + 1, 3));
            this.writer.write(" ");
            this.writer.write(MDLWriter.formatMDLInt(n2, 3));
            this.writer.newLine();
        }
        for (n = 0; n < iAtomContainer.getAtomCount(); ++n) {
            IAtom iAtom = iAtomContainer.getAtom(n);
            if (iAtom instanceof IPseudoAtom || (n2 = iAtom.getMassNumber()) == null) continue;
            int n4 = IsotopeFactory.getInstance((IChemObjectBuilder)iAtom.getBuilder()).getMajorIsotope(iAtom.getSymbol()).getMassNumber();
            if (n2 == n4) continue;
            this.writer.write("M  ISO  1 ");
            this.writer.write(MDLWriter.formatMDLInt(n + 1, 3));
            this.writer.write(" ");
            this.writer.write(MDLWriter.formatMDLInt(n2, 3));
            this.writer.newLine();
        }
        if (arrayList != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = 0;
            for (int i = 1; i <= arrayList.size(); ++i) {
                stringBuffer.append(MDLWriter.formatMDLInt((Integer)arrayList.get(i - 1), 4));
                stringBuffer.append(MDLWriter.formatMDLInt((Integer)arrayList.get(++i - 1), 4));
                ++n5;
                if (i != arrayList.size() && i != 16) continue;
                stringBuffer.insert(0, "M  RGP" + MDLWriter.formatMDLInt(n5, 3));
                this.writer.write(stringBuffer.toString());
                this.writer.newLine();
                stringBuffer = new StringBuffer();
                n5 = 0;
            }
        }
        this.writer.write("M  END");
        this.writer.newLine();
        if (this.sdFields != null) {
            Set set = this.sdFields.keySet();
            for (Object k : set) {
                this.writer.write("> <" + k.toString() + ">");
                this.writer.newLine();
                this.writer.write(this.sdFields.get(k).toString());
                this.writer.newLine();
                this.writer.newLine();
            }
        }
        if (this.moleculeNumber != 1) {
            this.writer.write("$$$$");
            this.writer.newLine();
        }
        ++this.moleculeNumber;
        this.writer.flush();
    }

    protected static String formatMDLInt(int n, int n2) {
        String string = "";
        String string2 = "";
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        numberFormat.setParseIntegerOnly(true);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(n2);
        numberFormat.setGroupingUsed(false);
        string = numberFormat.format(n);
        n2 -= string.length();
        for (int i = 0; i < n2; ++i) {
            string2 = string2 + " ";
        }
        string2 = string2 + string;
        return string2;
    }

    protected static String formatMDLFloat(float f) {
        String string = "";
        String string2 = "";
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(4);
        numberFormat.setMinimumFractionDigits(4);
        numberFormat.setMaximumFractionDigits(4);
        numberFormat.setGroupingUsed(false);
        string = numberFormat.format(f);
        int n = 10 - string.length();
        for (int i = 0; i < n; ++i) {
            string2 = string2 + " ";
        }
        string2 = string2 + string;
        return string2;
    }

    protected static String formatMDLString(String string, int n) {
        if ((string = string.trim()).length() > n) {
            return string.substring(0, n);
        }
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            string = string + " ";
        }
        return string;
    }

    private void initIOSettings() {
        this.forceWriteAs2DCoords = new BooleanIOSetting("ForceWriteAs2DCoordinates", 2, "Should coordinates always be written as 2D?", "false");
    }

    public void customizeJob() {
        this.fireIOSettingQuestion((IOSetting)this.forceWriteAs2DCoords);
    }

    public IOSetting[] getIOSettings() {
        IOSetting[] iOSettingArray = new IOSetting[]{this.forceWriteAs2DCoords};
        return iOSettingArray;
    }

    public void setSdFields(Map map) {
        this.sdFields = map;
    }
}

