/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.color;

import java.awt.Color;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.renderer.color.IAtomColorer;

@TestClass(value="org.openscience.cdk.renderer.color.PartialAtomicChargeColorsTest")
public class PartialAtomicChargeColors
implements IAtomColorer {
    @TestMethod(value="testGetAtomColor")
    public Color getAtomColor(IAtom atom) {
        return this.getAtomColor(atom, Color.white);
    }

    @TestMethod(value="testGetDefaultAtomColor")
    public Color getAtomColor(IAtom atom, Color defaultColor) {
        Color color = defaultColor;
        if (atom.getCharge() == null) {
            return defaultColor;
        }
        double charge = atom.getCharge();
        if (charge > 0.0) {
            if (charge < 1.0) {
                int index = 255 - (int)(charge * 255.0);
                color = new Color(index, index, 255);
            } else {
                color = Color.blue;
            }
        } else if (charge < 0.0) {
            if (charge > -1.0) {
                int index = 255 + (int)(charge * 255.0);
                color = new Color(255, index, index);
            } else {
                color = Color.red;
            }
        }
        return color;
    }
}

