/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.core.io.FilesWithHeaderWriter;
import ambit2.core.io.ICompoundImageTools;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.formats.IResourceFormat;

public class PDFWriter
extends FilesWithHeaderWriter {
    protected Document pdfDoc = null;
    protected PdfWriter pdfWriter;
    protected PdfPTable table;
    protected ICompoundImageTools imageTools;
    protected Dimension cell = new Dimension(200, 200);

    public PDFWriter(OutputStream outputStream) throws CDKException {
        this(outputStream, null);
    }

    public PDFWriter(OutputStream outputStream, ICompoundImageTools iCompoundImageTools) throws CDKException {
        this.setWriter(outputStream);
        if (iCompoundImageTools == null) {
            try {
                Class<?> clazz = Class.forName("ambit2.rendering.CompoundImageTools");
                this.imageTools = (ICompoundImageTools)clazz.newInstance();
            }
            catch (Exception exception) {
                this.imageTools = null;
            }
        } else {
            this.imageTools = iCompoundImageTools;
        }
    }

    public void setWriter(Writer writer) throws CDKException {
        throw new CDKException("Not supported!");
    }

    public void setWriter(OutputStream outputStream) throws CDKException {
        this.pdfDoc = new Document(PageSize.A4, 80.0f, 50.0f, 30.0f, 65.0f);
        try {
            this.pdfWriter = PdfWriter.getInstance((Document)this.pdfDoc, (OutputStream)outputStream);
            this.pdfWriter.setViewerPreferences(96);
            this.pdfDoc.addCreationDate();
            this.pdfDoc.addCreator(((Object)((Object)this)).getClass().getName());
            this.pdfDoc.addKeywords("structures");
            this.pdfDoc.addTitle("structures");
            this.pdfDoc.addSubject("");
            this.pdfDoc.addAuthor("Toxtree");
            this.pdfDoc.open();
            this.table = new PdfPTable(new float[]{3.0f, 5.0f});
            this.table.setWidthPercentage(100.0f);
        }
        catch (Exception exception) {
            throw new CDKException(exception.getMessage());
        }
    }

    public void write(IChemObject iChemObject) throws CDKException {
        if (iChemObject instanceof IMoleculeSet) {
            this.writeSetOfMolecules((IMoleculeSet)iChemObject);
        } else if (iChemObject instanceof IMolecule) {
            this.writeMolecule((IMolecule)iChemObject);
        } else {
            throw new CDKException("Only supported is writing of ChemFile and Molecule objects.");
        }
    }

    public boolean accepts(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (IChemFile.class.equals(classArray[i])) {
                return true;
            }
            if (!IMoleculeSet.class.equals(classArray[i])) continue;
            return true;
        }
        return false;
    }

    public int getSupportedDataFeatures() {
        return 512;
    }

    public void close() throws IOException {
        try {
            this.pdfDoc.add((Element)this.table);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pdfDoc.close();
    }

    public IResourceFormat getFormat() {
        return null;
    }

    @Override
    protected void writeHeader() throws IOException {
        PdfPCell pdfPCell = new PdfPCell((Phrase)new Paragraph("Structure"));
        pdfPCell.setBackgroundColor(Color.white);
        this.table.addCell(pdfPCell);
        pdfPCell = new PdfPCell((Phrase)new Paragraph("Properties"));
        pdfPCell.setBackgroundColor(Color.white);
        this.table.addCell(pdfPCell);
    }

    public void writeSetOfMolecules(IMoleculeSet iMoleculeSet) {
        for (int i = 0; i < iMoleculeSet.getMoleculeCount(); ++i) {
            try {
                this.writeMolecule(iMoleculeSet.getMolecule(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeMolecule(IMolecule iMolecule) {
        try {
            StringBuffer stringBuffer;
            if (!this.writingStarted) {
                if (this.header == null) {
                    this.setHeader(iMolecule.getProperties());
                }
                this.writeHeader();
                this.writingStarted = true;
            }
            Paragraph paragraph = new Paragraph("");
            for (int i = 0; i < this.header.size(); ++i) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.header.get(i));
                stringBuffer.append(" = ");
                Object object = iMolecule.getProperty(this.header.get(i));
                if (i == this.smilesIndex && object == null) {
                    try {
                        object = "";
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Error while createSMILES\t", new Object[]{exception.getMessage()});
                        object = "";
                    }
                }
                if (object == null) continue;
                String string = object instanceof Number ? object.toString() : object.toString();
                stringBuffer.append(string);
                paragraph.add((Object)new Paragraph(stringBuffer.toString()));
            }
            BufferedImage bufferedImage = this.imageTools.getImage((IAtomContainer)iMolecule);
            bufferedImage.flush();
            stringBuffer = com.lowagie.text.Image.getInstance((Image)bufferedImage, (Color)Color.white);
            stringBuffer.setAlignment(0);
            stringBuffer.scalePercent(100.0f);
            PdfPCell pdfPCell = new PdfPCell();
            pdfPCell.setMinimumHeight(pdfPCell.height());
            pdfPCell.addElement((Element)stringBuffer);
            this.table.addCell(pdfPCell);
            pdfPCell = new PdfPCell((Phrase)paragraph);
            pdfPCell.setBackgroundColor(Color.white);
            this.table.addCell(pdfPCell);
        }
        catch (Exception exception) {
            logger.error((Object)"ERROR while writing Molecule: ", new Object[]{exception.getMessage()});
            logger.debug((Object)exception);
            exception.printStackTrace();
        }
    }
}

