/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.smiles;

import ambit2.base.external.CommandShell;
import ambit2.base.external.ShellException;
import ambit2.core.external.ShellSDFoutput;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IMolecule;

public class OpenBabelAbstractShell<X>
extends ShellSDFoutput<X> {
    private static final long serialVersionUID = -8439060274752318591L;
    public static final String OBABEL_EXE = "obabel";
    public static final String OBABEL_HOME = "OBABEL_HOME";
    protected boolean hydrogens = true;

    public boolean isHydrogens() {
        return this.hydrogens;
    }

    public void setHydrogens(boolean bl) {
        this.hydrogens = bl;
    }

    public OpenBabelAbstractShell() throws ShellException {
        this.prefix = "";
    }

    protected String getOBabelHome() {
        return System.getenv(OBABEL_HOME);
    }

    @Override
    protected void initialize() throws ShellException {
        super.initialize();
        String string = this.getOBabelHome();
        File file = new File(String.format("%s/%s", string, OBABEL_EXE));
        File file2 = new File(String.format("%s/%s.exe", string, OBABEL_EXE));
        if (!file.exists() && !file2.exists()) {
            throw new ShellException((CommandShell)this, String.format("%s does not exist! Have you set %s environment variable?", file.getAbsolutePath(), OBABEL_HOME));
        }
        this.addExecutable("Windows", file2.getAbsolutePath(), null);
        this.addExecutable("Windows Vista", file2.getAbsolutePath(), null);
        this.addExecutable("Windows 7", file2.getAbsolutePath(), null);
        this.addExecutable("FreeBSD", file.getAbsolutePath(), null);
        this.addExecutable("Linux", file.getAbsolutePath(), null);
        this.setInputFile(null);
        this.setOutputFile(this.getOutputFileName());
        this.setReadOutput(true);
    }

    protected String getOutputFileName() {
        return "obabel.sdf";
    }

    protected String getOutputOption() {
        return "-osdf";
    }

    protected IMolecule transform(X x) {
        return null;
    }

    public String toString() {
        return "OpenBabel";
    }

    protected String getPath(File file) {
        return String.format("%s", this.getHomeDir(null));
    }

    protected String getHomeDir(File file) {
        return String.format("%s%s.ambit2%sobabel", System.getProperty("user.home"), File.separator, File.separator);
    }

    protected synchronized List<String> prepareInput(String string, X x) throws ShellException {
        try {
            String string2 = this.getHomeDir(null);
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            String string3 = String.format("%s%s%s", string2, File.separator, this.getOutputFile());
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.hydrogens) {
                arrayList.add("-h");
            }
            arrayList.add(String.format("-:%s", x));
            arrayList.add(this.getOutputOption());
            arrayList.add(String.format("-O%s", string3));
            return arrayList;
        }
        catch (Exception exception) {
            throw new ShellException((CommandShell)this, (Throwable)exception);
        }
    }
}

