/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;

public class IteratingChemObjectReaderWrapper
extends DefaultIteratingChemObjectReader {
    protected IChemObject chemObject = null;
    protected IResourceFormat format = null;
    protected IMoleculeSet atomContainers = null;
    protected int record = -1;

    public IteratingChemObjectReaderWrapper(DefaultChemObjectReader defaultChemObjectReader) {
        try {
            this.format = defaultChemObjectReader.getFormat();
            this.chemObject = defaultChemObjectReader.read((IChemObject)new ChemFile());
            if (this.chemObject instanceof IChemFile) {
                IChemSequence iChemSequence;
                int n = ((IChemFile)this.chemObject).getChemSequenceCount();
                if (n > 0 && (n = (iChemSequence = ((IChemFile)this.chemObject).getChemSequence(0)).getChemModelCount()) > 0) {
                    IChemModel iChemModel = iChemSequence.getChemModel(0);
                    this.atomContainers = iChemModel.getMoleculeSet();
                }
            } else if (this.chemObject instanceof IMoleculeSet) {
                this.atomContainers = (IMoleculeSet)this.chemObject;
            }
        }
        catch (CDKException cDKException) {
            cDKException.printStackTrace();
            this.chemObject = null;
            this.format = null;
        }
    }

    public void setReader(InputStream inputStream) throws CDKException {
        throw new CDKException("Not implemented");
    }

    public void setReader(Reader reader) throws CDKException {
        throw new CDKException("Not implemented");
    }

    public IResourceFormat getFormat() {
        return this.format;
    }

    public void close() throws IOException {
        this.atomContainers = null;
    }

    public boolean hasNext() {
        if (this.atomContainers == null) {
            return false;
        }
        ++this.record;
        return this.record < this.atomContainers.getAtomContainerCount();
    }

    public Object next() {
        if (this.atomContainers == null) {
            return null;
        }
        return this.atomContainers.getAtomContainer(this.record);
    }

    public String toString() {
        return "Reads compounds from " + this.getFormat() + " file";
    }
}

