/*
 * Decompiled with CFR 0.152.
 */
package padeldescriptor;

import com.l2fprod.common.beans.BaseBeanInfo;
import com.l2fprod.common.beans.editor.ComboBoxPropertyEditor;
import com.l2fprod.common.beans.editor.FilePropertyEditor;
import com.l2fprod.common.demo.BeanBinder;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.propertysheet.PropertySheetTable;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.UserPreferences;
import com.l2fprod.common.util.ResourceManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ListResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import libpadel.PaDELDirectoryPropertyEditor;
import libpadel.PaDELFilePropertyEditor;
import libpadel.PaDELLoadFilePropertyEditor;

public class PaDELDescriptorPropertySheetPage1
extends JPanel {
    public final Bean data = new Bean();
    public final PropertySheetPanel sheet = new PropertySheetPanel();
    public static final String FORCEFIELD_NO = "No";
    public static final String FORCEFIELD_MM2 = "Yes (use MM2 forcefield)";
    public static final String FORCEFIELD_MMFF94 = "Yes (use MMFF94 forcefield)";

    public PaDELDescriptorPropertySheetPage1() {
        this.setLayout((LayoutManager)LookAndFeelTweaks.createVerticalPercentLayout());
        this.data.setDirectory("");
        this.data.setDescriptorFile("");
        this.data.setRemoveSalt(true);
        this.data.setDetectAromaticity(true);
        this.data.setStandardizeTautomers(false);
        this.data.setTautomerFile("");
        this.data.setStandardizeNitro(true);
        this.data.setRetain3D(false);
        this.data.setConvert3D(FORCEFIELD_NO);
        this.data.setCompute2D(true);
        this.data.setCompute3D(false);
        this.data.setComputeFingerprints(false);
        this.data.setMaxThreads(-1);
        this.data.setMaxJobsWaiting(-1);
        this.data.setMaxRunTime(-1L);
        this.data.setLog(true);
        this.data.setMaxCpdPerFile(0);
        this.data.setRetainOrder(true);
        this.data.setUseFilenameAsMolName(false);
        this.sheet.setMode(1);
        this.sheet.setDescriptionVisible(true);
        this.sheet.setSortingCategories(false);
        this.sheet.setSortingProperties(false);
        this.sheet.setRestoreToggleStates(true);
        PropertySheetTable propertySheetTable = this.sheet.getTable();
        propertySheetTable.setAutoResizeMode(3);
        propertySheetTable.getColumnModel().getColumn(0).setMinWidth(10);
        propertySheetTable.getColumnModel().getColumn(0).setMaxWidth(500);
        propertySheetTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.add((Component)this.sheet, "*");
        new BeanBinder((Object)this.data, this.sheet);
        PropertySheetTableModel propertySheetTableModel = propertySheetTable.getSheetModel();
        for (int i = 0; i < propertySheetTableModel.getRowCount(); ++i) {
            PropertySheetTableModel.Item item = propertySheetTableModel.getPropertySheetElement(i);
            if (!item.getName().equals("Advanced")) continue;
            item.toggle();
        }
    }

    public static class BeanRB
    extends ListResourceBundle {
        @Override
        protected Object[][] getContents() {
            return new Object[][]{{"directory", "Molecules directory/file"}, {"directory.shortDescription", "Directory containing structural files or a structural file."}, {"descriptorFile", "Descriptor output file"}, {"descriptorFile.shortDescription", "File to save calculated descriptors."}, {"removeSalt", "Remove salt"}, {"removeSalt.shortDescription", "Remove salt from a molecule.<br>This option assumes that the largest fragment is the desired molecule."}, {"detectAromaticity", "Detect aromaticity"}, {"detectAromaticity.shortDescription", "Remove existing aromaticity information and automatically detect aromaticity in the molecule before calculation of descriptors."}, {"standardizeTautomers", "Standardize tautomers"}, {"standardizeTautomers.shortDescription", "Standardize tautomers."}, {"tautomerFile", "SMIRKS tautomers file"}, {"tautomerFile.shortDescription", "File containing SMIRKS tautomers."}, {"standardizeNitro", "Standardize nitro groups"}, {"standardizeNitro.shortDescription", "Standardize nitro groups to N(:O):O."}, {"retain3D", "Retain 3D coordinates"}, {"retain3D.shortDescription", "Retain 3D coordinates when standardizing structure. However, this may prevent some structures from being standardized."}, {"convert3D", "Convert to 3D"}, {"convert3D.shortDescription", "Convert molecule to 3D."}, {"compute2D", "1D & 2D"}, {"compute2D.shortDescription", "Calculate 1D and 2D descriptors."}, {"compute3D", "3D"}, {"compute3D.shortDescription", "Calculate 3D descriptors."}, {"computeFingerprints", "Fingerprints"}, {"computeFingerprints.shortDescription", "Calculate fingerprints."}, {"log", "Log"}, {"log.shortDescription", "Create a log file.<br>Name of log file is the name of the descriptors file with a .log extension."}, {"maxThreads", "Max. threads"}, {"maxThreads.shortDescription", "Maximum number of threads to use.<br>Use -1 to use as many threads as the number of cpu cores."}, {"maxJobsWaiting", "Max. waiting jobs"}, {"maxJobsWaiting.shortDescription", "Maximum number of jobs to store in queue for worker threads to process<br>Use -1 to set it to 50*Max threads."}, {"maxRunTime", "Max. running time per molecule"}, {"maxRunTime.shortDescription", "Maximum running time per molecule (in milliseconds)<br>Use -1 for unlimited."}, {"maxCpdPerFile", "Max. compounds per file"}, {"maxCpdPerFile.shortDescription", "Maximum number of compounds to be stored in each descriptor file. Use 0 for unlimited."}, {"retainOrder", "Retain molecules order"}, {"retainOrder.shortDescription", "Retain order of molecules in structural files for descriptor file. This may lead to large memory use if descriptor calculations are stuck at one molecule as the others will not be written to file and cleared from memory."}, {"useFilenameAsMolName", "Use filename as molecule name"}, {"useFilenameAsMolName.shortDescription", "Use filename (minus the extension) as molecule name."}};
        }
    }

    public static class ConvertTo3DEditor
    extends ComboBoxPropertyEditor {
        public ConvertTo3DEditor() {
            this.setAvailableValues(new String[]{PaDELDescriptorPropertySheetPage1.FORCEFIELD_NO, PaDELDescriptorPropertySheetPage1.FORCEFIELD_MM2, PaDELDescriptorPropertySheetPage1.FORCEFIELD_MMFF94});
        }
    }

    public static class DescriptorFileEditor
    extends PaDELFilePropertyEditor {
        protected void selectFile() {
            ResourceManager resourceManager = ResourceManager.all(FilePropertyEditor.class);
            JFileChooser jFileChooser = UserPreferences.getDefaultFileChooser();
            jFileChooser.setDialogTitle(resourceManager.getString("FilePropertyEditor.dialogTitle"));
            jFileChooser.setApproveButtonText(resourceManager.getString("FilePropertyEditor.approveButtonText"));
            jFileChooser.setApproveButtonMnemonic(resourceManager.getChar("FilePropertyEditor.approveButtonMnemonic"));
            String string = (String)this.getValue();
            File file = new File(string);
            if (file != null) {
                jFileChooser.setCurrentDirectory(file);
            }
            this.customizeFileChooser(jFileChooser);
            if (0 == jFileChooser.showSaveDialog(this.editor)) {
                File file2;
                String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                if (!string2.endsWith(".csv")) {
                    string2 = string2 + ".csv";
                }
                if ((file2 = new File(string2)).exists()) {
                    int n = JOptionPane.showConfirmDialog(null, "File exists. Overwrite file?", "File exists", 0, 2);
                    if (n == 0) {
                        String string3 = string2;
                        this.textfield.setText(string3);
                        this.firePropertyChange(string, string3);
                    }
                } else {
                    String string4 = string2;
                    this.textfield.setText(string4);
                    this.firePropertyChange(string, string4);
                }
            }
        }

        protected void customizeFileChooser(JFileChooser jFileChooser) {
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("CSV file", "csv"));
            jFileChooser.setAcceptAllFileFilterUsed(false);
        }
    }

    public static class BeanBeanInfo
    extends BaseBeanInfo {
        public BeanBeanInfo() {
            super(Bean.class);
            this.addProperty("directory").setPropertyEditorClass(PaDELDirectoryPropertyEditor.class);
            this.addProperty("descriptorFile").setPropertyEditorClass(DescriptorFileEditor.class);
            this.addProperty("compute2D").setCategory("Descriptors");
            this.addProperty("compute3D").setCategory("Descriptors");
            this.addProperty("computeFingerprints").setCategory("Descriptors");
            this.addProperty("removeSalt").setCategory("Standardize");
            this.addProperty("detectAromaticity").setCategory("Standardize");
            this.addProperty("standardizeTautomers").setCategory("Standardize");
            this.addProperty("tautomerFile").setCategory("Standardize").setPropertyEditorClass(PaDELLoadFilePropertyEditor.class);
            this.addProperty("standardizeNitro").setCategory("Standardize");
            this.addProperty("retain3D").setCategory("Standardize");
            this.addProperty("convert3D").setCategory("Standardize").setPropertyEditorClass(ConvertTo3DEditor.class);
            this.addProperty("log").setCategory("Advanced");
            this.addProperty("maxThreads").setCategory("Advanced");
            this.addProperty("maxJobsWaiting").setCategory("Advanced");
            this.addProperty("maxRunTime").setCategory("Advanced");
            this.addProperty("maxCpdPerFile").setCategory("Advanced");
            this.addProperty("retainOrder").setCategory("Advanced");
            this.addProperty("useFilenameAsMolName").setCategory("Advanced");
        }
    }

    public static class Bean {
        private String directory;
        private String descriptorFile;
        private boolean removeSalt;
        private boolean detectAromaticity;
        private boolean standardizeTautomers;
        private String tautomerFile;
        private boolean standardizeNitro;
        private boolean retain3D;
        private String convert3D;
        private boolean compute2D;
        private boolean compute3D;
        private boolean computeFingerprints;
        private boolean log;
        private int maxThreads;
        private int maxJobsWaiting;
        private long maxRunTime;
        private int maxCpdPerFile;
        private boolean retainOrder;
        private boolean useFilenameAsMolName;

        public boolean isCompute2D() {
            return this.compute2D;
        }

        public void setCompute2D(boolean bl) {
            this.compute2D = bl;
        }

        public boolean isCompute3D() {
            return this.compute3D;
        }

        public void setCompute3D(boolean bl) {
            this.compute3D = bl;
        }

        public boolean isComputeFingerprints() {
            return this.computeFingerprints;
        }

        public void setComputeFingerprints(boolean bl) {
            this.computeFingerprints = bl;
        }

        public String getConvert3D() {
            return this.convert3D;
        }

        public void setConvert3D(String string) {
            this.convert3D = string;
        }

        public String getDescriptorFile() {
            return this.descriptorFile;
        }

        public void setDescriptorFile(String string) {
            this.descriptorFile = string;
        }

        public boolean isDetectAromaticity() {
            return this.detectAromaticity;
        }

        public void setDetectAromaticity(boolean bl) {
            this.detectAromaticity = bl;
        }

        public String getDirectory() {
            return this.directory;
        }

        public void setDirectory(String string) {
            this.directory = string;
        }

        public boolean isRemoveSalt() {
            return this.removeSalt;
        }

        public void setRemoveSalt(boolean bl) {
            this.removeSalt = bl;
        }

        public boolean isRetain3D() {
            return this.retain3D;
        }

        public void setRetain3D(boolean bl) {
            this.retain3D = bl;
        }

        public boolean isStandardizeNitro() {
            return this.standardizeNitro;
        }

        public void setStandardizeNitro(boolean bl) {
            this.standardizeNitro = bl;
        }

        public boolean isStandardizeTautomers() {
            return this.standardizeTautomers;
        }

        public void setStandardizeTautomers(boolean bl) {
            this.standardizeTautomers = bl;
        }

        public String getTautomerFile() {
            return this.tautomerFile;
        }

        public void setTautomerFile(String string) {
            this.tautomerFile = string;
        }

        public boolean isLog() {
            return this.log;
        }

        public void setLog(boolean bl) {
            this.log = bl;
        }

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public void setMaxThreads(int n) {
            this.maxThreads = n;
        }

        public int getMaxJobsWaiting() {
            return this.maxJobsWaiting;
        }

        public void setMaxJobsWaiting(int n) {
            this.maxJobsWaiting = n;
        }

        public long getMaxRunTime() {
            return this.maxRunTime;
        }

        public void setMaxRunTime(long l) {
            this.maxRunTime = l;
        }

        public int getMaxCpdPerFile() {
            return this.maxCpdPerFile;
        }

        public void setMaxCpdPerFile(int n) {
            this.maxCpdPerFile = n;
        }

        public boolean isRetainOrder() {
            return this.retainOrder;
        }

        public void setRetainOrder(boolean bl) {
            this.retainOrder = bl;
        }

        public boolean isUseFilenameAsMolName() {
            return this.useFilenameAsMolName;
        }

        public void setUseFilenameAsMolName(boolean bl) {
            this.useFilenameAsMolName = bl;
        }

        public String toString() {
            return "[directory=" + this.getDirectory() + ",descriptorFile=" + this.getDescriptorFile() + ",removeSalt=" + this.isRemoveSalt() + ",detectAromaticity=" + this.isDetectAromaticity() + ",standardizeTautomers=" + this.isStandardizeTautomers() + ",tautomerFile=" + this.getTautomerFile() + ",standardizeNitro=" + this.isStandardizeNitro() + ",retain3D=" + this.isRetain3D() + ",convert3D=" + this.getConvert3D() + ",compute2D=" + this.isCompute2D() + ",compute3D=" + this.isCompute3D() + ",computeFingerprints=" + this.isComputeFingerprints() + ",log=" + this.isLog() + ",maxThreads=" + this.getMaxThreads() + ",maxJobsWaiting=" + this.getMaxJobsWaiting() + ",maxRunTime=" + this.getMaxRunTime() + ",maxCpdPerFile=" + this.getMaxCpdPerFile() + ",retainOrder=" + this.isRetainOrder() + ",useFilenameAsMolName=" + this.isUseFilenameAsMolName() + "]";
        }
    }
}

