/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.exceptions.AmbitIOException;
import ambit2.base.interfaces.IInputOutputState;
import com.jgoodies.binding.beans.Model;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.openscience.cdk.io.formats.IChemFormat;

public class FileState
extends Model
implements IInputOutputState {
    protected static transient String MSG_FILEDONOTEXISTS = "File do not exists!\t";
    protected static transient String MSG_CANTCREATEFILE = "Can't create file!\t";
    protected static transient String MSG_OPEN = "Opening input file\t";
    protected static transient String MSG_UNSUPPORTEDFORMAT = "UNSUPPORTED FORMAT\t";
    protected static transient String MSG_ERRORSAVE = "Error when writing file\t";
    protected String responseType = "text/plain";
    protected String[] supportedExtensions = new String[]{"*.*"};
    protected String[] extensionDescriptions = new String[]{"All files"};
    private static final long serialVersionUID = -9098389880881547516L;
    protected String filename = null;
    protected long length = 0L;
    protected long lastModified = 0L;
    protected int hashCode = 0;
    protected transient File file = null;
    protected long offset = 0L;
    protected long currentRecord = 0L;
    protected IChemFormat fileFormat;

    public IChemFormat getFileFormat() {
        return this.fileFormat;
    }

    public FileState() {
    }

    public FileState(String string) {
        this(new File(string));
    }

    public FileState(File file) {
        this();
        this.setFile(file);
    }

    public boolean equals(Object object) {
        FileState fileState = (FileState)((Object)object);
        return this.filename.equals(fileState.getFilename()) && this.length == fileState.length && this.lastModified == fileState.lastModified && this.hashCode == fileState.hashCode && this.currentRecord == fileState.currentRecord && this.offset == fileState.offset;
    }

    public synchronized String getFilename() {
        return this.filename;
    }

    public synchronized void setFilename(String string) {
        this.filename = string;
    }

    public synchronized int getHashCode() {
        return this.hashCode;
    }

    public synchronized void setHashCode(int n) {
        this.hashCode = n;
    }

    public synchronized long getLastModified() {
        return this.lastModified;
    }

    public synchronized void setLastModified(long l) {
        this.lastModified = l;
    }

    public synchronized long getLength() {
        return this.length;
    }

    public synchronized void setLength(long l) {
        this.length = l;
    }

    public synchronized File getFile() {
        return this.file;
    }

    public synchronized void setFile(File file) {
        this.setFile(file, null);
    }

    public synchronized void setFile(File file, IChemFormat iChemFormat) {
        this.fileFormat = iChemFormat;
        this.file = file;
        this.setFilename(file.getAbsolutePath());
        this.length = file.length();
        this.lastModified = file.lastModified();
        this.hashCode = file.hashCode();
        this.file = file;
        this.currentRecord = 0L;
        this.offset = 0L;
    }

    public long getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentRecord(long l) {
        this.currentRecord = l;
    }

    public synchronized long getOffset() {
        return this.offset;
    }

    public synchronized void setOffset(long l) {
        this.offset = l;
    }

    public boolean match() throws AmbitIOException {
        return this.match(this.createFile());
    }

    public boolean match(File file) {
        return this.filename.equals(file.getAbsolutePath()) && this.length == file.length() && this.lastModified == file.lastModified();
    }

    public File createFile() throws AmbitIOException {
        try {
            return new File(this.filename);
        }
        catch (Exception exception) {
            throw new AmbitIOException((Throwable)exception);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" [");
        stringBuffer.append(this.currentRecord + 1L);
        stringBuffer.append(" ] ");
        stringBuffer.append(this.filename);
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(-9098389880881547516L);
        objectOutputStream.writeObject(this.filename);
        objectOutputStream.writeLong(this.length);
        objectOutputStream.writeLong(this.lastModified);
        objectOutputStream.writeInt(this.hashCode);
        objectOutputStream.writeLong(this.offset);
        objectOutputStream.writeLong(this.currentRecord);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream.readLong() != -9098389880881547516L) {
            throw new ClassNotFoundException();
        }
        this.filename = objectInputStream.readObject().toString();
        this.length = objectInputStream.readLong();
        this.lastModified = objectInputStream.readLong();
        this.hashCode = objectInputStream.readInt();
        this.offset = objectInputStream.readLong();
        this.currentRecord = objectInputStream.readLong();
        this.file = new File(this.filename);
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String string) {
        this.responseType = string;
    }

    public String[] getSupportedExtensions() {
        return this.supportedExtensions;
    }

    public String[] getSupportedExtDescriptions() {
        return this.extensionDescriptions;
    }

    public void setSupportedExtensions(String[] stringArray) {
        this.supportedExtensions = stringArray;
    }

    public void setSupportedExtDescriptions(String[] stringArray) {
        this.extensionDescriptions = stringArray;
    }
}

