/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.XYZFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.FormatFactoryTest")
public class FormatFactory {
    private static final String IO_FORMATS_LIST = "io-formats.set";
    private int headerLength;
    private static List<IChemFormatMatcher> formats = null;

    public FormatFactory() {
        this(65536);
    }

    public FormatFactory(int headerLength) {
        this.headerLength = headerLength;
        this.loadFormats();
    }

    private void loadFormats() {
        if (formats == null) {
            formats = new ArrayList<IChemFormatMatcher>();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(IO_FORMATS_LIST)));
                int formatCount = 0;
                while (reader.ready()) {
                    String formatName = reader.readLine();
                    ++formatCount;
                    try {
                        Class<?> formatClass = this.getClass().getClassLoader().loadClass(formatName);
                        Method getinstanceMethod = formatClass.getMethod("getInstance", new Class[0]);
                        IChemFormatMatcher format = (IChemFormatMatcher)getinstanceMethod.invoke(null, new Object[0]);
                        formats.add(format);
                    }
                    catch (ClassNotFoundException exception) {
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void registerFormat(IChemFormatMatcher format) {
        formats.add(format);
    }

    public List<IChemFormatMatcher> getFormats() {
        return formats;
    }

    public IChemFormat guessFormat(Reader input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        char[] header = new char[this.headerLength];
        if (!input.markSupported()) {
            throw new IllegalArgumentException("input must support mark");
        }
        input.mark(this.headerLength);
        input.read(header, 0, this.headerLength);
        input.reset();
        BufferedReader buffer = new BufferedReader(new CharArrayReader(header));
        String line = null;
        int lineNumber = 1;
        while ((line = buffer.readLine()) != null) {
            for (int i = 0; i < formats.size(); ++i) {
                IChemFormatMatcher cfMatcher = formats.get(i);
                if (!cfMatcher.matches(lineNumber, line)) continue;
                return cfMatcher;
            }
            ++lineNumber;
        }
        buffer = new BufferedReader(new CharArrayReader(header));
        line = buffer.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line.trim());
        try {
            int tokenCount = tokenizer.countTokens();
            if (tokenCount == 1) {
                Integer.parseInt(tokenizer.nextToken());
                return (IChemFormat)XYZFormat.getInstance();
            }
            if (tokenCount == 2) {
                Integer.parseInt(tokenizer.nextToken());
                if ("Bohr".equalsIgnoreCase(tokenizer.nextToken())) {
                    return (IChemFormat)XYZFormat.getInstance();
                }
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return null;
    }

    @TestMethod(value="testGuessFormat")
    public IChemFormat guessFormat(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        byte[] header = new byte[this.headerLength];
        if (!input.markSupported()) {
            throw new IllegalArgumentException("input must support mark");
        }
        input.mark(this.headerLength);
        input.read(header, 0, this.headerLength);
        input.reset();
        BufferedReader buffer = new BufferedReader(new StringReader(new String(header)));
        String line = null;
        int lineNumber = 1;
        while ((line = buffer.readLine()) != null) {
            for (int i = 0; i < formats.size(); ++i) {
                IChemFormatMatcher cfMatcher = formats.get(i);
                if (!cfMatcher.matches(lineNumber, line)) continue;
                return cfMatcher;
            }
            ++lineNumber;
        }
        buffer = new BufferedReader(new StringReader(new String(header)));
        line = buffer.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line.trim());
        try {
            int tokenCount = tokenizer.countTokens();
            if (tokenCount == 1) {
                Integer.parseInt(tokenizer.nextToken());
                return (IChemFormat)XYZFormat.getInstance();
            }
            if (tokenCount == 2) {
                Integer.parseInt(tokenizer.nextToken());
                if ("Bohr".equalsIgnoreCase(tokenizer.nextToken())) {
                    return (IChemFormat)XYZFormat.getInstance();
                }
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return null;
    }
}

