/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelReader;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMakerImpl
implements ModelMaker {
    protected GraphMaker maker;
    protected Model description;

    public ModelMakerImpl(GraphMaker maker) {
        this.maker = maker;
    }

    @Override
    public GraphMaker getGraphMaker() {
        return this.maker;
    }

    @Override
    public void close() {
        this.maker.close();
    }

    public Model openModel() {
        return new ModelCom(this.maker.openGraph());
    }

    protected Model makeModel(Graph g) {
        return new ModelCom(g);
    }

    @Override
    public Model openModelIfPresent(String name) {
        return this.maker.hasGraph(name) ? this.openModel(name) : null;
    }

    @Override
    public Model openModel(String name, boolean strict) {
        return this.makeModel(this.maker.openGraph(name, strict));
    }

    @Override
    public Model openModel(String name) {
        return this.openModel(name, false);
    }

    @Override
    public Model createModel(String name, boolean strict) {
        return this.makeModel(this.maker.createGraph(name, strict));
    }

    @Override
    public Model createModel(String name) {
        return this.createModel(name, false);
    }

    public Model createModelOver(String name) {
        return this.createModel(name);
    }

    @Override
    public Model createFreshModel() {
        return this.makeModel(this.maker.createGraph());
    }

    @Override
    public Model createDefaultModel() {
        return this.makeModel(this.maker.getGraph());
    }

    @Override
    public void removeModel(String name) {
        this.maker.removeGraph(name);
    }

    @Override
    public boolean hasModel(String name) {
        return this.maker.hasGraph(name);
    }

    @Override
    public ExtendedIterator<String> listModels() {
        return this.maker.listGraphs();
    }

    @Override
    public Model getModel(String URL2) {
        return this.hasModel(URL2) ? this.openModel(URL2) : null;
    }

    @Override
    public Model getModel(String URL2, ModelReader loadIfAbsent) {
        Model already = this.getModel(URL2);
        return already == null ? loadIfAbsent.readModel(this.createModel(URL2), URL2) : already;
    }
}

