/*
 * Decompiled with CFR 0.152.
 */
package signature.display;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import signature.ColoredTree;
import signature.display.DisplayableColoredTree;

public class ColoredTreePanel
extends JPanel {
    public int maxDepth;
    private DisplayableColoredTree displayTree;
    private boolean drawKey;

    public ColoredTreePanel(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.drawKey = false;
        this.displayTree = new DisplayableColoredTree(width, height);
    }

    public ColoredTreePanel(ColoredTree tree, int width, int height) {
        this.displayTree = new DisplayableColoredTree(tree, width, height);
        this.drawKey = false;
        this.setPreferredSize(new Dimension(width, height));
    }

    public void setDrawKey(boolean drawKey) {
        this.drawKey = drawKey;
    }

    public void setTree(ColoredTree tree) {
        System.out.println("setting tree " + tree);
        if (this.displayTree == null) {
            this.displayTree = new DisplayableColoredTree(this.getWidth(), this.getHeight());
        } else {
            this.displayTree.makeFromColoredTree(tree);
        }
        this.displayTree.setDrawKey(this.drawKey);
        this.maxDepth = tree.getHeight();
    }

    public void paint(Graphics g) {
        if (this.displayTree != null) {
            this.displayTree.paint(g);
        }
    }

    public void clear() {
        this.displayTree = null;
    }
}

