/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractAtomParity;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLMolecule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLAtomParity
extends AbstractAtomParity {
    public static final String NS = "cml:atomParity";
    public static final int TWODIM = 1;
    public static final int THREEDIM = 2;
    public static final double MINRAD = 0.15;
    public static final double EPSILON = 1.0E-4;
    public static final double PLANARITYLIMIT = 0.4;
    public double minChiralDeterminant;

    public CMLAtomParity() {
    }

    public CMLAtomParity(CMLAtomParity old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLAtomParity(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLAtomParity();
    }

    public void setAtomRefs4(CMLAtom[] atoms4) throws RuntimeException {
        if (atoms4 == null || atoms4.length != 4) {
            throw new RuntimeException("Must give 4 atoms");
        }
        this.setAtomRefs4(new String[]{atoms4[0].getId(), atoms4[1].getId(), atoms4[2].getId(), atoms4[3].getId()});
    }

    public void rearrangeAtomRefs4(String[] newAtomsRefs4) throws RuntimeException {
        String[] oldAtomsRefs4 = this.getAtomRefs4();
        if (newAtomsRefs4.length != 4) {
            throw new RuntimeException("atomRefs4 must have 4 atoms");
        }
        int parity = 0;
        for (int i = 0; i < 4; ++i) {
            boolean found = false;
            for (int j = i; j < 4; ++j) {
                if (!newAtomsRefs4[i].equals(oldAtomsRefs4[j])) continue;
                if (i != j) {
                    String temp = oldAtomsRefs4[i];
                    oldAtomsRefs4[i] = oldAtomsRefs4[j];
                    oldAtomsRefs4[j] = temp;
                    parity = 1 - parity;
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("newAtomRefs4 is not a rearrangement of the original set!");
        }
        this.setXMLContent(this.getXMLContent() * (double)(1 - 2 * parity));
    }

    public int getIntegerValue() {
        int i = 0;
        double value = this.getXMLContent();
        if (Math.abs(value) > 0.15) {
            i = value < 0.0 ? -1 : 1;
        }
        return i;
    }

    public CMLAtom[] getAtomRefs4(CMLMolecule molecule) {
        String[] atomIds = this.getAtomRefs4();
        CMLAtom[] atoms = null;
        if (atomIds != null && atomIds.length == 4) {
            atoms = new CMLAtom[4];
            for (int i = 0; i < 4; ++i) {
                atoms[i] = molecule.getAtomById(atomIds[i]);
            }
        }
        return atoms;
    }

    public static String[] createAtomRefs4(List<CMLAtom> atoms) {
        if (atoms == null || atoms.size() != 4) {
            throw new RuntimeException("Bad atom list argument.");
        }
        String[] atomRefs4 = new String[4];
        int i = 0;
        for (CMLAtom atom : atoms) {
            atomRefs4[i++] = atom.getId();
        }
        return atomRefs4;
    }

    public boolean isZero() {
        double value = this.getXMLContent();
        return Math.abs(value) < 0.15;
    }
}

