/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers.smarts;

import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;

public class HydrogenAtom
extends SMARTSAtom {
    private IAtomContainer atomContainer;

    public boolean matches(IAtom atom) {
        if (!atom.getSymbol().equals("H")) {
            return false;
        }
        if (atom.getFormalCharge() == 1) {
            return true;
        }
        List<IAtom> list = this.atomContainer.getConnectedAtomsList(atom);
        for (IAtom connAtom : list) {
            if (!connAtom.getSymbol().equals("H")) continue;
            return true;
        }
        if (atom.getFormalNeighbourCount() > 1) {
            return true;
        }
        return atom.getMassNumber() != null ? this.getMassNumber().intValue() == atom.getMassNumber().intValue() : this.getMassNumber() == 1;
    }

    public IAtomContainer getAtomContainer() {
        return this.atomContainer;
    }

    public void setAtomContainer(IAtomContainer atomContainer) {
        this.atomContainer = atomContainer;
    }
}

