/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.ReificationStatementMask;
import com.hp.hpl.jena.graph.Node;

class ReificationCache {
    protected Node stmtURI;
    protected ReificationStatementMask mask;
    protected int tripleCount;

    ReificationCache(Node s, ReificationStatementMask m, int cnt) {
        this.stmtURI = s;
        this.mask = m;
        this.tripleCount = cnt;
    }

    public ReificationStatementMask getStmtMask() {
        return this.mask;
    }

    public int getCnt() {
        return this.tripleCount;
    }

    public Node getStmtURI() {
        return this.stmtURI;
    }

    public void setMask(ReificationStatementMask m) {
        this.mask = m;
    }

    public void setCount(int count) {
        this.tripleCount = count;
    }

    public void incCount(int count) {
        ++this.tripleCount;
    }

    public void decCount(int count) {
        --this.tripleCount;
    }

    public boolean canMerge(ReificationStatementMask fragMask) {
        return !this.mask.hasIntersect(fragMask);
    }

    public boolean canUpdate(ReificationStatementMask fragMask) {
        return this.canMerge(fragMask) && this.tripleCount == 1;
    }

    public void update(ReificationStatementMask fragMask) {
        this.mask.setMerge(fragMask);
        if (this.isStmt()) {
            this.mask.setIsStmt();
        }
    }

    private boolean isStmt() {
        return this.mask.hasSPOT() && this.tripleCount == 1;
    }
}

