/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.smarts.SmartsFlags;
import ambit2.smarts.SmartsToChemObject;
import java.util.Vector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;

public class SMIRKSReaction {
    public String reactantsSmarts;
    public String agentsSmarts;
    public String productsSmarts;
    public SmartsFlags reactantFlags = new SmartsFlags();
    public SmartsFlags agentFlags = new SmartsFlags();
    public SmartsFlags productFlags = new SmartsFlags();
    QueryAtomContainer reactant = new QueryAtomContainer();
    QueryAtomContainer agent = new QueryAtomContainer();
    QueryAtomContainer product = new QueryAtomContainer();
    public Vector<QueryAtomContainer> reactants = new Vector();
    public Vector<QueryAtomContainer> agents = new Vector();
    public Vector<QueryAtomContainer> products = new Vector();
    public Vector<Integer> reactantCLG = new Vector();
    public Vector<Integer> agentsCLG = new Vector();
    public Vector<Integer> productsCLG = new Vector();
    public Vector<String> mapErrors = new Vector();
    Vector<Integer> reactantMapIndex = new Vector();
    Vector<Integer> reactantFragAtomNum = new Vector();
    Vector<Integer> reactantAtomNum = new Vector();
    Vector<Integer> reactantFragmentNum = new Vector();
    Vector<Integer> reactantNotMappedAt = new Vector();
    Vector<Integer> productMapIndex = new Vector();
    Vector<Integer> productFragAtomNum = new Vector();
    Vector<Integer> productAtomNum = new Vector();
    Vector<Integer> productFragmentNum = new Vector();
    Vector<Integer> productNotMappedAt = new Vector();
    Vector<Integer> reactantAtCharge = new Vector();
    Vector<Integer> productAtCharge = new Vector();
    Vector<Integer> reactAt1 = new Vector();
    Vector<Integer> reactAt2 = new Vector();
    Vector<IBond.Order> reactBo = new Vector();
    Vector<Integer> prodAt1 = new Vector();
    Vector<Integer> prodAt2 = new Vector();
    Vector<IBond.Order> prodBo = new Vector();
    protected IChemObjectBuilder builder;

    public SMIRKSReaction(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    public void checkMappings() {
        int index;
        int i;
        for (i = 0; i < this.reactants.size(); ++i) {
            this.registerMappings("Reactant", this.reactant, this.reactants.get(i), i, this.reactantMapIndex, this.reactantNotMappedAt, this.reactantFragAtomNum, this.reactantAtomNum, this.reactantFragmentNum);
        }
        for (i = 0; i < this.products.size(); ++i) {
            this.registerMappings("Product", this.product, this.products.get(i), i, this.productMapIndex, this.productNotMappedAt, this.productFragAtomNum, this.productAtomNum, this.productFragmentNum);
        }
        for (i = 0; i < this.reactantMapIndex.size(); ++i) {
            index = this.getIntegerObjectIndex(this.productMapIndex, this.reactantMapIndex.get(i));
            if (index != -1) continue;
            this.mapErrors.add("Reactant Map Index " + this.reactantMapIndex.get(i) + " is not valid product map index!");
        }
        for (i = 0; i < this.productMapIndex.size(); ++i) {
            index = this.getIntegerObjectIndex(this.reactantMapIndex, this.productMapIndex.get(i));
            if (index != -1) continue;
            this.mapErrors.add("Product Map Index " + this.productMapIndex.get(i) + " is not valid reactant map index!");
        }
        SmartsToChemObject stco = new SmartsToChemObject(this.builder);
        for (int i2 = 0; i2 < this.reactantFragAtomNum.size(); ++i2) {
            int rAtNum = this.reactantFragAtomNum.get(i2);
            int rNum = this.reactantFragmentNum.get(i2);
            Integer rMapInd = this.reactantMapIndex.get(i2);
            IAtom ra = this.reactants.get(rNum).getAtom(rAtNum);
            int rGlobAtNum = this.reactantAtomNum.get(i2);
            IAtom glob_ra = this.reactant.getAtom(rGlobAtNum);
            int pIndex = this.getIntegerObjectIndex(this.productMapIndex, rMapInd);
            int pAtNum = this.productFragAtomNum.get(pIndex);
            int pNum = this.productFragmentNum.get(pIndex);
            IAtom pa = this.products.get(pNum).getAtom(pAtNum);
            int pGlobAtNum = this.productAtomNum.get(pIndex);
            IAtom glob_pa = this.product.getAtom(pGlobAtNum);
            if (glob_ra != ra) {
                this.mapErrors.add("Critical Error: Inconsistency between global and gragment atom treatment.");
            }
            if (glob_pa != pa) {
                this.mapErrors.add("Critical Error: Inconsistency between global and gragment atom treatment.");
            }
            IAtom ra1 = stco.toAtom(ra);
            IAtom pa1 = stco.toAtom(pa);
            if (ra1 != null) {
                if (pa1 == null) {
                    this.mapErrors.add("Map " + rMapInd + " atom types are inconsistent!");
                    continue;
                }
                if (ra1.getSymbol().equals(pa1.getSymbol())) continue;
                this.mapErrors.add("Map " + rMapInd + " atom types are inconsistent!");
                continue;
            }
            if (pa1 == null) continue;
            this.mapErrors.add("Map " + rMapInd + " atom types are inconsistent!");
        }
    }

    void registerMappings(String compType, QueryAtomContainer globalContainer, QueryAtomContainer fragment, int curFragNum, Vector<Integer> mapIndex, Vector<Integer> notMappedAt, Vector<Integer> atFragNum, Vector<Integer> atGlobalNum, Vector<Integer> fragNum) {
        for (int i = 0; i < fragment.getAtomCount(); ++i) {
            int globalAtNum;
            IAtom a = fragment.getAtom(i);
            Integer iObj = (Integer)a.getProperty((Object)"SmirksMapIndex");
            if (iObj != null) {
                if (this.containsInteger(mapIndex, iObj)) {
                    this.mapErrors.add(compType + " Map Index " + iObj + " is repeated!");
                    continue;
                }
                mapIndex.add(iObj);
                atFragNum.add(new Integer(i));
                fragNum.add(new Integer(curFragNum));
                globalAtNum = globalContainer.getAtomNumber(a);
                atGlobalNum.add(new Integer(globalAtNum));
                continue;
            }
            globalAtNum = globalContainer.getAtomNumber(a);
            notMappedAt.add(new Integer(globalAtNum));
        }
    }

    void generateTransformationData() {
        int rAt2Num;
        int rAt1Num;
        int i;
        SmartsToChemObject stco = new SmartsToChemObject(this.builder);
        this.generateChargeTransformation();
        for (i = 0; i < this.reactant.getBondCount(); ++i) {
            IBond rb = this.reactant.getBond(i);
            IBond rb0 = stco.toBond(rb);
            IAtom ra1 = rb.getAtom(0);
            IAtom ra2 = rb.getAtom(1);
            Integer raMapInd1 = (Integer)ra1.getProperty((Object)"SmirksMapIndex");
            Integer raMapInd2 = (Integer)ra2.getProperty((Object)"SmirksMapIndex");
            if (raMapInd1 == null) {
                int rAt1Num2 = -this.reactant.getAtomNumber(ra1);
                if (raMapInd2 != null) continue;
            }
            if (raMapInd2 == null) continue;
            int pAt1Num = this.getMappedProductAtom(raMapInd1);
            int pAt2Num = this.getMappedProductAtom(raMapInd2);
            rAt1Num = this.reactant.getAtomNumber(ra1);
            rAt2Num = this.reactant.getAtomNumber(ra2);
            int pbNum = this.product.getBondNumber(this.product.getAtom(pAt1Num), this.product.getAtom(pAt2Num));
            boolean FlagRegisterTransform = false;
            if (pbNum == -1) {
                this.prodBo.add(null);
                FlagRegisterTransform = true;
            } else {
                IBond pb = this.product.getBond(pbNum);
                IBond pb0 = stco.toBond(pb);
                if (rb0 == null ? pb0 == null : pb0 == null) {
                    // empty if block
                }
                if (rb0.getOrder() != pb0.getOrder()) {
                    FlagRegisterTransform = true;
                    this.prodBo.add(pb0.getOrder());
                }
            }
            if (!FlagRegisterTransform) continue;
            this.prodAt1.add(new Integer(pAt1Num));
            this.prodAt2.add(new Integer(pAt2Num));
            this.reactBo.add(rb0.getOrder());
            this.reactAt1.add(new Integer(rAt1Num));
            this.reactAt2.add(new Integer(rAt2Num));
        }
        for (i = 0; i < this.product.getBondCount(); ++i) {
            IBond pb = this.product.getBond(i);
            IBond pb0 = stco.toBond(pb);
            if (pb0 == null) {
                // empty if block
            }
            IAtom pa1 = pb.getAtom(0);
            IAtom pa2 = pb.getAtom(1);
            int pAt1Num = this.product.getAtomNumber(pa1);
            int pAt2Num = this.product.getAtomNumber(pa2);
            Integer paMapInd1 = (Integer)pa1.getProperty((Object)"SmirksMapIndex");
            Integer paMapInd2 = (Integer)pa2.getProperty((Object)"SmirksMapIndex");
            if (paMapInd1 == null) {
                if (paMapInd2 == null) {
                    this.prodBo.add(pb0.getOrder());
                    this.prodAt1.add(new Integer(pAt1Num));
                    this.prodAt2.add(new Integer(pAt2Num));
                    this.reactBo.add(null);
                    this.reactAt1.add(new Integer(-100000));
                    this.reactAt2.add(new Integer(-100000));
                    continue;
                }
                this.prodBo.add(pb0.getOrder());
                this.prodAt1.add(new Integer(pAt1Num));
                this.prodAt2.add(new Integer(pAt2Num));
                this.reactBo.add(null);
                this.reactAt1.add(new Integer(-100000));
                int rAt2Num2 = this.getMappedReactantAtom(paMapInd2);
                this.reactAt2.add(new Integer(rAt2Num2));
                continue;
            }
            if (paMapInd2 == null) {
                this.prodBo.add(pb0.getOrder());
                this.prodAt1.add(new Integer(pAt1Num));
                this.prodAt2.add(new Integer(pAt2Num));
                this.reactBo.add(null);
                rAt1Num = this.getMappedReactantAtom(paMapInd1);
                this.reactAt1.add(new Integer(rAt1Num));
                this.reactAt2.add(new Integer(-100000));
                continue;
            }
            rAt1Num = this.getMappedReactantAtom(paMapInd1);
            rAt2Num = this.getMappedReactantAtom(paMapInd2);
            int rbNum = this.reactant.getBondNumber(this.reactant.getAtom(rAt1Num), this.reactant.getAtom(rAt2Num));
            if (rbNum != -1) continue;
            this.prodBo.add(pb0.getOrder());
            this.prodAt1.add(new Integer(pAt1Num));
            this.prodAt2.add(new Integer(pAt2Num));
            this.reactBo.add(null);
            this.reactAt1.add(new Integer(rAt1Num));
            this.reactAt2.add(new Integer(rAt2Num));
        }
    }

    void generateChargeTransformation() {
        IAtom a;
        int i;
        SmartsToChemObject stco = new SmartsToChemObject(this.builder);
        for (i = 0; i < this.reactant.getAtomCount(); ++i) {
            a = stco.toAtom(this.reactant.getAtom(i));
            if (a == null) {
                this.reactantAtCharge.add(null);
                continue;
            }
            this.reactantAtCharge.add(a.getFormalCharge());
        }
        for (i = 0; i < this.product.getAtomCount(); ++i) {
            a = stco.toAtom(this.product.getAtom(i));
            if (a == null) {
                this.productAtCharge.add(null);
                continue;
            }
            this.productAtCharge.add(a.getFormalCharge());
        }
    }

    int getMappedProductAtom(Integer raMapInd) {
        int pIndex = this.getIntegerObjectIndex(this.productMapIndex, raMapInd);
        int pGlobAtNum = this.productAtomNum.get(pIndex);
        return pGlobAtNum;
    }

    int getMappedReactantAtom(Integer paMapInd) {
        int rIndex = this.getIntegerObjectIndex(this.reactantMapIndex, paMapInd);
        int rGlobAtNum = this.reactantAtomNum.get(rIndex);
        return rGlobAtNum;
    }

    int getTransformationReactantBondIndex(int nBondsToCheck, int rAt1, int rAt2) {
        for (int i = 0; i < nBondsToCheck; ++i) {
            if (this.reactAt1.get(i) == rAt1 && this.reactAt2.get(i) == rAt2) {
                return i;
            }
            if (this.reactAt1.get(i) != rAt2 || this.reactAt2.get(i) != rAt1) continue;
            return i;
        }
        return -1;
    }

    boolean containsInteger(Vector<Integer> v, Integer iObj) {
        for (int i = 0; i < v.size(); ++i) {
            if (iObj.intValue() != v.get(i).intValue()) continue;
            return true;
        }
        return false;
    }

    int getIntegerObjectIndex(Vector<Integer> v, Integer iObj) {
        for (int i = 0; i < v.size(); ++i) {
            Integer vi = v.get(i);
            if (iObj.intValue() != vi.intValue()) continue;
            return i;
        }
        return -1;
    }

    public String transformationDataToString() {
        int i;
        StringBuffer sb = new StringBuffer();
        System.out.println("Mappings:");
        for (i = 0; i < this.reactantMapIndex.size(); ++i) {
            Integer rMapInd = this.reactantMapIndex.get(i);
            int rGlobAtNum = this.reactantAtomNum.get(i);
            IAtom glob_ra = this.reactant.getAtom(rGlobAtNum);
            int pIndex = this.getIntegerObjectIndex(this.productMapIndex, rMapInd);
            int pGlobAtNum = this.productAtomNum.get(pIndex);
            IAtom glob_pa = this.product.getAtom(pGlobAtNum);
            System.out.println("Map #" + rMapInd + "     " + "at# " + rGlobAtNum + "  Charge = " + this.reactantAtCharge.get(rGlobAtNum) + "   -->  " + "at# " + pGlobAtNum + "  Charge = " + this.productAtCharge.get(pGlobAtNum) + "         pIndex = " + pIndex);
        }
        for (i = 0; i < this.prodBo.size(); ++i) {
            sb.append("BondTransform: (");
            sb.append(this.reactAt1.get(i) + ", ");
            sb.append(this.reactAt2.get(i) + ", ");
            String bo = this.reactBo.get(i) == null ? "null" : this.reactBo.get(i).toString();
            sb.append(bo + ")  -->  (");
            sb.append(this.prodAt1.get(i) + ", ");
            sb.append(this.prodAt2.get(i) + ", ");
            bo = this.prodBo.get(i) == null ? "null" : this.prodBo.get(i).toString();
            sb.append(bo.toString() + ")");
            sb.append("\n");
        }
        return sb.toString();
    }
}

