/*
 * Decompiled with CFR 0.152.
 */
package libpadel;

import com.jidesoft.combobox.FileChooserPanel;
import com.jidesoft.combobox.FileNameChooserExComboBox;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.converter.StringConverter;
import com.jidesoft.grid.CellEditorFactory;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.FileNameCellEditor;
import com.jidesoft.grid.Property;
import com.jidesoft.swing.JideSwingUtilities;
import java.io.File;
import javax.swing.CellEditor;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class PaDELFileProperty
extends Property {
    private Object value_;
    private CellEditorFactory cellEditor_;

    public PaDELFileProperty(String name, String description, String category) {
        super(name, description, String.class, category);
        this.setConverterContext(StringConverter.CONTEXT_FILENAME);
        this.setEditorContext(new EditorContext("Choose a file"));
        this.RegisterEditor(false, "Choose a file", false, null, null, null);
    }

    public PaDELFileProperty(String name, String description, String category, String defaultValue) {
        super(name, description, String.class, category);
        this.setConverterContext(StringConverter.CONTEXT_FILENAME);
        this.setEditorContext(new EditorContext("Choose a file"));
        this.setValue(defaultValue);
        this.RegisterEditor(false, "Choose a file", false, null, null, null);
    }

    public PaDELFileProperty(String name, String description, String category, String defaultValue, boolean isSaveDialog, String title, boolean includeDirectories, String[] extensions, String[] descriptions) {
        super(name, description, String.class, category);
        this.setConverterContext(StringConverter.CONTEXT_FILENAME);
        this.setEditorContext(new EditorContext(title));
        this.setValue(defaultValue);
        this.RegisterEditor(isSaveDialog, title, includeDirectories, extensions, descriptions, null);
    }

    public PaDELFileProperty(String name, String description, String category, String defaultValue, boolean isSaveDialog, String title, boolean includeDirectories, String[] extensions, String[] descriptions, String startDirectory) {
        super(name, description, String.class, category);
        this.setConverterContext(StringConverter.CONTEXT_FILENAME);
        this.setEditorContext(new EditorContext(title));
        this.setValue(defaultValue);
        this.RegisterEditor(isSaveDialog, title, includeDirectories, extensions, descriptions, startDirectory);
    }

    public void setValue(Object value) {
        Object old = this.getValue();
        if (!JideSwingUtilities.equals((Object)old, (Object)value)) {
            this.value_ = value;
            this.firePropertyChange("value", old, value);
        }
    }

    public Object getValue() {
        return this.value_;
    }

    private void RegisterEditor(final boolean isSaveDialog, final String title, final boolean includeDirectories, final String[] extensions, final String[] descriptions, final String startDirectory) {
        CellEditorManager.unregisterEditor(String.class, (EditorContext)new EditorContext(title));
        this.cellEditor_ = new CellEditorFactory(){

            public CellEditor create() {
                return new FileNameCellEditor(){

                    protected FileNameChooserExComboBox createFileNameChooserComboBox() {
                        FileNameChooserExComboBox comboBox = new FileNameChooserExComboBox(){

                            public PopupPanel createPopupComponent() {
                                FileChooserPanel panel = new FileChooserPanel("" + this.getSelectedItem()){

                                    protected JFileChooser createFileChooser() {
                                        String startPath = startDirectory != null ? startDirectory : this.getCurrentDirectoryPath();
                                        JFileChooser fileChooser = new JFileChooser(startPath);
                                        if (isSaveDialog) {
                                            fileChooser.setDialogType(1);
                                        } else {
                                            fileChooser.setDialogType(0);
                                        }
                                        if (includeDirectories) {
                                            fileChooser.setFileSelectionMode(2);
                                        } else {
                                            fileChooser.setFileSelectionMode(0);
                                        }
                                        if (extensions != null && descriptions != null && extensions.length == descriptions.length) {
                                            int endi = extensions.length;
                                            for (int i = 0; i < endi; ++i) {
                                                final String extension = extensions[i];
                                                final String description = descriptions[i];
                                                fileChooser.addChoosableFileFilter(new FileFilter(){

                                                    public boolean accept(File f) {
                                                        return f.isDirectory() || f.getName().endsWith(extension);
                                                    }

                                                    public String getDescription() {
                                                        return description;
                                                    }
                                                });
                                            }
                                        }
                                        try {
                                            fileChooser.setSelectedFile(new File(this.getCurrentDirectoryPath()));
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        return fileChooser;
                                    }
                                };
                                panel.setTitle(title);
                                return panel;
                            }
                        };
                        comboBox.setEditable(true);
                        return comboBox;
                    }
                };
            }
        };
        CellEditorManager.registerEditor(String.class, (CellEditorFactory)this.cellEditor_, (EditorContext)new EditorContext(title));
    }
}

