/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.tools.LoggingTool;

public abstract class FilesWithHeaderWriter
extends DefaultChemObjectWriter {
    protected static LoggingTool logger = new LoggingTool(FilesWithHeaderWriter.class);
    public static String defaultSMILESHeader = "SMILES";
    protected ArrayList header = null;
    protected boolean writingStarted = false;
    protected int smilesIndex = -1;

    public synchronized ArrayList getHeader() {
        return this.header;
    }

    public void setHeader(Map map) {
        if (this.writingStarted) {
            logger.error((Object)"Can't change header while writing !!!!");
            return;
        }
        this.header = new ArrayList();
        Iterator iterator = map.keySet().iterator();
        this.smilesIndex = -1;
        int n = 0;
        while (iterator.hasNext()) {
            this.header.add(iterator.next());
            if (this.header.get(n).equals(defaultSMILESHeader)) {
                this.smilesIndex = n;
            }
            ++n;
        }
        if (this.smilesIndex == -1) {
            this.header.add(0, defaultSMILESHeader);
            this.smilesIndex = 0;
        }
        logger.info((Object)"Header created from hashtable\t", new Object[]{this.header});
    }

    protected abstract void writeHeader() throws IOException;

    public synchronized void setHeader(ArrayList arrayList) {
        if (this.writingStarted) {
            logger.error((Object)"Can't change header while writing !!!!");
            return;
        }
        this.header = arrayList;
        this.smilesIndex = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).equals(defaultSMILESHeader)) continue;
            this.smilesIndex = i;
        }
        if (this.smilesIndex == -1) {
            arrayList.add(0, defaultSMILESHeader);
            this.smilesIndex = 0;
        }
        logger.info((Object)"Header created\t", new Object[]{arrayList});
    }
}

