/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UTFDataFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import nu.xom.Document;
import nu.xom.NodeFactory;
import nu.xom.NonVerifyingHandler;
import nu.xom.ParsingException;
import nu.xom.URIUtil;
import nu.xom.ValidityException;
import nu.xom.XML1_0Parser;
import nu.xom.XMLException;
import nu.xom.XOMHandler;
import org.apache.xerces.impl.Version;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Builder {
    private XMLReader parser;
    private NodeFactory factory;
    private static double xercesVersion = 2.6;
    private static String[] parsers;
    private static String fileURLPrefix;

    public Builder() {
        this(false);
    }

    public Builder(boolean validate) {
        this(Builder.findParser(validate), validate, null);
    }

    public Builder(boolean validate, NodeFactory factory) {
        this(Builder.findParser(validate), validate, factory);
    }

    static XMLReader findParser(boolean validate) {
        try {
            XML1_0Parser parser = new XML1_0Parser();
            Builder.setupParser((XMLReader)((Object)parser), validate);
            return parser;
        }
        catch (SAXException ex) {
        }
        catch (NoClassDefFoundError err) {
            // empty catch block
        }
        try {
            XMLReader parser = (XMLReader)Class.forName("nu.xom.JDK15XML1_0Parser").newInstance();
            Builder.setupParser(parser, validate);
            return parser;
        }
        catch (SAXException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (ClassNotFoundException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (NoClassDefFoundError err) {
            // empty catch block
        }
        for (int i = 2; i < parsers.length; ++i) {
            try {
                XMLReader parser = XMLReaderFactory.createXMLReader(parsers[i]);
                Builder.setupParser(parser, validate);
                return parser;
            }
            catch (SAXException ex) {
                continue;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            Builder.setupParser(parser, validate);
            return parser;
        }
        catch (SAXException ex) {
            throw new XMLException("Could not find a suitable SAX2 parser", ex);
        }
    }

    private static void setupParser(XMLReader parser, boolean validate) throws SAXNotRecognizedException, SAXNotSupportedException {
        XMLReader parent;
        XMLReader baseParser = parser;
        while (baseParser instanceof XMLFilter && (parent = ((XMLFilter)baseParser).getParent()) != null) {
            baseParser = parent;
        }
        String parserName = baseParser.getClass().getName();
        if (!validate) {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            if (parserName.equals("org.apache.crimson.parser.XMLReaderImpl")) {
                parser.setErrorHandler(new NamespaceWellformednessRequired());
            } else {
                parser.setFeature("http://xml.org/sax/features/external-general-entities", true);
                parser.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
            }
        } else {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setErrorHandler(new ValidityRequired());
        }
        try {
            parser.setFeature("http://xml.org/sax/features/string-interning", true);
        }
        catch (SAXException ex) {
            // empty catch block
        }
        if (parserName.equals("nu.xom.XML1_0Parser") || parserName.equals("nu.xom.JDK15XML1_0Parser") || parserName.equals("org.apache.xerces.parsers.SAXParser") || parserName.equals("com.sun.org.apache.xerces.internal.parsers.SAXParser")) {
            try {
                parser.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (SAXException ex) {
                // empty catch block
            }
            try {
                parser.setFeature("http://apache.org/xml/features/standard-uri-conformant", true);
            }
            catch (SAXException ex) {
                // empty catch block
            }
        }
    }

    public Builder(XMLReader parser) {
        this(parser, false);
    }

    public Builder(NodeFactory factory) {
        this(Builder.findParser(false), false, factory);
    }

    public Builder(XMLReader parser, boolean validate) {
        this(parser, validate, null);
    }

    public Builder(XMLReader parser, boolean validate, NodeFactory factory) {
        try {
            Builder.setupParser(parser, validate);
        }
        catch (SAXException ex) {
            if (validate) {
                throw new XMLException(parser.getClass().getName() + " does not support validation.", ex);
            }
            throw new XMLException(parser.getClass().getName() + " does not support the entity resolution" + " features XOM requires.", ex);
        }
        this.parser = parser;
        this.factory = factory;
        this.setHandlers();
    }

    private static boolean knownGoodParser(XMLReader parser) {
        String parserName = parser.getClass().getName();
        if (parserName.equals("org.apache.xml.resolver.tools.ResolvingXMLFilter")) {
            XMLFilter filter = (XMLFilter)parser;
            parserName = filter.getParent().getClass().getName();
        }
        if (parserName.equals("gnu.xml.aelfred2.XmlReader")) {
            return false;
        }
        if (parserName.equals("net.sf.saxon.aelfred.SAXDriver")) {
            return false;
        }
        if (parserName.equals("com.icl.saxon.aelfred.SAXDriver")) {
            return false;
        }
        if (parserName.equals("org.apache.xerces.parsers.SAXParser") && xercesVersion >= 2.4) {
            return false;
        }
        for (int i = 0; i < parsers.length; ++i) {
            if (!parserName.equals(parsers[i])) continue;
            return true;
        }
        return false;
    }

    private void setHandlers() {
        XOMHandler handler;
        if ((this.factory == null || this.factory.getClass().getName().equals("nu.xom.NodeFactory")) && Builder.knownGoodParser(this.parser)) {
            NodeFactory tempFactory = this.factory;
            if (tempFactory == null) {
                tempFactory = new NodeFactory();
            }
            handler = new NonVerifyingHandler(tempFactory);
        } else {
            if (this.factory == null) {
                this.factory = new NodeFactory();
            }
            handler = new XOMHandler(this.factory);
        }
        this.parser.setContentHandler(handler);
        this.parser.setDTDHandler(handler);
        try {
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        }
        catch (SAXException ex) {
            // empty catch block
        }
        try {
            this.parser.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
            if (this.parser.getClass().getName().equals("org.apache.crimson.parser.XMLReaderImpl")) {
                handler.usingCrimson = true;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public Document build(String systemID) throws ParsingException, ValidityException, IOException {
        systemID = this.canonicalizeURL(systemID);
        InputSource source = new InputSource(systemID);
        return this.build(source);
    }

    public Document build(InputStream in) throws ParsingException, ValidityException, IOException {
        InputSource source = new InputSource(in);
        return this.build(source);
    }

    public Document build(InputStream in, String baseURI) throws ParsingException, ValidityException, IOException {
        baseURI = this.canonicalizeURL(baseURI);
        InputSource source = new InputSource(in);
        source.setSystemId(baseURI);
        return this.build(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document build(File in) throws ParsingException, ValidityException, IOException {
        FileInputStream fin = new FileInputStream(in);
        String absolute = in.getAbsolutePath();
        StringBuffer url = new StringBuffer(fileURLPrefix);
        int length = absolute.length();
        char separatorChar = File.separatorChar;
        block102: for (int i = 0; i < length; ++i) {
            char c = absolute.charAt(i);
            if (c == separatorChar) {
                url.append('/');
                continue;
            }
            switch (c) {
                case ' ': {
                    url.append("%20");
                    continue block102;
                }
                case '!': {
                    url.append(c);
                    continue block102;
                }
                case '\"': {
                    url.append("%22");
                    continue block102;
                }
                case '#': {
                    url.append("%23");
                    continue block102;
                }
                case '$': {
                    url.append(c);
                    continue block102;
                }
                case '%': {
                    url.append("%25");
                    continue block102;
                }
                case '&': {
                    url.append('&');
                    continue block102;
                }
                case '\'': {
                    url.append(c);
                    continue block102;
                }
                case '(': {
                    url.append(c);
                    continue block102;
                }
                case ')': {
                    url.append(c);
                    continue block102;
                }
                case '*': {
                    url.append(c);
                    continue block102;
                }
                case '+': {
                    url.append("%2B");
                    continue block102;
                }
                case ',': {
                    url.append(c);
                    continue block102;
                }
                case '-': {
                    url.append(c);
                    continue block102;
                }
                case '.': {
                    url.append(c);
                    continue block102;
                }
                case '/': {
                    url.append("%2F");
                    continue block102;
                }
                case '0': {
                    url.append(c);
                    continue block102;
                }
                case '1': {
                    url.append(c);
                    continue block102;
                }
                case '2': {
                    url.append(c);
                    continue block102;
                }
                case '3': {
                    url.append(c);
                    continue block102;
                }
                case '4': {
                    url.append(c);
                    continue block102;
                }
                case '5': {
                    url.append(c);
                    continue block102;
                }
                case '6': {
                    url.append(c);
                    continue block102;
                }
                case '7': {
                    url.append(c);
                    continue block102;
                }
                case '8': {
                    url.append(c);
                    continue block102;
                }
                case '9': {
                    url.append(c);
                    continue block102;
                }
                case ':': {
                    url.append(c);
                    continue block102;
                }
                case ';': {
                    url.append(c);
                    continue block102;
                }
                case '<': {
                    url.append("%3C");
                    continue block102;
                }
                case '=': {
                    url.append(c);
                    continue block102;
                }
                case '>': {
                    url.append("%3E");
                    continue block102;
                }
                case '?': {
                    url.append("%3F");
                    continue block102;
                }
                case '@': {
                    url.append("%40");
                    continue block102;
                }
                case 'A': {
                    url.append(c);
                    continue block102;
                }
                case 'B': {
                    url.append(c);
                    continue block102;
                }
                case 'C': {
                    url.append(c);
                    continue block102;
                }
                case 'D': {
                    url.append(c);
                    continue block102;
                }
                case 'E': {
                    url.append(c);
                    continue block102;
                }
                case 'F': {
                    url.append(c);
                    continue block102;
                }
                case 'G': {
                    url.append(c);
                    continue block102;
                }
                case 'H': {
                    url.append(c);
                    continue block102;
                }
                case 'I': {
                    url.append(c);
                    continue block102;
                }
                case 'J': {
                    url.append(c);
                    continue block102;
                }
                case 'K': {
                    url.append(c);
                    continue block102;
                }
                case 'L': {
                    url.append(c);
                    continue block102;
                }
                case 'M': {
                    url.append(c);
                    continue block102;
                }
                case 'N': {
                    url.append(c);
                    continue block102;
                }
                case 'O': {
                    url.append(c);
                    continue block102;
                }
                case 'P': {
                    url.append(c);
                    continue block102;
                }
                case 'Q': {
                    url.append(c);
                    continue block102;
                }
                case 'R': {
                    url.append(c);
                    continue block102;
                }
                case 'S': {
                    url.append(c);
                    continue block102;
                }
                case 'T': {
                    url.append(c);
                    continue block102;
                }
                case 'U': {
                    url.append(c);
                    continue block102;
                }
                case 'V': {
                    url.append(c);
                    continue block102;
                }
                case 'W': {
                    url.append(c);
                    continue block102;
                }
                case 'X': {
                    url.append(c);
                    continue block102;
                }
                case 'Y': {
                    url.append(c);
                    continue block102;
                }
                case 'Z': {
                    url.append(c);
                    continue block102;
                }
                case '[': {
                    url.append("%5B");
                    continue block102;
                }
                case '\\': {
                    url.append("%5C");
                    continue block102;
                }
                case ']': {
                    url.append("%5D");
                    continue block102;
                }
                case '^': {
                    url.append("%5E");
                    continue block102;
                }
                case '_': {
                    url.append(c);
                    continue block102;
                }
                case '`': {
                    url.append("%60");
                    continue block102;
                }
                case 'a': {
                    url.append(c);
                    continue block102;
                }
                case 'b': {
                    url.append(c);
                    continue block102;
                }
                case 'c': {
                    url.append(c);
                    continue block102;
                }
                case 'd': {
                    url.append(c);
                    continue block102;
                }
                case 'e': {
                    url.append(c);
                    continue block102;
                }
                case 'f': {
                    url.append(c);
                    continue block102;
                }
                case 'g': {
                    url.append(c);
                    continue block102;
                }
                case 'h': {
                    url.append(c);
                    continue block102;
                }
                case 'i': {
                    url.append(c);
                    continue block102;
                }
                case 'j': {
                    url.append(c);
                    continue block102;
                }
                case 'k': {
                    url.append(c);
                    continue block102;
                }
                case 'l': {
                    url.append(c);
                    continue block102;
                }
                case 'm': {
                    url.append(c);
                    continue block102;
                }
                case 'n': {
                    url.append(c);
                    continue block102;
                }
                case 'o': {
                    url.append(c);
                    continue block102;
                }
                case 'p': {
                    url.append(c);
                    continue block102;
                }
                case 'q': {
                    url.append(c);
                    continue block102;
                }
                case 'r': {
                    url.append(c);
                    continue block102;
                }
                case 's': {
                    url.append(c);
                    continue block102;
                }
                case 't': {
                    url.append(c);
                    continue block102;
                }
                case 'u': {
                    url.append(c);
                    continue block102;
                }
                case 'v': {
                    url.append(c);
                    continue block102;
                }
                case 'w': {
                    url.append(c);
                    continue block102;
                }
                case 'x': {
                    url.append(c);
                    continue block102;
                }
                case 'y': {
                    url.append(c);
                    continue block102;
                }
                case 'z': {
                    url.append(c);
                    continue block102;
                }
                case '{': {
                    url.append("%7B");
                    continue block102;
                }
                case '|': {
                    url.append("%7C");
                    continue block102;
                }
                case '}': {
                    url.append("%7D");
                    continue block102;
                }
                case '~': {
                    url.append(c);
                    continue block102;
                }
                default: {
                    if (c < '\ud800' || c > '\udfff') {
                        url.append(URIUtil.percentEscape(c));
                        continue block102;
                    }
                    if (c <= '\udbff') {
                        ++i;
                        try {
                            char low = absolute.charAt(i);
                            String character = String.valueOf(c) + String.valueOf(low);
                            byte[] data = character.getBytes("UTF8");
                            for (int j = 0; j < 4; ++j) {
                                url.append('%');
                                String hex = Integer.toHexString(data[j]).toUpperCase();
                                url.append(hex.substring(hex.length() - 2));
                            }
                            continue block102;
                        }
                        catch (IndexOutOfBoundsException ex) {
                            url = new StringBuffer(0);
                            continue block102;
                        }
                    }
                    url = new StringBuffer(0);
                }
            }
        }
        String base = url.toString();
        try {
            Document doc;
            Document document = doc = this.build(fin, base);
            return document;
        }
        finally {
            ((InputStream)fin).close();
        }
    }

    public Document build(Reader in) throws ParsingException, ValidityException, IOException {
        InputSource source = new InputSource(in);
        return this.build(source);
    }

    public Document build(Reader in, String baseURI) throws ParsingException, ValidityException, IOException {
        baseURI = this.canonicalizeURL(baseURI);
        InputSource source = new InputSource(in);
        source.setSystemId(baseURI);
        return this.build(source);
    }

    public Document build(String document, String baseURI) throws ParsingException, ValidityException, IOException {
        StringReader reader = new StringReader(document);
        return this.build(reader, baseURI);
    }

    private String canonicalizeURL(String uri) {
        try {
            URL u = new URL(uri);
            String path = u.getFile();
            if (path == null || path.length() == 0 || "/".equals(path) && !uri.endsWith("/")) {
                uri = uri + '/';
            }
            return uri;
        }
        catch (MalformedURLException ex) {
            return uri;
        }
    }

    private Document build(InputSource in) throws ParsingException, ValidityException, IOException {
        ValidityRequired validityHandler;
        ErrorHandler errorHandler;
        XOMHandler handler = (XOMHandler)this.parser.getContentHandler();
        Document result = null;
        try {
            this.parser.parse(in);
            result = handler.getDocument();
        }
        catch (SAXParseException ex) {
            ParsingException pex = new ParsingException(ex.getMessage(), ex.getSystemId(), ex.getLineNumber(), ex.getColumnNumber(), ex);
            throw pex;
        }
        catch (SAXException ex) {
            ParsingException pex = new ParsingException(ex.getMessage(), in.getSystemId(), ex);
            throw pex;
        }
        catch (XMLException ex) {
            throw new ParsingException(ex.getMessage(), ex);
        }
        catch (RuntimeException ex) {
            ParsingException pex = new ParsingException(ex.getMessage(), in.getSystemId(), ex);
            throw pex;
        }
        catch (UTFDataFormatException ex) {
            ParsingException pex = new ParsingException(ex.getMessage(), in.getSystemId(), ex);
            throw pex;
        }
        catch (CharConversionException ex) {
            ParsingException pex = new ParsingException(ex.getMessage(), in.getSystemId(), ex);
            throw pex;
        }
        catch (IOException ex) {
            if (ex.getClass().getName().equals("org.apache.xerces.util.URI$MalformedURIException")) {
                throw new ParsingException(ex.getMessage(), in.getSystemId(), ex);
            }
            throw ex;
        }
        finally {
            handler.freeMemory();
        }
        if (result == null) {
            ParsingException ex = new ParsingException("Parser did not build document", in.getSystemId(), -1, -1);
            throw ex;
        }
        if ("".equals(result.getBaseURI())) {
            result.setBaseURI(in.getSystemId());
        }
        if ((errorHandler = this.parser.getErrorHandler()) instanceof ValidityRequired && !(validityHandler = (ValidityRequired)errorHandler).isValid()) {
            ValidityException vex = validityHandler.vexception;
            vex.setDocument(result);
            validityHandler.reset();
            throw vex;
        }
        return result;
    }

    public NodeFactory getNodeFactory() {
        return this.factory;
    }

    static {
        try {
            String versionString = Version.getVersion();
            versionString = versionString.substring(9, 12);
            xercesVersion = Double.valueOf(versionString);
        }
        catch (Exception ex) {
        }
        catch (Error err) {
            // empty catch block
        }
        parsers = new String[]{"nu.xom.XML1_0Parser", "nu.xom.JDK15XML1_0Parser", "org.apache.xerces.parsers.SAXParser", "com.sun.org.apache.xerces.internal.parsers.SAXParser", "gnu.xml.aelfred2.XmlReader", "org.apache.crimson.parser.XMLReaderImpl", "com.bluecast.xml.Piccolo", "oracle.xml.parser.v2.SAXParser", "com.jclark.xml.sax.SAX2Driver", "net.sf.saxon.aelfred.SAXDriver", "com.icl.saxon.aelfred.SAXDriver", "org.dom4j.io.aelfred2.SAXDriver", "org.dom4j.io.aelfred.SAXDriver"};
        fileURLPrefix = "file://";
        String os = System.getProperty("os.name", "Unix");
        if (os.indexOf("Windows") >= 0) {
            fileURLPrefix = "file:/";
        }
    }

    private static class NamespaceWellformednessRequired
    implements ErrorHandler {
        private NamespaceWellformednessRequired() {
        }

        public void warning(SAXParseException exception) {
        }

        public void error(SAXParseException exception) throws SAXParseException {
            if (exception.getMessage().equals("Illegal Namespace prefix: \"xml\".")) {
                return;
            }
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXParseException {
            throw exception;
        }
    }

    private static class ValidityRequired
    implements ErrorHandler {
        ValidityException vexception = null;

        private ValidityRequired() {
        }

        void reset() {
            this.vexception = null;
        }

        public void warning(SAXParseException exception) {
        }

        public void error(SAXParseException exception) {
            if (this.vexception == null) {
                this.vexception = new ValidityException(exception.getMessage(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception);
            }
            this.vexception.addError(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXParseException {
            throw exception;
        }

        boolean isValid() {
            return this.vexception == null;
        }
    }
}

