/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.core.groups.SuppleAtomContainer;
import java.util.Iterator;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public class StructureTypeProcessor
extends DefaultAmbitProcessor<IAtomContainer, IStructureRecord.STRUC_TYPE> {
    private static final long serialVersionUID = 470417245691484159L;

    public IStructureRecord.STRUC_TYPE process(IAtomContainer iAtomContainer) throws AmbitException {
        if (iAtomContainer == null) {
            return IStructureRecord.STRUC_TYPE.NA;
        }
        if (iAtomContainer.getAtomCount() == 0) {
            return IStructureRecord.STRUC_TYPE.NA;
        }
        if (iAtomContainer instanceof SuppleAtomContainer) {
            return IStructureRecord.STRUC_TYPE.MARKUSH;
        }
        if (StructureTypeProcessor.hasHydrogens(iAtomContainer)) {
            if (StructureTypeProcessor.has2DCoordinates(iAtomContainer) > 0) {
                return IStructureRecord.STRUC_TYPE.D2withH;
            }
            if (StructureTypeProcessor.has3DCoordinates(iAtomContainer)) {
                return IStructureRecord.STRUC_TYPE.D3withH;
            }
            return IStructureRecord.STRUC_TYPE.D1;
        }
        if (StructureTypeProcessor.has2DCoordinates(iAtomContainer) > 0) {
            return IStructureRecord.STRUC_TYPE.D2noH;
        }
        if (StructureTypeProcessor.has3DCoordinates(iAtomContainer)) {
            return IStructureRecord.STRUC_TYPE.D3noH;
        }
        return IStructureRecord.STRUC_TYPE.D1;
    }

    public static boolean hasHydrogens(IAtomContainer iAtomContainer) {
        Iterator iterator = iAtomContainer.atoms().iterator();
        while (iterator.hasNext()) {
            if (!((IAtom)iterator.next()).getSymbol().equals("H")) continue;
            return true;
        }
        return false;
    }

    public static boolean has3DCoordinates(IAtomContainer iAtomContainer) {
        Iterator iterator = iAtomContainer.atoms().iterator();
        while (iterator.hasNext()) {
            if (((IAtom)iterator.next()).getPoint3d() == null) continue;
            return true;
        }
        return false;
    }

    public static int has2DCoordinates(IAtomContainer iAtomContainer) {
        if (iAtomContainer == null) {
            return 0;
        }
        Point2d point2d = null;
        Point2d point2d2 = null;
        boolean bl = false;
        boolean bl2 = false;
        for (IAtom iAtom : iAtomContainer.atoms()) {
            Point2d point2d3 = iAtom.getPoint2d();
            if (point2d3 == null) {
                bl = true;
                continue;
            }
            if (point2d == null) {
                point2d = new Point2d();
                point2d.set(point2d3.x, point2d3.y);
            } else {
                if (point2d3.x < point2d.x) {
                    point2d.x = point2d3.x;
                }
                if (point2d3.y < point2d.y) {
                    point2d.y = point2d3.y;
                }
            }
            if (point2d2 == null) {
                point2d2 = new Point2d();
                point2d2.set(point2d3.x, point2d3.y);
            } else {
                if (point2d3.x > point2d2.x) {
                    point2d2.x = point2d3.x;
                }
                if (point2d3.y > point2d2.y) {
                    point2d2.y = point2d3.y;
                }
            }
            bl2 = true;
        }
        if (point2d != null && point2d2 != null) {
            boolean bl3 = bl2 = point2d.x - point2d2.x == 0.0 && point2d.y - point2d2.y == 0.0 ? false : bl2;
        }
        if (!bl && bl2) {
            return 2;
        }
        if (bl && bl2) {
            return 1;
        }
        return 0;
    }
}

